/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.pannable.base;

import com.jfoenix.controls.pannable.base.IObservableObject;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ResilientObservable<L>
implements IObservableObject<L> {
    private CopyOnWriteArrayList<WeakObject<L>> listeners = new CopyOnWriteArrayList();

    @Override
    public boolean addListener(L l2) {
        return this.listeners.add(new WeakObject(l2));
    }

    @Override
    public boolean removeListener(L l2) {
        return this.listeners.remove(new WeakObject(l2));
    }

    public void fireEvent(Consumer<L> consumer) {
        ArrayList<WeakObject<L>> arrayList = new ArrayList<WeakObject<L>>();
        for (WeakObject<L> weakObject : this.listeners) {
            try {
                Object t2 = weakObject.get();
                if (t2 != null) {
                    consumer.accept(t2);
                    continue;
                }
                arrayList.add(weakObject);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                arrayList.add(weakObject);
            }
        }
        this.listeners.removeAll(arrayList);
    }

    public Collection<L> listeners() {
        return Collections.unmodifiableCollection(this.listeners.stream().map(Reference::get).collect(Collectors.toList()));
    }

    private static class WeakObject<T>
    extends WeakReference<T> {
        private WeakObject(T t2) {
            super(t2);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof WeakObject)) {
                return false;
            }
            return ((WeakObject)object).get() == this.get();
        }
    }
}

