/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.cells.editors.TextFieldEditorBuilder;
import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.controls.cells.editors.base.JFXTreeTableCell;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;

public class GenericEditableTreeTableCell<S, T>
extends JFXTreeTableCell<S, T> {
    protected EditorNodeBuilder builder;
    protected Region editorNode;
    protected Consumer<Exception> commitExceptionConsumer = null;
    private BiFunction<Integer, Integer, Integer> stepFunction = (n2, n3) -> 0;

    public GenericEditableTreeTableCell() {
        this(new TextFieldEditorBuilder());
    }

    public GenericEditableTreeTableCell(EditorNodeBuilder editorNodeBuilder) {
        this(editorNodeBuilder, null);
    }

    public GenericEditableTreeTableCell(EditorNodeBuilder editorNodeBuilder, Consumer<Exception> consumer) {
        this.builder = editorNodeBuilder;
        this.commitExceptionConsumer = consumer;
    }

    protected void commitHelper(boolean bl2) {
        block4: {
            if (this.editorNode == null) {
                return;
            }
            try {
                this.builder.validateValue();
                this.commitEdit(this.builder.getValue());
                this.builder.nullEditorNode();
                this.editorNode = null;
            }
            catch (Exception exception) {
                if (this.commitExceptionConsumer != null) {
                    this.commitExceptionConsumer.accept(exception);
                }
                if (!bl2) break block4;
                this.cancelEdit();
            }
        }
    }

    protected Object getValue() {
        return this.getItem();
    }

    public void startEdit() {
        if (this.isEditable() && this.checkGroupedColumn()) {
            super.startEdit();
            if (this.editorNode == null) {
                this.createEditorNode();
            } else {
                this.builder.setValue(this.getValue());
            }
            this.builder.startEdit();
            this.setGraphic((Node)this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }

    public void cancelEdit() {
        this.editorNode = null;
        super.cancelEdit();
        this.builder.cancelEdit();
        this.builder.setValue(this.getValue());
        this.builder.nullEditorNode();
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    private boolean checkGroupedColumn() {
        boolean bl2 = true;
        if (this.getTreeTableRow().getTreeItem() != null) {
            Object object = this.getTreeTableRow().getTreeItem().getValue();
            if (object instanceof RecursiveTreeObject && object.getClass() == RecursiveTreeObject.class) {
                bl2 = false;
            } else if (this.getTableColumn() instanceof JFXTreeTableColumn && ((JFXTreeTableColumn)this.getTableColumn()).isGrouped() && this.getTreeTableRow().getTreeItem().getParent() != null && this.getTreeTableRow().getTreeItem().getParent().getValue().getClass() == RecursiveTreeObject.class) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public void updateItem(T t2, boolean bl2) {
        super.updateItem(t2, bl2);
        if (bl2) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing() && this.checkGroupedColumn()) {
            if (this.editorNode != null) {
                this.builder.setValue(this.getValue());
            }
            this.setGraphic((Node)this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.builder.updateItem(t2, bl2);
        } else {
            Object object = this.getValue();
            if (object instanceof Node) {
                this.setGraphic((Node)object);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(object == null ? null : String.valueOf(object));
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createEditorNode() {
        EventHandler eventHandler = keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.commitHelper(false);
            } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
            } else if (keyEvent.getCode() == KeyCode.TAB) {
                this.commitHelper(false);
                this.editNext(!keyEvent.isShiftDown());
            }
        };
        ChangeListener changeListener = (observableValue, bl2, bl3) -> {
            if (this.editorNode != null && !bl3.booleanValue()) {
                this.commitHelper(true);
            }
        };
        this.editorNode = this.builder.createNode(this.getValue(), (EventHandler<KeyEvent>)eventHandler, (ChangeListener<Boolean>)changeListener);
    }

    public BiFunction<Integer, Integer, Integer> getStepFunction() {
        return this.stepFunction;
    }

    public void setStepFunction(BiFunction<Integer, Integer, Integer> biFunction) {
        this.stepFunction = biFunction;
    }

    private void editNext(boolean bl2) {
        ArrayList arrayList = new ArrayList();
        for (TreeTableColumn treeTableColumn : this.getTreeTableView().getColumns()) {
            arrayList.addAll(this.getLeaves(treeTableColumn));
        }
        int n2 = this.getIndex();
        int n3 = arrayList.indexOf(this.getTableColumn());
        if (bl2) {
            if (++n3 > arrayList.size() - 1) {
                n3 = 0;
                n2 += this.stepFunction.apply(n2, 1).intValue();
            }
        } else if (--n3 < 0) {
            n3 = arrayList.size() - 1;
            n2 += this.stepFunction.apply(n2, -1).intValue();
        }
        if (arrayList.size() < 2 && n2 == this.getIndex()) {
            return;
        }
        TreeTableColumn treeTableColumn = (TreeTableColumn)arrayList.get(n3);
        if (treeTableColumn != null) {
            this.getTreeTableView().edit(n2, treeTableColumn);
            this.getTreeTableView().scrollToColumn(treeTableColumn);
        }
    }

    private List<TreeTableColumn<S, ?>> getLeaves(TreeTableColumn<S, ?> treeTableColumn) {
        ArrayList arrayList = new ArrayList();
        if (treeTableColumn.getColumns().isEmpty()) {
            if (treeTableColumn.isEditable()) {
                arrayList.add(treeTableColumn);
            }
            return arrayList;
        }
        for (TreeTableColumn treeTableColumn2 : treeTableColumn.getColumns()) {
            arrayList.addAll(this.getLeaves(treeTableColumn2));
        }
        return arrayList;
    }
}

