/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors;

import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;

public abstract class TextFieldEditorBase<T>
implements EditorNodeBuilder<T> {
    protected JFXTextField textField;
    protected final ValidatorBase[] validators;

    public TextFieldEditorBase(ValidatorBase ... validatorBaseArray) {
        this.validators = validatorBaseArray;
    }

    @Override
    public void startEdit() {
        Platform.runLater(() -> {
            this.textField.selectAll();
            this.textField.requestFocus();
        });
    }

    @Override
    public void cancelEdit() {
    }

    @Override
    public void updateItem(T t2, boolean bl2) {
        Platform.runLater(() -> {
            this.textField.selectAll();
            this.textField.requestFocus();
        });
    }

    @Override
    public Region createNode(T t2, EventHandler<KeyEvent> eventHandler, ChangeListener<Boolean> changeListener) {
        this.textField = t2 == null ? new JFXTextField() : new JFXTextField(String.valueOf(t2));
        this.textField.setOnKeyPressed(eventHandler);
        this.textField.getValidators().addAll((Object[])this.validators);
        this.textField.focusedProperty().addListener(changeListener);
        return this.textField;
    }

    @Override
    public void setValue(T t2) {
        this.textField.setText(t2 == null ? null : String.valueOf(t2));
    }

    @Override
    public void validateValue() throws Exception {
        if (!this.textField.validate()) {
            throw new Exception("Invalid value");
        }
    }

    @Override
    public void nullEditorNode() {
        this.textField = null;
    }
}

