/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXScrollPane;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.utils.JFXNodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;

public class JFXTreeViewPath
extends ScrollPane {
    private PseudoClass firstClass = PseudoClass.getPseudoClass((String)"first");
    private PseudoClass nextClass = PseudoClass.getPseudoClass((String)"next");
    private PseudoClass lastClass = PseudoClass.getPseudoClass((String)"last");
    private Region clip = new Region();
    private HBox container = new HBox();
    private double lastX;
    private static final String DEFAULT_STYLE_CLASS = "jfx-tree-view-path";
    private StyleableDoubleProperty offset = new SimpleStyleableDoubleProperty(StyleableProperties.access$000(), (Object)this, "offset", Double.valueOf(10.0));

    public JFXTreeViewPath(TreeView<?> treeView) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setClip((Node)this.clip);
        this.clip.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, new CornerRadii(3.0), Insets.EMPTY)}));
        this.backgroundProperty().addListener(observable -> JFXNodeUtils.updateBackground(this.getBackground(), this.clip));
        this.container.getStyleClass().add((Object)"buttons-container");
        this.container.getChildren().add((Object)new Label("Selection Path..."));
        this.container.setAlignment(Pos.CENTER_LEFT);
        this.container.widthProperty().addListener(observable -> this.setHvalue(this.getHmax()));
        this.setContent((Node)this.container);
        this.setPannable(true);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setFitToHeight(true);
        treeView.getSelectionModel().selectedItemProperty().addListener(observable -> {
            TreeItem treeItem;
            int n2 = treeView.getTreeItemLevel(treeItem) - (treeView.isShowRoot() ? 0 : 1);
            if (treeItem != null) {
                TreeItem treeItem2;
                ArrayList<StackPane> arrayList = new ArrayList<StackPane>();
                for (treeItem = treeItem2 = (TreeItem)treeView.getSelectionModel().getSelectedItem(); treeItem != null; treeItem = treeItem.getParent()) {
                    TreeItem treeItem3;
                    TreeItem treeItem4 = treeItem3 = treeView.isShowRoot() ? treeItem : treeItem.getParent();
                    if (treeItem3 == null) continue;
                    JFXButton jFXButton = null;
                    if (treeItem.isLeaf()) {
                        jFXButton = this.createLastButton(treeItem, treeItem3.getParent());
                        jFXButton.pseudoClassStateChanged(this.lastClass, true);
                    } else if (treeItem3.getParent() == null) {
                        jFXButton = this.createFirstButton(treeItem);
                        jFXButton.pseudoClassStateChanged(this.firstClass, true);
                    } else {
                        jFXButton = this.createNextButton(treeItem);
                        jFXButton.pseudoClassStateChanged(this.nextClass, true);
                    }
                    TreeItem treeItem5 = treeItem;
                    jFXButton.setOnAction(actionEvent -> treeView.scrollTo(treeView.getRow(treeItem5)));
                    StackPane stackPane = new StackPane(new Node[]{jFXButton});
                    stackPane.setPickOnBounds(false);
                    if (treeItem3.getParent() != null) {
                        stackPane.setTranslateX((-this.getOffset() - 1.0) * (double)n2--);
                    }
                    if (treeItem != treeItem2) {
                        SVGGlyph sVGGlyph = new SVGGlyph("M366 698l196-196-196-196 60-60 256 256-256 256z", (Paint)Color.BLACK);
                        sVGGlyph.setSizeForWidth(6.0);
                        sVGGlyph.setMouseTransparent(true);
                        StackPane.setAlignment((Node)sVGGlyph, (Pos)Pos.CENTER_RIGHT);
                        stackPane.getChildren().add((Object)sVGGlyph);
                    }
                    arrayList.add(0, stackPane);
                }
                this.container.getChildren().setAll(arrayList);
            }
        });
        this.container.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.lastX = mouseEvent.getX();
        });
        this.container.addEventFilter(MouseEvent.MOUSE_DRAGGED, mouseEvent -> {
            double d2 = this.lastX - mouseEvent.getX();
            if (Math.abs(d2) > 0.5) {
                double d3 = this.getHvalue() + d2 / this.container.getWidth();
                this.setHvalue(d3);
            }
        });
        JFXScrollPane.smoothHScrolling(this);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.clip.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-tree-view-path.css").toExternalForm();
    }

    protected double computeMinHeight(double d2) {
        return super.computePrefHeight(d2);
    }

    private JFXButton createNextButton(TreeItem treeItem) {
        return new JFXButton(treeItem.getValue().toString()){
            {
                this.setPadding(new Insets(JFXTreeViewPath.this.getOffset(), 1.5 * JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset(), 2.0 * JFXTreeViewPath.this.getOffset()));
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            }

            protected void layoutChildren() {
                super.layoutChildren();
                double d2 = this.getWidth();
                Polygon polygon = new Polygon();
                double d3 = this.getHeight();
                polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, d2 - JFXTreeViewPath.this.getOffset(), 0.0, d2, d3 / 2.0, d2 - JFXTreeViewPath.this.getOffset(), d3, 0.0, d3, JFXTreeViewPath.this.getOffset(), d3 / 2.0});
                this.setClip((Node)polygon);
            }
        };
    }

    public JFXButton createFirstButton(TreeItem treeItem) {
        return new JFXButton(treeItem.getValue().toString()){
            {
                this.setPadding(new Insets(JFXTreeViewPath.this.getOffset(), 1.5 * JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset()));
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            }

            protected void layoutChildren() {
                super.layoutChildren();
                double d2 = this.getWidth();
                Polygon polygon = new Polygon();
                double d3 = this.getHeight();
                polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, d2 - JFXTreeViewPath.this.getOffset(), 0.0, d2, d3 / 2.0, d2 - JFXTreeViewPath.this.getOffset(), d3, 0.0, d3});
                this.setClip((Node)polygon);
            }
        };
    }

    private JFXButton createLastButton(TreeItem treeItem, final TreeItem treeItem2) {
        return new JFXButton(treeItem.getValue().toString()){
            private boolean noParent;
            {
                super(string);
                this.noParent = treeItem2 == null;
                this.setPadding(new Insets(JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset(), (double)(this.noParent ? 1 : 2) * JFXTreeViewPath.this.getOffset()));
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            }

            protected void layoutChildren() {
                super.layoutChildren();
                double d2 = this.getWidth();
                Polygon polygon = new Polygon();
                double d3 = this.getHeight();
                polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, d2, 0.0, d2, d3, 0.0, d3, this.noParent ? 0.0 : JFXTreeViewPath.this.getOffset(), this.noParent ? 0.0 : d3 / 2.0});
                this.setClip((Node)polygon);
            }
        };
    }

    public double getOffset() {
        return this.offset.get();
    }

    public StyleableDoubleProperty offsetProperty() {
        return this.offset;
    }

    public void setOffset(double d2) {
        this.offset.set(d2);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXTreeViewPath.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXTreeViewPath, Number> OFFSET = new CssMetaData<JFXTreeViewPath, Number>("-jfx-offset", SizeConverter.getInstance(), (Number)10.0){

            public boolean isSettable(JFXTreeViewPath jFXTreeViewPath) {
                return jFXTreeViewPath.offset == null || !jFXTreeViewPath.offset.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(JFXTreeViewPath jFXTreeViewPath) {
                return jFXTreeViewPath.offsetProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return OFFSET;
        }

        static {
            ArrayList arrayList = new ArrayList(ScrollPane.getClassCssMetaData());
            Collections.addAll(arrayList, OFFSET);
            CHILD_STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

