/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.skins.JFXTabPaneSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.converter.BooleanConverter;
import javafx.scene.control.Skin;
import javafx.scene.control.TabPane;
import javafx.scene.input.MouseEvent;

public class JFXTabPane
extends TabPane {
    private static final String DEFAULT_STYLE_CLASS = "jfx-tab-pane";
    private static final String USER_AGENT_STYLESHEET = JFoenixResources.load("css/controls/jfx-tab-pane.css").toExternalForm();
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.access$000(), (Object)this, "disableAnimation", false);
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public JFXTabPane() {
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXTabPaneSkin(this);
    }

    private void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    public void propagateMouseEventsToParent() {
        this.addEventHandler(MouseEvent.ANY, mouseEvent -> {
            mouseEvent.consume();
            this.getParent().fireEvent(mouseEvent);
        });
    }

    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    public final void setDisableAnimation(Boolean bl2) {
        this.disableAnimationProperty().set(bl2.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXTabPane.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXTabPane, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXTabPane, Boolean>("-jfx-disable-animation", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXTabPane jFXTabPane) {
                return jFXTabPane.disableAnimation == null || !jFXTabPane.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXTabPane jFXTabPane) {
                return jFXTabPane.disableAnimationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return DISABLE_ANIMATION;
        }

        static {
            ArrayList arrayList = new ArrayList(TabPane.getClassCssMetaData());
            Collections.addAll(arrayList, DISABLE_ANIMATION);
            CHILD_STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

