/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import java.util.function.Function;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.DefaultProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

@DefaultProperty(value="content")
public class JFXScrollPane
extends StackPane {
    private static final String DEFAULT_STYLE_CLASS = "jfx-scroll-pane";
    private final VBox contentContainer = new VBox();
    private final StackPane headerSpace = new StackPane();
    private final StackPane condensedHeaderBackground = new StackPane();
    private final StackPane headerBackground = new StackPane();
    private double initY = -1.0;
    private double maxHeight = -1.0;
    private double minHeight = -1.0;
    private final StackPane bottomBar;
    private final Scale scale = new Scale(1.0, 1.0, 0.0, 0.0);
    private Transform oldSceneTransform = null;
    private final StackPane midBar;
    private final StackPane topBar;

    public JFXScrollPane() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        Rectangle rectangle = new Rectangle();
        this.setClip((Node)rectangle);
        rectangle.widthProperty().bind((ObservableValue)this.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)this.heightProperty());
        this.condensedHeaderBackground.setOpacity(0.0);
        this.condensedHeaderBackground.getStyleClass().add((Object)"condensed-header");
        this.condensedHeaderBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)"#1E88E5"), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.headerBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)"#3949AB"), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.headerBackground.getStyleClass().add((Object)"main-header");
        StackPane stackPane = new StackPane();
        stackPane.getChildren().setAll((Object[])new Node[]{this.condensedHeaderBackground, this.headerBackground});
        stackPane.setMouseTransparent(true);
        this.topBar = new StackPane();
        this.topBar.setPickOnBounds(false);
        this.topBar.setMaxHeight(64.0);
        this.midBar = new StackPane();
        this.midBar.setMaxHeight(64.0);
        this.midBar.setPickOnBounds(false);
        this.bottomBar = new StackPane();
        this.bottomBar.setMaxHeight(64.0);
        this.bottomBar.getTransforms().add((Object)this.scale);
        this.scale.pivotYProperty().bind((ObservableValue)this.bottomBar.heightProperty().divide(2));
        this.bottomBar.setPickOnBounds(false);
        StackPane stackPane2 = new StackPane(new Node[]{this.topBar, this.midBar, this.bottomBar});
        StackPane.setAlignment((Node)this.topBar, (Pos)Pos.TOP_CENTER);
        StackPane.setAlignment((Node)this.bottomBar, (Pos)Pos.BOTTOM_CENTER);
        StackPane stackPane3 = new StackPane();
        stackPane3.setPrefHeight(192.0);
        stackPane3.maxHeightProperty().bind((ObservableValue)stackPane3.prefHeightProperty());
        stackPane3.getChildren().setAll((Object[])new Node[]{stackPane, stackPane2});
        StackPane.setAlignment((Node)stackPane3, (Pos)Pos.TOP_CENTER);
        this.headerSpace.minHeightProperty().bind((ObservableValue)stackPane3.prefHeightProperty());
        this.headerSpace.maxHeightProperty().bind((ObservableValue)stackPane3.prefHeightProperty());
        this.headerSpace.setFocusTraversable(true);
        this.contentContainer.getChildren().setAll((Object[])new Node[]{this.headerSpace});
        this.contentContainer.localToSceneTransformProperty().addListener((observableValue, transform, transform2) -> {
            this.oldSceneTransform = transform;
        });
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.contentContainer);
        scrollPane.setFitToWidth(true);
        scrollPane.vvalueProperty().addListener((observableValue, number, number2) -> {
            double d2;
            double d3;
            if (this.minHeight == -1.0) {
                this.minHeight = this.bottomBar.getBoundsInParent().getMinY();
                this.maxHeight = stackPane3.getHeight();
            }
            if (this.initY == -1.0) {
                this.initY = this.oldSceneTransform.getTy();
            }
            d3 = (d3 = Math.abs((d2 = this.contentContainer.getLocalToSceneTransform().getTy()) - this.initY) / this.minHeight) > 1.0 ? 1.0 : (d3 < 0.0 ? 0.0 : d3);
            this.headerBackground.setOpacity(1.0 - d3);
            this.condensedHeaderBackground.setOpacity(d3);
            if (number2.doubleValue() == 0.0) {
                stackPane3.setTranslateY(0.0);
                this.topBar.setTranslateY(0.0);
            } else {
                double d4 = d2 - this.initY;
                this.topBar.setTranslateY(-d4 <= this.minHeight ? -d4 : this.minHeight);
                double d5 = this.oldSceneTransform.getTy();
                double d6 = d5 - d2;
                if (-d4 > this.minHeight && number2.doubleValue() < number.doubleValue()) {
                    if (-(stackPane3.getTranslateY() - d6) > this.minHeight) {
                        stackPane3.setTranslateY(stackPane3.getTranslateY() - d6);
                    } else {
                        stackPane3.setTranslateY(-this.minHeight);
                    }
                } else if (-d4 > this.maxHeight) {
                    if (-(stackPane3.getTranslateY() - d6) < this.maxHeight) {
                        stackPane3.setTranslateY(stackPane3.getTranslateY() - d6);
                    } else {
                        stackPane3.setTranslateY(-this.maxHeight);
                    }
                } else if (d6 > this.maxHeight) {
                    stackPane3.setTranslateY(-this.maxHeight);
                } else {
                    stackPane3.setTranslateY(d4);
                }
            }
            this.scale.setX(this.map(d3, 0.0, 1.0, 1.0, 0.75));
            this.scale.setY(this.map(d3, 0.0, 1.0, 1.0, 0.75));
        });
        scrollPane.setPannable(true);
        this.getChildren().setAll((Object[])new Node[]{scrollPane, stackPane3});
    }

    private double map(double d2, double d3, double d4, double d5, double d6) {
        return d5 + (d6 - d5) * ((d2 - d3) / (d4 - d3));
    }

    public void setContent(Node node) {
        if (this.contentContainer.getChildren().size() == 2) {
            this.contentContainer.getChildren().set(1, (Object)node);
        } else if (this.contentContainer.getChildren().size() == 1) {
            this.contentContainer.getChildren().add((Object)node);
        } else {
            this.contentContainer.getChildren().setAll((Object[])new Node[]{this.headerSpace, node});
        }
        VBox.setVgrow((Node)node, (Priority)Priority.ALWAYS);
    }

    public Node getContent() {
        return this.contentContainer.getChildren().size() == 2 ? (Node)this.contentContainer.getChildren().get(1) : null;
    }

    public StackPane getTopBar() {
        return this.topBar;
    }

    public StackPane getMidBar() {
        return this.midBar;
    }

    public StackPane getBottomBar() {
        return this.bottomBar;
    }

    public StackPane getMainHeader() {
        return this.headerBackground;
    }

    public StackPane getCondensedHeader() {
        return this.condensedHeaderBackground;
    }

    private static void customScrolling(ScrollPane scrollPane, DoubleProperty doubleProperty, Function<Bounds, Double> function) {
        double[] dArray = new double[]{0.99, 0.1, 0.05, 0.04, 0.03, 0.02, 0.01, 0.04, 0.01, 0.008, 0.008, 0.008, 0.008, 6.0E-4, 5.0E-4, 3.0E-5, 1.0E-5};
        double[] dArray2 = new double[]{1.0};
        double[] dArray3 = new double[dArray.length];
        Timeline timeline = new Timeline();
        EventHandler eventHandler = mouseEvent -> timeline.stop();
        EventHandler eventHandler2 = scrollEvent -> {
            if (scrollEvent.getEventType() == ScrollEvent.SCROLL) {
                int n2 = scrollEvent.getDeltaY() > 0.0 ? -1 : 1;
                for (int i2 = 0; i2 < dArray2.length; ++i2) {
                    int n3 = i2;
                    dArray2[n3] = dArray3[n3] + (double)n2 * dArray2[i2];
                }
                if (timeline.getStatus() == Animation.Status.STOPPED) {
                    timeline.play();
                }
                scrollEvent.consume();
            }
        };
        if (scrollPane.getContent().getParent() != null) {
            scrollPane.getContent().getParent().addEventHandler(MouseEvent.DRAG_DETECTED, eventHandler);
            scrollPane.getContent().getParent().addEventHandler(ScrollEvent.ANY, eventHandler2);
        }
        scrollPane.getContent().parentProperty().addListener((observableValue, parent, parent2) -> {
            if (parent != null) {
                parent.removeEventHandler(MouseEvent.DRAG_DETECTED, eventHandler);
                parent.removeEventHandler(ScrollEvent.ANY, eventHandler2);
            }
            if (parent2 != null) {
                parent2.addEventHandler(MouseEvent.DRAG_DETECTED, eventHandler);
                parent2.addEventHandler(ScrollEvent.ANY, eventHandler2);
            }
        });
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)3.0), actionEvent -> {
            int n2;
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                int n3 = n2;
                dArray[n3] = dArray3[n3] * dArray[n2];
            }
            for (n2 = 1; n2 < dArray3.length; ++n2) {
                int n4 = n2;
                dArray[n4] = dArray3[n4] + dArray3[n2 - 1];
            }
            double d2 = dArray3[dArray3.length - 1];
            double d3 = (Double)function.apply(scrollPane.getContent().getLayoutBounds());
            doubleProperty.set(Math.min(Math.max(doubleProperty.get() + d2 / d3, 0.0), 1.0));
            if (Math.abs(d2) < 0.001) {
                timeline.stop();
            }
        }, new KeyValue[0]));
        timeline.setCycleCount(-1);
    }

    public static void smoothScrolling(ScrollPane scrollPane) {
        JFXScrollPane.customScrolling(scrollPane, scrollPane.vvalueProperty(), bounds -> bounds.getHeight());
    }

    public static void smoothHScrolling(ScrollPane scrollPane) {
        JFXScrollPane.customScrolling(scrollPane, scrollPane.hvalueProperty(), bounds -> bounds.getWidth());
    }
}

