/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.cache.CachePolicy;
import com.jfoenix.controls.events.JFXDrawerEvent;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXDrawerKeyValue;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javafx.util.Duration;

public class JFXDrawer
extends StackPane {
    private List<JFXKeyValue<?>> animatedValues = new ArrayList();
    private HashMap<WritableValue<?>, JFXDrawerKeyValue<?>> initValues = new HashMap();
    private HashMap<WritableValue<?>, Supplier<?>> currentValue = new HashMap();
    private StackPane overlayPane = new StackPane();
    StackPane sidePane = new StackPane();
    private StackPane content = new StackPane();
    private StackPane contentHolder = new StackPane();
    private Region paddingPane = new Region();
    private Duration holdTime = Duration.seconds((double)0.2);
    private PauseTransition holdTimer = new PauseTransition(this.holdTime);
    private double initOffset = 30.0;
    private DoubleProperty initTranslate = new SimpleDoubleProperty();
    private double activeOffset = 20.0;
    private double startMouse = -1.0;
    private double startTranslate = -1.0;
    private double startSize = -1.0;
    private double contentMinSize = -1.0;
    private boolean openCalled = false;
    private boolean closeCalled = true;
    private DoubleProperty translateProperty = this.sidePane.translateXProperty();
    private DoubleProperty defaultSizeProperty = new SimpleDoubleProperty();
    private DoubleProperty maxSizeProperty = this.sidePane.maxWidthProperty();
    private DoubleProperty prefSizeProperty = this.sidePane.prefWidthProperty();
    private ReadOnlyDoubleProperty sizeProperty = this.sidePane.widthProperty();
    private DoubleProperty paddingSizeProperty = this.paddingPane.minWidthProperty();
    private SimpleObjectProperty<DrawerDirection> directionProperty = new SimpleObjectProperty((Object)DrawerDirection.LEFT);
    final ChangeListener<Number> translateChangeListener = (observableValue, number, number2) -> {
        if (!this.openCalled && this.closeCalled && ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * number2.doubleValue() > ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * this.initTranslate.get() / 2.0) {
            this.openCalled = true;
            this.closeCalled = false;
            this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.OPENING));
        } else if (this.openCalled && !this.closeCalled && ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * number2.doubleValue() < ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * this.initTranslate.get() / 2.0) {
            this.closeCalled = true;
            this.openCalled = false;
            this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.CLOSING));
        }
    };
    private double translateTo = 0.0;
    private double resizeTo = 0.0;
    private DoubleBinding initTranslateBinding;
    private double tempDrawerSize = this.getDefaultDrawerSize();
    private Duration duration;
    private JFXAnimationTimer translateTimer;
    private DoubleProperty miniDrawerSize = new SimpleDoubleProperty(-1.0);
    private ArrayList<Callback<Void, Boolean>> callBacks = new ArrayList();
    private SimpleObjectProperty<CachePolicy> cachePolicy = new SimpleObjectProperty(CachePolicy.NONE);
    private BooleanProperty overLayVisible = new SimpleBooleanProperty(true);
    private boolean resizable = false;
    private boolean resizeContent = false;
    private ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosed = new ObjectPropertyBase<EventHandler<JFXDrawerEvent>>(){

        protected void invalidated() {
            JFXDrawer.this.setEventHandler(JFXDrawerEvent.CLOSED, (EventHandler)this.get());
        }

        public Object getBean() {
            return JFXDrawer.this;
        }

        public String getName() {
            return "onClosed";
        }
    };
    private ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosing = new ObjectPropertyBase<EventHandler<JFXDrawerEvent>>(){

        protected void invalidated() {
            JFXDrawer.this.setEventHandler(JFXDrawerEvent.CLOSING, (EventHandler)this.get());
        }

        public Object getBean() {
            return JFXDrawer.this;
        }

        public String getName() {
            return "onClosing";
        }
    };
    private ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpened = new ObjectPropertyBase<EventHandler<JFXDrawerEvent>>(){

        protected void invalidated() {
            JFXDrawer.this.setEventHandler(JFXDrawerEvent.OPENED, (EventHandler)this.get());
        }

        public Object getBean() {
            return JFXDrawer.this;
        }

        public String getName() {
            return "onOpened";
        }
    };
    private ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpening = new ObjectPropertyBase<EventHandler<JFXDrawerEvent>>(){

        protected void invalidated() {
            JFXDrawer.this.setEventHandler(JFXDrawerEvent.OPENING, (EventHandler)this.get());
        }

        public Object getBean() {
            return JFXDrawer.this;
        }

        public String getName() {
            return "onOpening";
        }
    };
    private EventHandler<MouseEvent> mouseDragHandler = mouseEvent -> {
        if (!mouseEvent.isConsumed()) {
            double d2;
            mouseEvent.consume();
            if (this.startSize == -1.0) {
                this.startSize = this.sizeProperty.get();
            }
            double d3 = this.getDirection().doubleValue();
            double d4 = this.getDirection() == DrawerDirection.RIGHT || this.getDirection() == DrawerDirection.LEFT ? mouseEvent.getSceneX() : mouseEvent.getSceneY();
            double d5 = this.startTranslate + d4 - this.startMouse;
            double d6 = d2 = this.getDirection() == DrawerDirection.LEFT || this.getDirection() == DrawerDirection.RIGHT ? this.getWidth() : this.getHeight();
            if (d3 * d5 <= 0.0) {
                if (this.resizable || this.hasMiniSize()) {
                    double d7 = this.startSize + d3 * d5;
                    double d8 = this.hasMiniSize() ? this.getMiniDrawerSize() : this.getDefaultDrawerSize();
                    if (d7 > d8) {
                        this.maxSizeProperty.set(d7);
                        this.prefSizeProperty.set(d7);
                        double d9 = this.hasMiniSize() ? (d7 - this.getMiniDrawerSize()) / (this.getDefaultDrawerSize() - this.getMiniDrawerSize()) : 1.0 - this.translateProperty.get() / this.initTranslate.get();
                        d9 = d9 > 1.0 ? 1.0 : d9;
                        d9 = d9 < 0.0 ? 0.0 : d9;
                        this.overlayPane.setOpacity(d9);
                        for (JFXKeyValue<?> jFXKeyValue : this.animatedValues) {
                            if (!jFXKeyValue.isValid()) continue;
                            WritableValue<?> writableValue = jFXKeyValue.getTarget();
                            JFXDrawerKeyValue<?> jFXDrawerKeyValue = this.initValues.get(writableValue);
                            writableValue.setValue(jFXKeyValue.getInterpolator().interpolate(jFXDrawerKeyValue.getOpenValueSupplier().get(), jFXDrawerKeyValue.getCloseValueSupplier().get(), 1.0 - d9));
                        }
                        if (this.isResizeContent()) {
                            this.paddingSizeProperty.set(Math.min(d7, d2 - this.contentMinSize));
                        }
                    } else {
                        this.maxSizeProperty.set(d8);
                        double d10 = this.hasMiniSize() ? 0.0 : d3 * (this.startSize - this.getDefaultDrawerSize()) + d5;
                        this.translateProperty.set(d10);
                        double d11 = this.hasMiniSize() ? (d7 - this.getMiniDrawerSize()) / (this.getDefaultDrawerSize() - this.getMiniDrawerSize()) : 1.0 - this.translateProperty.get() / this.initTranslate.get();
                        d11 = d11 > 1.0 ? 1.0 : d11;
                        d11 = d11 < 0.0 ? 0.0 : d11;
                        this.overlayPane.setOpacity(d11);
                        if (this.isResizeContent()) {
                            this.paddingSizeProperty.set(d8 + d3 * d10);
                        }
                    }
                } else {
                    this.translateProperty.set(d5);
                    this.overlayPane.setOpacity(1.0 - this.translateProperty.get() / this.initTranslate.get());
                    if (this.isResizeContent()) {
                        this.paddingSizeProperty.set(this.getDefaultDrawerSize() + d3 * d5);
                    }
                }
            } else {
                if (this.resizable || this.hasMiniSize()) {
                    double d12 = this.startSize + d3 * d5;
                    if (d12 <= d2) {
                        d12 = this.resizable ? d12 : (d12 < this.getDefaultDrawerSize() ? d12 : this.getDefaultDrawerSize());
                        this.maxSizeProperty.set(d12);
                        this.prefSizeProperty.set(d12);
                        double d13 = this.hasMiniSize() ? (d12 - this.getMiniDrawerSize()) / (this.getDefaultDrawerSize() - this.getMiniDrawerSize()) : 1.0 - this.translateProperty.get() / this.initTranslate.get();
                        d13 = d13 > 1.0 ? 1.0 : d13;
                        d13 = d13 < 0.0 ? 0.0 : d13;
                        this.overlayPane.setOpacity(d13);
                        for (JFXKeyValue<?> jFXKeyValue : this.animatedValues) {
                            if (!jFXKeyValue.isValid()) continue;
                            WritableValue<?> writableValue = jFXKeyValue.getTarget();
                            JFXDrawerKeyValue<?> jFXDrawerKeyValue = this.initValues.get(writableValue);
                            writableValue.setValue(jFXKeyValue.getInterpolator().interpolate(jFXDrawerKeyValue.getCloseValueSupplier().get(), jFXDrawerKeyValue.getOpenValueSupplier().get(), d13));
                        }
                        if (this.isResizeContent()) {
                            this.paddingSizeProperty.set(Math.min(d12, d2 - this.contentMinSize));
                        }
                    } else if (this.resizable) {
                        this.maxSizeProperty.set(-1.0);
                        this.prefSizeProperty.set(-1.0);
                    }
                }
                this.translateProperty.set(0.0);
                if (!this.hasMiniSize()) {
                    this.overlayPane.setOpacity(1.0 - this.translateProperty.get() / this.initTranslate.get());
                }
            }
        }
    };
    private EventHandler<MouseEvent> mousePressedHandler = mouseEvent -> {
        this.translateTimer.setOnFinished(null);
        this.translateTimer.stop();
        this.startMouse = this.directionProperty.get() == DrawerDirection.RIGHT || this.directionProperty.get() == DrawerDirection.LEFT ? mouseEvent.getSceneX() : mouseEvent.getSceneY();
        this.startTranslate = this.translateProperty.get();
        this.startSize = this.sizeProperty.get();
        this.contentMinSize = -1.0;
        if (this.isResizeContent()) {
            this.contentMinSize = this.getDirection() == DrawerDirection.LEFT || this.getDirection() == DrawerDirection.RIGHT ? this.content.minWidth(-1.0) : this.content.minHeight(-1.0);
        }
    };
    private EventHandler<MouseEvent> mouseReleasedHandler = mouseEvent -> {
        double d2 = ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue();
        if (this.prefSizeProperty.get() != -1.0) {
            this.tryPartialAnimation(d2);
            this.updateTempDrawerSize();
        }
        this.startMouse = -1.0;
        this.startTranslate = -1.0;
        this.startSize = this.sizeProperty.get();
    };
    private static final String DEFAULT_STYLE_CLASS = "jfx-drawer";
    private static final String USER_AGENT_STYLESHEET = JFoenixResources.load("css/controls/jfx-drawer.css").toExternalForm();

    public JFXDrawer() {
        this(Duration.millis((double)420.0));
    }

    public JFXDrawer(Duration duration) {
        this.initialize();
        this.duration = duration;
        this.translateTimer = this.createDrawerAnimation(duration);
        this.contentHolder.setPickOnBounds(false);
        this.addEventHandler(JFXDrawerEvent.CLOSED, jFXDrawerEvent -> Platform.runLater(() -> this.getCachePolicy().restore(this.contentHolder)));
        this.overlayPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.1), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.overlayPane.getStyleClass().add((Object)"jfx-drawer-overlay-pane");
        this.overlayPane.setOpacity(0.0);
        this.overlayPane.setMouseTransparent(true);
        this.sidePane.getStyleClass().add((Object)"jfx-drawer-side-pane");
        this.sidePane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)1.0), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.sidePane.setPickOnBounds(false);
        this.translateTimer.setCacheNodes(new Node[]{this.sidePane});
        this.initListeners();
        this.setDefaultDrawerSize(100.0);
        this.getChildren().setAll((Object[])new Node[]{this.contentHolder, this.overlayPane, this.sidePane});
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    private void initListeners() {
        this.initTranslateBinding = Bindings.createDoubleBinding(() -> -1.0 * ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * this.defaultSizeProperty.getValue() - this.initOffset * ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue(), (Observable[])new Observable[]{this.defaultSizeProperty, this.directionProperty});
        this.updateDirection(this.getDirection());
        this.initTranslate.bind((ObservableValue)this.initTranslateBinding);
        this.overLayVisibleProperty().addListener(observable -> {
            boolean bl2 = this.isOverLayVisible();
            this.overlayPane.setStyle(!bl2 ? "-fx-background-color : transparent;" : "");
            this.overlayPane.setPickOnBounds(bl2);
        });
        this.directionProperty.addListener(observable -> this.updateDirection((DrawerDirection)((Object)((Object)this.directionProperty.get()))));
        this.initTranslate.addListener(observable -> this.updateDrawerAnimation(this.initTranslate.get()));
        this.translateProperty.addListener(this.translateChangeListener);
        this.overlayPane.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> this.close());
        this.sidePane.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseDragHandler);
        this.sidePane.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
        this.sidePane.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedHandler);
        this.content.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            if (!mouseEvent.isConsumed()) {
                double d2 = 0.0;
                long l2 = 0L;
                for (int i2 = 0; i2 < this.callBacks.size(); ++i2) {
                    if (((Boolean)this.callBacks.get(i2).call(null)).booleanValue()) continue;
                    ++l2;
                }
                DrawerDirection drawerDirection = this.getDirection();
                if (drawerDirection == DrawerDirection.RIGHT) {
                    d2 = this.content.getWidth();
                } else if (drawerDirection == DrawerDirection.BOTTOM) {
                    d2 = this.content.getHeight();
                }
                double d3 = 0.0;
                d3 = drawerDirection == DrawerDirection.RIGHT || drawerDirection == DrawerDirection.LEFT ? mouseEvent.getX() : mouseEvent.getY();
                if (d2 + drawerDirection.doubleValue() * d3 < this.activeOffset && (this.content.getCursor() == null || this.content.getCursor() == Cursor.DEFAULT) && l2 == 0L && !this.isOpened()) {
                    this.holdTimer.play();
                    mouseEvent.consume();
                }
            }
        });
        this.content.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            this.holdTimer.stop();
            this.content.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDragHandler);
        });
        this.holdTimer.setOnFinished(actionEvent -> {
            this.translateTo = this.initTranslate.get() + this.initOffset * ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() + this.activeOffset * ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue();
            this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
            this.translateTimer.setOnFinished(null);
            this.getCachePolicy().cache(this.contentHolder);
            this.translateTimer.start();
        });
    }

    private JFXAnimationTimer createDrawerAnimation(Duration duration) {
        return new JFXAnimationTimer(new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.overlayPane.opacityProperty()).setEndValueSupplier(() -> !this.hasMiniSize() ? 1.0 - this.translateTo / this.initTranslate.get() : (double)(this.resizeTo != this.getMiniDrawerSize() ? 1 : 0)).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.translateProperty).setEndValueSupplier(() -> !this.hasMiniSize() ? this.translateTo : 0.0).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> !this.hasMiniSize() && this.translateTo == this.initTranslate.get()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> !this.hasMiniSize() && this.translateTo == this.initTranslate.get()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.tempDrawerSize).setAnimateCondition(() -> this.translateTo == 0.0 && this.tempDrawerSize > this.getDefaultDrawerSize() && !this.hasMiniSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.tempDrawerSize).setAnimateCondition(() -> this.translateTo == 0.0 && this.tempDrawerSize > this.getDefaultDrawerSize() && !this.hasMiniSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.getMiniDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo <= this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.getMiniDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo <= this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo > this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo > this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.paddingSizeProperty).setEndValueSupplier(this::computePaddingSize).setAnimateCondition(() -> this.isResizeContent()).setInterpolator(Interpolator.EASE_BOTH).build()));
    }

    private void updateDirection(DrawerDirection drawerDirection) {
        this.maxSizeProperty.set(-1.0);
        this.prefSizeProperty.set(-1.0);
        this.translateProperty.set(0.0);
        if (drawerDirection == DrawerDirection.LEFT || drawerDirection == DrawerDirection.RIGHT) {
            this.translateProperty.removeListener(this.translateChangeListener);
            this.translateProperty = this.sidePane.translateXProperty();
            this.translateProperty.addListener(this.translateChangeListener);
            this.maxSizeProperty = this.sidePane.maxWidthProperty();
            this.prefSizeProperty = this.sidePane.prefWidthProperty();
            this.sizeProperty = this.sidePane.widthProperty();
            this.paddingSizeProperty = this.paddingPane.minWidthProperty();
        } else if (drawerDirection == DrawerDirection.TOP || drawerDirection == DrawerDirection.BOTTOM) {
            this.translateProperty.removeListener(this.translateChangeListener);
            this.translateProperty = this.sidePane.translateYProperty();
            this.translateProperty.addListener(this.translateChangeListener);
            this.maxSizeProperty = this.sidePane.maxHeightProperty();
            this.prefSizeProperty = this.sidePane.prefHeightProperty();
            this.sizeProperty = this.sidePane.heightProperty();
            this.paddingSizeProperty = this.paddingPane.minHeightProperty();
        }
        if (drawerDirection == DrawerDirection.LEFT) {
            StackPane.setAlignment((Node)this.sidePane, (Pos)Pos.CENTER_LEFT);
        } else if (drawerDirection == DrawerDirection.RIGHT) {
            StackPane.setAlignment((Node)this.sidePane, (Pos)Pos.CENTER_RIGHT);
        } else if (drawerDirection == DrawerDirection.TOP) {
            StackPane.setAlignment((Node)this.sidePane, (Pos)Pos.TOP_CENTER);
        } else if (drawerDirection == DrawerDirection.BOTTOM) {
            StackPane.setAlignment((Node)this.sidePane, (Pos)Pos.BOTTOM_CENTER);
        }
        this.setDefaultDrawerSize(this.getDefaultDrawerSize());
        this.updateDrawerAnimation(this.initTranslate.get());
        this.updateContent();
        this.setMiniDrawerSize(this.getMiniDrawerSize());
    }

    private void updateDrawerAnimation(double d2) {
        this.translateProperty.set(d2);
        this.translateTo = d2;
    }

    private double computePaddingSize() {
        if (!this.isResizeContent()) {
            return 0.0;
        }
        if (this.hasMiniSize()) {
            return this.resizeTo;
        }
        if (this.translateTo == 0.0 && this.tempDrawerSize > this.getDefaultDrawerSize()) {
            return this.tempDrawerSize;
        }
        if (this.translateTo == 0.0) {
            return this.getDefaultDrawerSize();
        }
        if (this.translateTo == this.initTranslate.get()) {
            return 0.0;
        }
        return this.getDefaultDrawerSize() + this.getDirection().doubleValue() * this.translateTo;
    }

    public double getMiniDrawerSize() {
        return this.miniDrawerSize.get();
    }

    public void setMiniDrawerSize(double d2) {
        this.miniDrawerSize.set(d2);
        if (d2 > 0.0) {
            this.updateSize(d2);
            this.initTranslate.unbind();
            this.initTranslate.set(0.0);
            this.paddingSizeProperty.set(d2);
        } else {
            this.updateSize(this.getDefaultDrawerSize());
            this.initTranslate.bind((ObservableValue)this.initTranslateBinding);
            this.paddingSizeProperty.set(0.0);
        }
        this.resizeTo = d2;
    }

    private boolean hasMiniSize() {
        return this.getMiniDrawerSize() > 0.0;
    }

    public void addInitDrawerCallback(Callback<Void, Boolean> callback) {
        this.callBacks.add(callback);
    }

    void bringToFront(Callback<Void, Void> callback) {
        EventHandler eventHandler = Event::consume;
        boolean bl2 = this.prefSizeProperty.get() == -1.0;
        this.addEventFilter(MouseEvent.ANY, eventHandler);
        Runnable runnable = () -> {
            callback.call(null);
            this.translateTo = 0.0;
            this.translateTimer.setOnFinished(() -> {
                if (bl2) {
                    this.prefSizeProperty.set(-1.0);
                    this.maxSizeProperty.set(-1.0);
                }
                this.removeEventFilter(MouseEvent.ANY, eventHandler);
            });
            this.getCachePolicy().cache(this.contentHolder);
            this.translateTimer.start();
        };
        this.tempDrawerSize = this.sizeProperty.get() > this.getDefaultDrawerSize() ? this.sizeProperty.get() : this.getDefaultDrawerSize();
        this.translateTo = this.initTranslate.get();
        this.translateTimer.setOnFinished(runnable);
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.start();
    }

    public boolean isOpened() {
        if (this.hasMiniSize()) {
            return this.resizeTo == this.getDefaultDrawerSize() || this.prefSizeProperty.get() >= this.getDefaultDrawerSize();
        }
        return (this.translateTo == 0.0 || this.translateProperty.get() == 0.0) && !this.translateTimer.isRunning();
    }

    public boolean isOpening() {
        boolean bl2 = this.hasMiniSize() ? this.resizeTo == this.getDefaultDrawerSize() : this.translateTo == 0.0;
        return bl2 && this.translateTimer.isRunning();
    }

    public boolean isClosing() {
        boolean bl2 = this.hasMiniSize() ? this.resizeTo == this.getMiniDrawerSize() : this.translateTo == this.initTranslate.get();
        return bl2 && this.translateTimer.isRunning();
    }

    public boolean isClosed() {
        if (this.hasMiniSize()) {
            return this.resizeTo == this.getMiniDrawerSize();
        }
        return this.translateTo == this.initTranslate.get() && !this.translateTimer.isRunning();
    }

    public void toggle() {
        if (this.isOpened() || this.isOpening()) {
            this.close();
        } else {
            this.open();
        }
    }

    public void open() {
        for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
            this.currentValue.put(entry.getKey(), entry.getValue().getOpenValueSupplier());
        }
        this.translateTo = 0.0;
        this.resizeTo = this.getDefaultDrawerSize();
        this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
        this.translateTimer.setOnFinished(() -> this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.OPENED)));
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.reverseAndContinue();
    }

    public void close() {
        this.translateTimer.setOnFinished(() -> {
            this.overlayPane.setMouseTransparent(true);
            this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.CLOSED));
        });
        if (this.hasMiniSize()) {
            if (this.resizeTo != this.getMiniDrawerSize()) {
                this.resizeTo = this.getMiniDrawerSize();
                for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
                    this.currentValue.put(entry.getKey(), entry.getValue().getCloseValueSupplier());
                }
            }
        } else {
            this.updateTempDrawerSize();
            if (this.translateTo != this.initTranslate.get()) {
                this.translateTo = this.initTranslate.get();
                for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
                    this.currentValue.put(entry.getKey(), entry.getValue().getCloseValueSupplier());
                }
            }
        }
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.reverseAndContinue();
    }

    public ObservableList<Node> getSidePane() {
        return this.sidePane.getChildren();
    }

    public void setSidePane(Node ... nodeArray) {
        this.sidePane.getChildren().setAll((Object[])nodeArray);
    }

    public ObservableList<Node> getContent() {
        if (this.contentHolder.getChildren().isEmpty()) {
            this.updateContent();
        }
        return this.content.getChildren();
    }

    public void setContent(Node ... nodeArray) {
        this.content.getChildren().setAll((Object[])nodeArray);
        if (this.contentHolder.getChildren().isEmpty()) {
            this.updateContent();
        }
    }

    private void updateContent() {
        this.paddingPane.setPrefSize(0.0, 0.0);
        this.paddingPane.setMinSize(0.0, 0.0);
        StackPane stackPane = this.content;
        switch (this.getDirection()) {
            case TOP: {
                stackPane = new VBox(new Node[]{this.paddingPane, this.content});
                VBox.setVgrow((Node)this.content, (Priority)Priority.ALWAYS);
                break;
            }
            case BOTTOM: {
                stackPane = new VBox(new Node[]{this.content, this.paddingPane});
                VBox.setVgrow((Node)this.content, (Priority)Priority.ALWAYS);
                break;
            }
            case LEFT: {
                stackPane = new HBox(new Node[]{this.paddingPane, this.content});
                HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
                break;
            }
            case RIGHT: {
                stackPane = new HBox(new Node[]{this.content, this.paddingPane});
                HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            }
        }
        stackPane.setPickOnBounds(false);
        if (this.isOpened()) {
            this.paddingSizeProperty.set(this.computePaddingSize());
        }
        this.contentHolder.getChildren().setAll((Object[])new Node[]{stackPane});
    }

    public double getDefaultDrawerSize() {
        return this.defaultSizeProperty.get();
    }

    public void setDefaultDrawerSize(double d2) {
        this.defaultSizeProperty.set(d2);
        if (this.getMiniDrawerSize() < 0.0) {
            this.updateSize(d2);
        }
    }

    private void updateSize(double d2) {
        this.maxSizeProperty.set(d2);
        this.prefSizeProperty.set(d2);
    }

    public DrawerDirection getDirection() {
        return (DrawerDirection)((Object)this.directionProperty.get());
    }

    public SimpleObjectProperty<DrawerDirection> directionProperty() {
        return this.directionProperty;
    }

    public void setDirection(DrawerDirection drawerDirection) {
        this.directionProperty.set((Object)drawerDirection);
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy.get() == null ? CachePolicy.NONE : (CachePolicy)this.cachePolicy.get();
    }

    public SimpleObjectProperty<CachePolicy> cachePolicyProperty() {
        return this.cachePolicy;
    }

    public void setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy.set((Object)cachePolicy);
    }

    public final BooleanProperty overLayVisibleProperty() {
        return this.overLayVisible;
    }

    public final boolean isOverLayVisible() {
        return this.overLayVisibleProperty().get();
    }

    public final void setOverLayVisible(boolean bl2) {
        this.overLayVisibleProperty().set(bl2);
    }

    public boolean isResizableOnDrag() {
        return this.resizable;
    }

    public void setResizableOnDrag(boolean bl2) {
        this.resizable = bl2;
    }

    public boolean isResizeContent() {
        return this.resizeContent;
    }

    public void setResizeContent(boolean bl2) {
        this.resizeContent = bl2;
        this.translateTimer.reverseAndContinue();
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerClosed() {
        return (EventHandler)this.onDrawerClosedProperty().get();
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosedProperty() {
        return this.onDrawerClosed;
    }

    public void setOnDrawerClosed(EventHandler<JFXDrawerEvent> eventHandler) {
        this.onDrawerClosedProperty().set(eventHandler);
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerClosing() {
        return (EventHandler)this.onDrawerClosing.get();
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosingProperty() {
        return this.onDrawerClosing;
    }

    public void setOnDrawerClosing(EventHandler<JFXDrawerEvent> eventHandler) {
        this.onDrawerClosing.set(eventHandler);
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerOpened() {
        return (EventHandler)this.onDrawerOpened.get();
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpenedProperty() {
        return this.onDrawerOpened;
    }

    public void setOnDrawerOpened(EventHandler<JFXDrawerEvent> eventHandler) {
        this.onDrawerOpened.set(eventHandler);
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerOpening() {
        return (EventHandler)this.onDrawerOpening.get();
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpeningProperty() {
        return this.onDrawerOpening;
    }

    public void setOnDrawerOpening(EventHandler<JFXDrawerEvent> eventHandler) {
        this.onDrawerOpening.set(eventHandler);
    }

    private void updateTempDrawerSize() {
        this.tempDrawerSize = this.sizeProperty.get() > this.getDefaultDrawerSize() ? this.prefSizeProperty.get() : this.getDefaultDrawerSize();
    }

    private void tryPartialAnimation(double d2) {
        if (this.hasMiniSize()) {
            if (this.prefSizeProperty.get() > (this.getMiniDrawerSize() + this.getDefaultDrawerSize()) / 2.0 && this.prefSizeProperty.get() < this.getDefaultDrawerSize()) {
                this.partialOpen();
            } else if (this.prefSizeProperty.get() <= (this.getMiniDrawerSize() + this.getDefaultDrawerSize()) / 2.0) {
                this.partialClose();
            } else if (this.prefSizeProperty.get() >= this.getDefaultDrawerSize()) {
                this.resizeTo = this.getDefaultDrawerSize();
                this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
            }
        } else if (d2 * this.translateProperty.get() > d2 * this.initTranslate.get() / 2.0) {
            if (this.translateProperty.get() != 0.0) {
                this.partialOpen();
            }
        } else if (this.translateProperty.get() != this.initTranslate.get()) {
            this.partialClose();
        }
    }

    private void partialClose() {
        for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
            this.currentValue.put(entry.getKey(), entry.getValue().getCloseValueSupplier());
        }
        this.translateTo = this.initTranslate.get();
        this.resizeTo = this.getMiniDrawerSize();
        this.translateTimer.setOnFinished(() -> {
            this.overlayPane.setMouseTransparent(true);
            this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.CLOSED));
        });
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.start();
    }

    private void partialOpen() {
        for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
            this.currentValue.put(entry.getKey(), entry.getValue().getOpenValueSupplier());
        }
        this.translateTo = 0.0;
        this.resizeTo = this.tempDrawerSize = this.getDefaultDrawerSize();
        this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
        this.translateTimer.setOnFinished(() -> this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.OPENED)));
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.start();
    }

    public <T> void addAnimatedKeyValue(Node node, JFXDrawerKeyValue ... jFXDrawerKeyValueArray) {
        this.addAnimatedKeyValue(node, Arrays.asList(jFXDrawerKeyValueArray));
    }

    public void addAnimatedKeyValue(Node node, List<JFXDrawerKeyValue<?>> list) {
        ArrayList<JFXKeyValue<Object>> arrayList = new ArrayList<JFXKeyValue<Object>>();
        for (JFXDrawerKeyValue<?> jFXDrawerKeyValue : list) {
            JFXKeyValue<Object> jFXKeyValue = JFXKeyValue.builder().setEndValueSupplier(() -> this.currentValue.get(jFXDrawerKeyValue.getTarget()).get()).setAnimateCondition(() -> node.getScene() != null && jFXDrawerKeyValue.isValid()).setTargetSupplier(() -> jFXDrawerKeyValue.getTarget()).setInterpolator(jFXDrawerKeyValue.getInterpolator()).build();
            arrayList.add(jFXKeyValue);
            this.currentValue.put(jFXDrawerKeyValue.getTarget(), this.isClosed() ? jFXDrawerKeyValue.getCloseValueSupplier() : jFXDrawerKeyValue.getOpenValueSupplier());
            this.initValues.put(jFXDrawerKeyValue.getTarget(), jFXDrawerKeyValue);
        }
        this.animatedValues.addAll(arrayList);
        JFXKeyFrame jFXKeyFrame = new JFXKeyFrame(this.duration, arrayList.toArray(new JFXKeyValue[0]));
        try {
            this.translateTimer.addKeyFrame(jFXKeyFrame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    public static enum DrawerDirection {
        LEFT(1.0),
        RIGHT(-1.0),
        TOP(1.0),
        BOTTOM(-1.0);

        private double numVal;

        private DrawerDirection(double d2) {
            this.numVal = d2;
        }

        public double doubleValue() {
            return this.numVal;
        }
    }
}

