/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXListCell;
import com.jfoenix.controls.ValidationControl;
import com.jfoenix.controls.base.IFXLabelFloatControl;
import com.jfoenix.converters.base.NodeConverter;
import com.jfoenix.skins.JFXComboBoxListViewSkin;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;

public class JFXComboBox<T>
extends ComboBox<T>
implements IFXLabelFloatControl {
    private static final String DEFAULT_STYLE_CLASS = "jfx-combo-box";
    private ObjectProperty<NodeConverter<T>> nodeConverter = new SimpleObjectProperty((Object)this, "nodeConverter", JFXComboBox.defaultNodeConverter());
    private ValidationControl validationControl = new ValidationControl((Control)this);
    private StyleableBooleanProperty labelFloat = new SimpleStyleableBooleanProperty(StyleableProperties.access$100(), (Object)this, "lableFloat", false);
    private StyleableObjectProperty<Paint> unFocusColor = new SimpleStyleableObjectProperty(StyleableProperties.access$200(), (Object)this, "unFocusColor", (Object)Color.rgb((int)77, (int)77, (int)77));
    private StyleableObjectProperty<Paint> focusColor = new SimpleStyleableObjectProperty(StyleableProperties.access$300(), (Object)this, "focusColor", (Object)Color.valueOf((String)"#4059A9"));
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.access$400(), (Object)this, "disableAnimation", false);

    public JFXComboBox() {
        this.initialize();
    }

    public JFXComboBox(ObservableList<T> observableList) {
        super(observableList);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setCellFactory(listView -> new JFXListCell<T>(){

            @Override
            public void updateItem(T t2, boolean bl2) {
                super.updateItem(t2, bl2);
                JFXComboBox.this.updateDisplayText(this, t2, bl2);
            }
        });
        this.setButtonCell(new ListCell<T>(){
            {
                JFXComboBox.this.valueProperty().addListener(observable -> {
                    if (JFXComboBox.this.getValue() == null) {
                        this.updateItem(null, true);
                    }
                });
            }

            protected void updateItem(T t2, boolean bl2) {
                JFXComboBox.this.updateDisplayText(this, t2, bl2);
                this.setVisible(t2 != null || !bl2);
            }
        });
    }

    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-combo-box.css").toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXComboBoxListViewSkin(this);
    }

    public ObjectProperty<NodeConverter<T>> nodeConverterProperty() {
        return this.nodeConverter;
    }

    public final void setNodeConverter(NodeConverter<T> nodeConverter) {
        this.nodeConverterProperty().set(nodeConverter);
    }

    public final NodeConverter<T> getNodeConverter() {
        return (NodeConverter)this.nodeConverterProperty().get();
    }

    private static <T> NodeConverter<T> defaultNodeConverter() {
        return new NodeConverter<T>(){

            @Override
            public Node toNode(T t2) {
                if (t2 == null) {
                    return null;
                }
                StackPane stackPane = new StackPane();
                stackPane.getStyleClass().add((Object)"combo-box-selected-value-container");
                stackPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
                Label label = t2 instanceof Label ? new Label(((Label)t2).getText()) : new Label(t2.toString());
                label.setTextFill((Paint)Color.BLACK);
                stackPane.getChildren().add((Object)label);
                StackPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
                StackPane.setMargin((Node)label, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
                return stackPane;
            }

            @Override
            public T fromNode(Node node) {
                return node;
            }

            @Override
            public String toString(T t2) {
                if (t2 == null) {
                    return null;
                }
                if (t2 instanceof Label) {
                    return ((Label)t2).getText();
                }
                return t2.toString();
            }
        };
    }

    private boolean updateDisplayText(ListCell<T> listCell, T t2, boolean bl2) {
        if (bl2) {
            if (listCell == null) {
                return true;
            }
            listCell.setGraphic(null);
            listCell.setText(null);
            return true;
        }
        if (t2 instanceof Node) {
            Node node;
            Node node2 = listCell.getGraphic();
            Node node3 = (Node)t2;
            NodeConverter<T> nodeConverter = this.getNodeConverter();
            Node node4 = node = nodeConverter == null ? null : nodeConverter.toNode(t2);
            if (node2 == null || !node2.equals(node3)) {
                listCell.setText(null);
                listCell.setGraphic(node == null ? node3 : node);
            }
            return node == null;
        }
        StringConverter stringConverter = this.getConverter();
        String string = t2 == null ? this.getPromptText() : (stringConverter == null ? t2.toString() : stringConverter.toString(t2));
        listCell.setText(string);
        listCell.setGraphic(null);
        return string == null || string.isEmpty();
    }

    @Override
    public ValidatorBase getActiveValidator() {
        return this.validationControl.getActiveValidator();
    }

    @Override
    public ReadOnlyObjectProperty<ValidatorBase> activeValidatorProperty() {
        return this.validationControl.activeValidatorProperty();
    }

    @Override
    public ObservableList<ValidatorBase> getValidators() {
        return this.validationControl.getValidators();
    }

    @Override
    public void setValidators(ValidatorBase ... validatorBaseArray) {
        this.validationControl.setValidators(validatorBaseArray);
    }

    @Override
    public boolean validate() {
        return this.validationControl.validate();
    }

    @Override
    public void resetValidation() {
        this.validationControl.resetValidation();
    }

    @Override
    public final StyleableBooleanProperty labelFloatProperty() {
        return this.labelFloat;
    }

    @Override
    public final boolean isLabelFloat() {
        return this.labelFloatProperty().get();
    }

    @Override
    public final void setLabelFloat(boolean bl2) {
        this.labelFloatProperty().set(bl2);
    }

    @Override
    public Paint getUnFocusColor() {
        return this.unFocusColor == null ? Color.rgb((int)77, (int)77, (int)77) : (Paint)this.unFocusColor.get();
    }

    @Override
    public StyleableObjectProperty<Paint> unFocusColorProperty() {
        return this.unFocusColor;
    }

    @Override
    public void setUnFocusColor(Paint paint) {
        this.unFocusColor.set((Object)paint);
    }

    @Override
    public Paint getFocusColor() {
        return this.focusColor == null ? Color.valueOf((String)"#4059A9") : (Paint)this.focusColor.get();
    }

    @Override
    public StyleableObjectProperty<Paint> focusColorProperty() {
        return this.focusColor;
    }

    @Override
    public void setFocusColor(Paint paint) {
        this.focusColor.set((Object)paint);
    }

    @Override
    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    @Override
    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    @Override
    public final void setDisableAnimation(Boolean bl2) {
        this.disableAnimationProperty().set(bl2.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXComboBox.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXComboBox<?>, Paint> UNFOCUS_COLOR = new CssMetaData<JFXComboBox<?>, Paint>("-jfx-unfocus-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#A6A6A6")){

            public boolean isSettable(JFXComboBox<?> jFXComboBox) {
                return ((JFXComboBox)jFXComboBox).unFocusColor == null || !((JFXComboBox)jFXComboBox).unFocusColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXComboBox<?> jFXComboBox) {
                return jFXComboBox.unFocusColorProperty();
            }
        };
        private static final CssMetaData<JFXComboBox<?>, Paint> FOCUS_COLOR = new CssMetaData<JFXComboBox<?>, Paint>("-jfx-focus-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#3f51b5")){

            public boolean isSettable(JFXComboBox<?> jFXComboBox) {
                return ((JFXComboBox)jFXComboBox).focusColor == null || !((JFXComboBox)jFXComboBox).focusColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXComboBox<?> jFXComboBox) {
                return jFXComboBox.focusColorProperty();
            }
        };
        private static final CssMetaData<JFXComboBox<?>, Boolean> LABEL_FLOAT = new CssMetaData<JFXComboBox<?>, Boolean>("-jfx-label-float", BooleanConverter.getInstance(), false){

            public boolean isSettable(JFXComboBox<?> jFXComboBox) {
                return ((JFXComboBox)jFXComboBox).labelFloat == null || !((JFXComboBox)jFXComboBox).labelFloat.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXComboBox<?> jFXComboBox) {
                return jFXComboBox.labelFloatProperty();
            }
        };
        private static final CssMetaData<JFXComboBox, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXComboBox, Boolean>("-jfx-disable-animation", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXComboBox jFXComboBox) {
                return jFXComboBox.disableAnimation == null || !jFXComboBox.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXComboBox jFXComboBox) {
                return jFXComboBox.disableAnimationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$100() {
            return LABEL_FLOAT;
        }

        static /* synthetic */ CssMetaData access$200() {
            return UNFOCUS_COLOR;
        }

        static /* synthetic */ CssMetaData access$300() {
            return FOCUS_COLOR;
        }

        static /* synthetic */ CssMetaData access$400() {
            return DISABLE_ANIMATION;
        }

        static {
            ArrayList arrayList = new ArrayList(ComboBox.getClassCssMetaData());
            Collections.addAll(arrayList, UNFOCUS_COLOR, FOCUS_COLOR, LABEL_FLOAT, DISABLE_ANIMATION);
            CHILD_STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

