/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.animation.alert.JFXAlertAnimation;
import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.effects.JFXDepthManager;
import com.sun.javafx.event.EventHandlerManager;
import java.util.List;
import javafx.animation.Animation;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.DialogPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class JFXAlert<R>
extends Dialog<R> {
    private final StackPane contentContainer;
    private InvalidationListener widthListener;
    private InvalidationListener heightListener;
    private InvalidationListener xListener;
    private InvalidationListener yListener;
    private boolean animateClosing = true;
    private Animation transition = null;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private BooleanProperty overlayClose = new SimpleBooleanProperty(true);
    private ObjectProperty<JFXAlertAnimation> animation = new SimpleObjectProperty((Object)JFXAlertAnimation.CENTER_ANIMATION);
    private BooleanProperty hideOnEscape = new SimpleBooleanProperty((Object)this, "hideOnEscape", true);

    public JFXAlert() {
        this(null);
    }

    public JFXAlert(Window window) {
        this.contentContainer = new StackPane();
        this.contentContainer.getStyleClass().add((Object)"jfx-alert-content-container");
        Node node = JFXDepthManager.createMaterialNode((Node)this.contentContainer, 2);
        node.setPickOnBounds(false);
        node.addEventHandler(MouseEvent.MOUSE_CLICKED, Event::consume);
        DialogPane dialogPane = new DialogPane(){
            private boolean performingLayout = false;
            {
                this.getButtonTypes().add((Object)ButtonType.CLOSE);
                Node node = this.lookupButton(ButtonType.CLOSE);
                node.managedProperty().bind((ObservableValue)node.visibleProperty());
                node.setVisible(false);
            }

            protected double computePrefHeight(double d2) {
                Window window = JFXAlert.this.getOwner();
                if (window != null) {
                    return window.getHeight();
                }
                return super.computePrefHeight(d2);
            }

            protected double computePrefWidth(double d2) {
                Window window = JFXAlert.this.getOwner();
                if (window != null) {
                    return window.getWidth();
                }
                return super.computePrefWidth(d2);
            }

            public void requestLayout() {
                if (this.performingLayout) {
                    return;
                }
                super.requestLayout();
            }

            protected void layoutChildren() {
                this.performingLayout = true;
                List list = this.getManagedChildren();
                double d2 = this.getWidth();
                double d3 = this.getHeight();
                double d4 = this.getInsets().getTop();
                double d5 = this.getInsets().getRight();
                double d6 = this.getInsets().getLeft();
                double d7 = this.getInsets().getBottom();
                double d8 = d2 - d6 - d5;
                double d9 = d3 - d4 - d7;
                for (Node node : list) {
                    this.layoutInArea(node, d6, d4, d8, d9, 0.0, Insets.EMPTY, HPos.CENTER, VPos.CENTER);
                }
                this.performingLayout = false;
            }

            public String getUserAgentStylesheet() {
                return JFoenixResources.load("css/controls/jfx-alert.css").toExternalForm();
            }

            protected Node createButtonBar() {
                return null;
            }
        };
        dialogPane.getStyleClass().add((Object)"jfx-alert-overlay");
        dialogPane.setContent(node);
        this.setDialogPane(dialogPane);
        dialogPane.getScene().setFill((Paint)Color.TRANSPARENT);
        if (window != null) {
            this.initStyle(StageStyle.TRANSPARENT);
            this.initOwner(window);
            dialogPane.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                if (this.isOverlayClose()) {
                    this.hide();
                }
            });
            this.widthListener = observable -> this.updateWidth();
            this.heightListener = observable -> this.updateHeight();
            this.xListener = observable -> this.updateX();
            this.yListener = observable -> this.updateY();
        }
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_SHOWING, dialogEvent -> {
            this.addLayoutListeners();
            JFXAlertAnimation jFXAlertAnimation = this.getCurrentAnimation();
            jFXAlertAnimation.initAnimation((Node)this.contentContainer.getParent(), (Node)dialogPane);
        });
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_SHOWN, dialogEvent -> {
            if (this.getOwner() != null) {
                this.updateLayout();
            }
            this.animateClosing = true;
            JFXAlertAnimation jFXAlertAnimation = this.getCurrentAnimation();
            Animation animation = jFXAlertAnimation.createShowingAnimation(dialogPane.getContent(), (Node)dialogPane);
            if (animation != null) {
                animation.play();
            }
        });
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_CLOSE_REQUEST, dialogEvent -> {
            if (this.animateClosing) {
                dialogEvent.consume();
                this.hideWithAnimation();
            }
        });
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_HIDDEN, dialogEvent -> this.removeLayoutListeners());
        this.getDialogPane().getScene().getWindow().addEventFilter(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE && !this.isHideOnEscape()) {
                keyEvent.consume();
            }
        });
    }

    private JFXAlertAnimation getCurrentAnimation() {
        JFXAlertAnimation jFXAlertAnimation = this.getAnimation();
        jFXAlertAnimation = jFXAlertAnimation == null ? JFXAlertAnimation.NO_ANIMATION : jFXAlertAnimation;
        return jFXAlertAnimation;
    }

    private void removeLayoutListeners() {
        Window window = this.getOwner();
        if (window != null) {
            window.getScene().widthProperty().removeListener(this.widthListener);
            window.getScene().heightProperty().removeListener(this.heightListener);
            window.xProperty().removeListener(this.xListener);
            window.yProperty().removeListener(this.yListener);
        }
    }

    private void addLayoutListeners() {
        Window window = this.getOwner();
        if (window != null) {
            if (this.widthListener == null) {
                throw new RuntimeException("Owner can only be set using the constructor");
            }
            window.getScene().widthProperty().addListener(this.widthListener);
            window.getScene().heightProperty().addListener(this.heightListener);
            window.xProperty().addListener(this.xListener);
            window.yProperty().addListener(this.yListener);
        }
    }

    private void updateLayout() {
        this.updateX();
        this.updateY();
        this.updateWidth();
        this.updateHeight();
    }

    private void updateHeight() {
        Window window = this.getOwner();
        this.setHeight(window.getScene().getHeight());
    }

    private void updateWidth() {
        Window window = this.getOwner();
        this.setWidth(window.getScene().getWidth());
    }

    private void updateY() {
        Window window = this.getOwner();
        this.setY(window.getY() + window.getScene().getY());
    }

    private void updateX() {
        Window window = this.getOwner();
        this.setX(window.getX() + window.getScene().getX());
    }

    public void hideWithAnimation() {
        if (this.transition == null || this.transition.getStatus().equals((Object)Animation.Status.STOPPED)) {
            JFXAlertAnimation jFXAlertAnimation = this.getCurrentAnimation();
            Animation animation = jFXAlertAnimation.createHidingAnimation(this.getDialogPane().getContent(), (Node)this.getDialogPane());
            if (animation != null) {
                this.transition = animation;
                animation.setOnFinished(actionEvent -> {
                    this.animateClosing = false;
                    this.hide();
                    this.transition = null;
                });
                animation.play();
            } else {
                this.animateClosing = false;
                this.transition = null;
                Platform.runLater(() -> ((JFXAlert)this).hide());
            }
        }
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return super.buildEventDispatchChain(eventDispatchChain).prepend((EventDispatcher)this.eventHandlerManager);
    }

    public void setContent(Node ... nodeArray) {
        this.contentContainer.getChildren().setAll((Object[])nodeArray);
    }

    public boolean isOverlayClose() {
        return this.overlayClose.get();
    }

    public BooleanProperty overlayCloseProperty() {
        return this.overlayClose;
    }

    public void setOverlayClose(boolean bl2) {
        this.overlayClose.set(bl2);
    }

    public JFXAlertAnimation getAnimation() {
        return (JFXAlertAnimation)this.animation.get();
    }

    public ObjectProperty<JFXAlertAnimation> animationProperty() {
        return this.animation;
    }

    public void setAnimation(JFXAlertAnimation jFXAlertAnimation) {
        this.animation.set((Object)jFXAlertAnimation);
    }

    public void setSize(double d2, double d3) {
        this.contentContainer.setPrefSize(d2, d3);
    }

    public final void setHideOnEscape(boolean bl2) {
        this.hideOnEscape.set(bl2);
    }

    public final boolean isHideOnEscape() {
        return this.hideOnEscape.get();
    }

    public final BooleanProperty hideOnEscapeProperty() {
        return this.hideOnEscape;
    }
}

