/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.utils;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.utils.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class OAuthEncoder {
    private static final String CHARSET = "UTF-8";
    private static final Map<String, String> ENCODING_RULES;

    public static String encode(String string) {
        String string2;
        Preconditions.checkNotNull(string, "Cannot encode null object");
        try {
            string2 = URLEncoder.encode(string, CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OAuthException("Charset not found while encoding string: UTF-8", unsupportedEncodingException);
        }
        for (Map.Entry<String, String> entry : ENCODING_RULES.entrySet()) {
            string2 = OAuthEncoder.applyRule(string2, entry.getKey(), entry.getValue());
        }
        return string2;
    }

    private static String applyRule(String string, String string2, String string3) {
        return string.replaceAll(Pattern.quote(string2), string3);
    }

    public static String decode(String string) {
        Preconditions.checkNotNull(string, "Cannot decode null object");
        try {
            return URLDecoder.decode(string, CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OAuthException("Charset not found while decoding string: UTF-8", unsupportedEncodingException);
        }
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("*", "%2A");
        hashMap.put("+", "%20");
        hashMap.put("%7E", "~");
        ENCODING_RULES = Collections.unmodifiableMap(hashMap);
    }
}

