/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.utils.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuth2AccessTokenJsonExtractor
implements TokenExtractor<OAuth2AccessToken> {
    private static final Pattern ACCESS_TOKEN_REGEX_PATTERN = Pattern.compile("\"access_token\"\\s*:\\s*\"(\\S*?)\"");
    private static final Pattern TOKEN_TYPE_REGEX_PATTERN = Pattern.compile("\"token_type\"\\s*:\\s*\"(\\S*?)\"");
    private static final Pattern EXPIRES_IN_REGEX_PATTERN = Pattern.compile("\"expires_in\"\\s*:\\s*\"?(\\d*?)\"?\\D");
    private static final Pattern REFRESH_TOKEN_REGEX_PATTERN = Pattern.compile("\"refresh_token\"\\s*:\\s*\"(\\S*?)\"");
    private static final Pattern SCOPE_REGEX_PATTERN = Pattern.compile("\"scope\"\\s*:\\s*\"([^\"]*?)\"");
    private static final Pattern ERROR_REGEX_PATTERN = Pattern.compile("\"error\"\\s*:\\s*\"(\\S*?)\"");
    private static final Pattern ERROR_DESCRIPTION_REGEX_PATTERN = Pattern.compile("\"error_description\"\\s*:\\s*\"([^\"]*?)\"");
    private static final Pattern ERROR_URI_REGEX_PATTERN = Pattern.compile("\"error_uri\"\\s*:\\s*\"(\\S*?)\"");

    protected OAuth2AccessTokenJsonExtractor() {
    }

    public static OAuth2AccessTokenJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public OAuth2AccessToken extract(Response response) throws IOException {
        String string = response.getBody();
        Preconditions.checkEmptyString(string, "Response body is incorrect. Can't extract a token from an empty string");
        if (response.getCode() != 200) {
            this.generateError(string);
        }
        return this.createToken(string);
    }

    public void generateError(String string) {
        OAuth2AccessTokenErrorResponse.ErrorCode errorCode;
        URI uRI;
        String string2 = OAuth2AccessTokenJsonExtractor.extractParameter(string, ERROR_REGEX_PATTERN, true);
        String string3 = OAuth2AccessTokenJsonExtractor.extractParameter(string, ERROR_DESCRIPTION_REGEX_PATTERN, false);
        String string4 = OAuth2AccessTokenJsonExtractor.extractParameter(string, ERROR_URI_REGEX_PATTERN, false);
        try {
            uRI = string4 == null ? null : URI.create(string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            uRI = null;
        }
        try {
            errorCode = OAuth2AccessTokenErrorResponse.ErrorCode.valueOf(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCode = null;
        }
        throw new OAuth2AccessTokenErrorResponse(errorCode, string3, uRI, string);
    }

    private OAuth2AccessToken createToken(String string) {
        Integer n2;
        String string2 = OAuth2AccessTokenJsonExtractor.extractParameter(string, ACCESS_TOKEN_REGEX_PATTERN, true);
        String string3 = OAuth2AccessTokenJsonExtractor.extractParameter(string, TOKEN_TYPE_REGEX_PATTERN, false);
        String string4 = OAuth2AccessTokenJsonExtractor.extractParameter(string, EXPIRES_IN_REGEX_PATTERN, false);
        try {
            n2 = string4 == null ? null : Integer.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = null;
        }
        String string5 = OAuth2AccessTokenJsonExtractor.extractParameter(string, REFRESH_TOKEN_REGEX_PATTERN, false);
        String string6 = OAuth2AccessTokenJsonExtractor.extractParameter(string, SCOPE_REGEX_PATTERN, false);
        return this.createToken(string2, string3, n2, string5, string6, string);
    }

    protected OAuth2AccessToken createToken(String string, String string2, Integer n2, String string3, String string4, String string5) {
        return new OAuth2AccessToken(string, string2, n2, string3, string4, string5);
    }

    protected static String extractParameter(String string, Pattern pattern, boolean bl2) throws OAuthException {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        if (bl2) {
            throw new OAuthException("Response body is incorrect. Can't extract a '" + pattern.pattern() + "' from this: '" + string + "'", null);
        }
        return null;
    }

    private static class InstanceHolder {
        private static final OAuth2AccessTokenJsonExtractor INSTANCE = new OAuth2AccessTokenJsonExtractor();

        private InstanceHolder() {
        }
    }
}

