/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth1Token;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractOAuth1JSONTokenExtractor<T extends OAuth1Token>
implements TokenExtractor<T> {
    private static final Pattern OAUTH_TOKEN_PATTERN = Pattern.compile("\"oauth_token\"\\s*:\\s*\"(\\S*?)\"");
    private static final Pattern OAUTH_TOKEN_SECRET_PATTERN = Pattern.compile("\"oauth_token_secret\"\\s*:\\s*\"(\\S*?)\"");

    @Override
    public T extract(Response response) throws IOException {
        String string = response.getBody();
        Preconditions.checkEmptyString(string, "Response body is incorrect. Can't extract a token from an empty string");
        String string2 = this.extract(string, OAUTH_TOKEN_PATTERN);
        String string3 = this.extract(string, OAUTH_TOKEN_SECRET_PATTERN);
        return this.createToken(string2, string3, string);
    }

    private String extract(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return OAuthEncoder.decode(matcher.group(1));
        }
        throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + string + '\'', null);
    }

    protected abstract T createToken(String var1, String var2, String var3);
}

