/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder.api;

import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.builder.api.ClientAuthenticationType;
import com.github.scribejava.core.builder.api.OAuth2SignatureType;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.util.Map;

public abstract class DefaultApi20
implements BaseApi<OAuth20Service> {
    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return OAuth2AccessTokenJsonExtractor.instance();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public abstract String getAccessTokenEndpoint();

    public String getRefreshTokenEndpoint() {
        return this.getAccessTokenEndpoint();
    }

    public String getRevokeTokenEndpoint() {
        throw new UnsupportedOperationException("This API doesn't support revoking tokens or we have no info about this");
    }

    protected abstract String getAuthorizationBaseUrl();

    public String getAuthorizationUrl(OAuthConfig oAuthConfig, Map<String, String> map) {
        String string;
        String string2;
        ParameterList parameterList = new ParameterList(map);
        parameterList.add("response_type", oAuthConfig.getResponseType());
        parameterList.add("client_id", oAuthConfig.getApiKey());
        String string3 = oAuthConfig.getCallback();
        if (string3 != null) {
            parameterList.add("redirect_uri", string3);
        }
        if ((string2 = oAuthConfig.getScope()) != null) {
            parameterList.add("scope", string2);
        }
        if ((string = oAuthConfig.getState()) != null) {
            parameterList.add("state", string);
        }
        return parameterList.appendTo(this.getAuthorizationBaseUrl());
    }

    @Override
    public OAuth20Service createService(OAuthConfig oAuthConfig) {
        return new OAuth20Service(this, oAuthConfig);
    }

    public OAuth2SignatureType getSignatureType() {
        return OAuth2SignatureType.BEARER_AUTHORIZATION_REQUEST_HEADER_FIELD;
    }

    public ClientAuthenticationType getClientAuthenticationType() {
        return ClientAuthenticationType.HTTP_BASIC_AUTHENTICATION_SCHEME;
    }
}

