/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class FacebookService
extends OAuth20Service {
    public FacebookService(DefaultApi20 defaultApi20, OAuthConfig oAuthConfig) {
        super(defaultApi20, oAuthConfig);
    }

    @Override
    public void signRequest(String string, OAuthRequest oAuthRequest) {
        super.signRequest(string, oAuthRequest);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.getConfig().getApiSecret().getBytes(), "HmacSHA256");
            mac.init(secretKeySpec);
            Formatter formatter = new Formatter();
            for (byte by2 : mac.doFinal(string.getBytes())) {
                formatter.format("%02x", by2);
            }
            oAuthRequest.addParameter("appsecret_proof", formatter.toString());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw new IllegalStateException("There is a problem while generating Facebook appsecret_proof.", generalSecurityException);
        }
    }
}

