/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.apis.service.ImgurOAuthService;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.ParameterList;
import java.util.Map;

public class ImgurApi
extends DefaultApi20 {
    protected ImgurApi() {
    }

    public static ImgurApi instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public String getAccessTokenEndpoint() {
        return "https://api.imgur.com/oauth2/token";
    }

    @Override
    public String getAuthorizationUrl(OAuthConfig oAuthConfig, Map<String, String> map) {
        String string;
        String string2;
        ParameterList parameterList = new ParameterList(map);
        parameterList.add("response_type", ImgurApi.isOob(oAuthConfig) ? "pin" : "code");
        parameterList.add("client_id", oAuthConfig.getApiKey());
        String string3 = oAuthConfig.getCallback();
        if (string3 != null) {
            parameterList.add("redirect_uri", string3);
        }
        if ((string2 = oAuthConfig.getScope()) != null) {
            parameterList.add("scope", string2);
        }
        if ((string = oAuthConfig.getState()) != null) {
            parameterList.add("state", string);
        }
        return parameterList.appendTo("https://api.imgur.com/oauth2/authorize");
    }

    @Override
    protected String getAuthorizationBaseUrl() {
        throw new UnsupportedOperationException("use getAuthorizationUrl instead");
    }

    @Override
    public ImgurOAuthService createService(OAuthConfig oAuthConfig) {
        return new ImgurOAuthService(this, oAuthConfig);
    }

    public static boolean isOob(OAuthConfig oAuthConfig) {
        return "oob".equals(oAuthConfig.getCallback());
    }

    private static class InstanceHolder {
        private static final ImgurApi INSTANCE = new ImgurApi();

        private InstanceHolder() {
        }
    }
}

