/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;

public class YAMLFactoryBuilder
extends TSFBuilder<YAMLFactory, YAMLFactoryBuilder> {
    protected int _formatGeneratorFeatures;
    protected StringQuotingChecker _quotingChecker;
    protected DumperOptions.Version _version;
    protected LoaderOptions _loaderOptions;
    protected DumperOptions _dumperOptions;

    protected YAMLFactoryBuilder() {
        this._formatGeneratorFeatures = YAMLFactory.DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
    }

    public YAMLFactoryBuilder(YAMLFactory yAMLFactory) {
        super(yAMLFactory);
        this._formatGeneratorFeatures = yAMLFactory._yamlGeneratorFeatures;
        this._version = yAMLFactory._version;
        this._quotingChecker = yAMLFactory._quotingChecker;
    }

    public YAMLFactoryBuilder enable(YAMLGenerator.Feature feature) {
        this._formatGeneratorFeatures |= feature.getMask();
        return this;
    }

    public YAMLFactoryBuilder enable(YAMLGenerator.Feature feature, YAMLGenerator.Feature ... featureArray) {
        this._formatGeneratorFeatures |= feature.getMask();
        for (YAMLGenerator.Feature feature2 : featureArray) {
            this._formatGeneratorFeatures |= feature2.getMask();
        }
        return this;
    }

    public YAMLFactoryBuilder disable(YAMLGenerator.Feature feature) {
        this._formatGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public YAMLFactoryBuilder disable(YAMLGenerator.Feature feature, YAMLGenerator.Feature ... featureArray) {
        this._formatGeneratorFeatures &= ~feature.getMask();
        for (YAMLGenerator.Feature feature2 : featureArray) {
            this._formatGeneratorFeatures &= ~feature2.getMask();
        }
        return this;
    }

    public YAMLFactoryBuilder configure(YAMLGenerator.Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public YAMLFactoryBuilder stringQuotingChecker(StringQuotingChecker stringQuotingChecker) {
        this._quotingChecker = stringQuotingChecker;
        return this;
    }

    public YAMLFactoryBuilder yamlVersionToWrite(DumperOptions.Version version) {
        this._version = version;
        return this;
    }

    public YAMLFactoryBuilder loaderOptions(LoaderOptions loaderOptions) {
        this._loaderOptions = loaderOptions;
        return this;
    }

    public YAMLFactoryBuilder dumperOptions(DumperOptions dumperOptions) {
        this._dumperOptions = dumperOptions;
        return this;
    }

    public int formatGeneratorFeaturesMask() {
        return this._formatGeneratorFeatures;
    }

    public DumperOptions.Version yamlVersionToWrite() {
        return this._version;
    }

    public StringQuotingChecker stringQuotingChecker() {
        if (this._quotingChecker != null) {
            return this._quotingChecker;
        }
        return StringQuotingChecker.Default.instance();
    }

    public LoaderOptions loaderOptions() {
        return this._loaderOptions;
    }

    public DumperOptions dumperOptions() {
        return this._dumperOptions;
    }

    @Override
    public YAMLFactory build() {
        return new YAMLFactory(this);
    }
}

