/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.LinkedNode;
import java.lang.reflect.Array;
import java.util.List;

public final class ObjectBuffer {
    private static final int SMALL_CHUNK = 16384;
    private static final int MAX_CHUNK = 262144;
    private LinkedNode<Object[]> _head;
    private LinkedNode<Object[]> _tail;
    private int _size;
    private Object[] _freeBuffer;

    public Object[] resetAndStart() {
        this._reset();
        if (this._freeBuffer == null) {
            this._freeBuffer = new Object[12];
            return this._freeBuffer;
        }
        return this._freeBuffer;
    }

    public Object[] resetAndStart(Object[] objectArray, int n2) {
        this._reset();
        if (this._freeBuffer == null || this._freeBuffer.length < n2) {
            this._freeBuffer = new Object[Math.max(12, n2)];
        }
        System.arraycopy(objectArray, 0, this._freeBuffer, 0, n2);
        return this._freeBuffer;
    }

    public Object[] appendCompletedChunk(Object[] objectArray) {
        LinkedNode<Object[]> linkedNode = new LinkedNode<Object[]>(objectArray, null);
        if (this._head == null) {
            this._tail = linkedNode;
            this._head = this._tail;
        } else {
            this._tail.linkNext(linkedNode);
            this._tail = linkedNode;
        }
        int n2 = objectArray.length;
        this._size += n2;
        if (n2 < 16384) {
            n2 += n2;
        } else if (n2 < 262144) {
            n2 += n2 >> 2;
        }
        return new Object[n2];
    }

    public Object[] completeAndClearBuffer(Object[] objectArray, int n2) {
        int n3 = n2 + this._size;
        Object[] objectArray2 = new Object[n3];
        this._copyTo(objectArray2, n3, objectArray, n2);
        this._reset();
        return objectArray2;
    }

    public <T> T[] completeAndClearBuffer(Object[] objectArray, int n2, Class<T> clazz) {
        int n3 = n2 + this._size;
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n3);
        this._copyTo(objectArray2, n3, objectArray, n2);
        this._reset();
        return objectArray2;
    }

    public void completeAndClearBuffer(Object[] objectArray, int n2, List<Object> list) {
        for (LinkedNode<Object[]> linkedNode = this._head; linkedNode != null; linkedNode = linkedNode.next()) {
            Object[] objectArray2 = linkedNode.value();
            int n3 = objectArray2.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                list.add(objectArray2[i2]);
            }
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            list.add(objectArray[i3]);
        }
        this._reset();
    }

    public int initialCapacity() {
        return this._freeBuffer == null ? 0 : this._freeBuffer.length;
    }

    public int bufferedSize() {
        return this._size;
    }

    protected void _reset() {
        if (this._tail != null) {
            this._freeBuffer = this._tail.value();
        }
        this._tail = null;
        this._head = null;
        this._size = 0;
    }

    protected final void _copyTo(Object object, int n2, Object[] objectArray, int n3) {
        int n4 = 0;
        for (LinkedNode<Object[]> linkedNode = this._head; linkedNode != null; linkedNode = linkedNode.next()) {
            Object[] objectArray2 = linkedNode.value();
            int n5 = objectArray2.length;
            System.arraycopy(objectArray2, 0, object, n4, n5);
            n4 += n5;
        }
        System.arraycopy(objectArray, 0, object, n4, n3);
        if ((n4 += n3) != n2) {
            throw new IllegalStateException("Should have gotten " + n2 + " entries, got " + n4);
        }
    }
}

