/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BeanUtil {
    @Deprecated
    public static String okNameForGetter(AnnotatedMethod annotatedMethod, boolean bl2) {
        String string = annotatedMethod.getName();
        String string2 = BeanUtil.okNameForIsGetter(annotatedMethod, string, bl2);
        if (string2 == null) {
            string2 = BeanUtil.okNameForRegularGetter(annotatedMethod, string, bl2);
        }
        return string2;
    }

    @Deprecated
    public static String okNameForRegularGetter(AnnotatedMethod annotatedMethod, String string, boolean bl2) {
        if (string.startsWith("get")) {
            if ("getCallbacks".equals(string) ? BeanUtil.isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && BeanUtil.isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            return bl2 ? BeanUtil.stdManglePropertyName(string, 3) : BeanUtil.legacyManglePropertyName(string, 3);
        }
        return null;
    }

    @Deprecated
    public static String okNameForIsGetter(AnnotatedMethod annotatedMethod, String string, boolean bl2) {
        Class<?> clazz;
        if (string.startsWith("is") && ((clazz = annotatedMethod.getRawType()) == Boolean.class || clazz == Boolean.TYPE)) {
            return bl2 ? BeanUtil.stdManglePropertyName(string, 2) : BeanUtil.legacyManglePropertyName(string, 2);
        }
        return null;
    }

    @Deprecated
    public static String okNameForSetter(AnnotatedMethod annotatedMethod, boolean bl2) {
        return BeanUtil.okNameForMutator(annotatedMethod, "set", bl2);
    }

    @Deprecated
    public static String okNameForMutator(AnnotatedMethod annotatedMethod, String string, boolean bl2) {
        String string2 = annotatedMethod.getName();
        if (string2.startsWith(string)) {
            return bl2 ? BeanUtil.stdManglePropertyName(string2, string.length()) : BeanUtil.legacyManglePropertyName(string2, string.length());
        }
        return null;
    }

    public static Object getDefaultValue(JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        Class<?> clazz2 = ClassUtil.primitiveType(clazz);
        if (clazz2 != null) {
            return ClassUtil.defaultValue(clazz2);
        }
        if (javaType.isContainerType() || javaType.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (clazz == String.class) {
            return "";
        }
        if (javaType.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (javaType.isTypeOrSubTypeOf(Calendar.class)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(0L);
            return gregorianCalendar;
        }
        return null;
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod annotatedMethod) {
        Class<?> clazz;
        String string;
        Class<?> clazz2 = annotatedMethod.getRawType();
        if (clazz2.isArray() && (string = (clazz = clazz2.getComponentType()).getName()).contains(".cglib")) {
            return string.startsWith("net.sf.cglib") || string.startsWith("org.hibernate.repackage.cglib") || string.startsWith("org.springframework.cglib");
        }
        return false;
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.getRawType().getName().startsWith("groovy.lang");
    }

    protected static String legacyManglePropertyName(String string, int n2) {
        char c2;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c3 = string.charAt(n2);
        if (c3 == (c2 = Character.toLowerCase(c3))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c2);
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            c3 = string.charAt(i2);
            if (c3 == (c2 = Character.toLowerCase(c3))) {
                stringBuilder.append(string, i2, n3);
                break;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String stdManglePropertyName(String string, int n2) {
        char c2;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c3 = string.charAt(n2);
        if (c3 == (c2 = Character.toLowerCase(c3))) {
            return string.substring(n2);
        }
        if (n2 + 1 < n3 && Character.isUpperCase(string.charAt(n2 + 1))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c2);
        stringBuilder.append(string, n2 + 1, n3);
        return stringBuilder.toString();
    }

    public static String checkUnsupportedType(JavaType javaType) {
        String string;
        String string2;
        String string3 = javaType.getRawClass().getName();
        if (BeanUtil.isJava8TimeClass(string3)) {
            if (string3.indexOf(46, 10) >= 0) {
                return null;
            }
            string2 = "Java 8 date/time";
            string = "com.fasterxml.jackson.datatype:jackson-datatype-jsr310";
        } else if (BeanUtil.isJodaTimeClass(string3)) {
            string2 = "Joda date/time";
            string = "com.fasterxml.jackson.datatype:jackson-datatype-joda";
        } else {
            return null;
        }
        return String.format("%s type %s not supported by default: add Module \"%s\" to enable handling", string2, ClassUtil.getTypeDescription(javaType), string);
    }

    public static boolean isJava8TimeClass(Class<?> clazz) {
        return BeanUtil.isJava8TimeClass(clazz.getName());
    }

    private static boolean isJava8TimeClass(String string) {
        return string.startsWith("java.time.");
    }

    public static boolean isJodaTimeClass(Class<?> clazz) {
        return BeanUtil.isJodaTimeClass(clazz.getName());
    }

    private static boolean isJodaTimeClass(String string) {
        return string.startsWith("org.joda.time.");
    }
}

