/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Set;

public class BeanAsArrayDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;

    public BeanAsArrayDeserializer(BeanDeserializerBase beanDeserializerBase, SettableBeanProperty[] settableBeanPropertyArray) {
        super(beanDeserializerBase);
        this._delegate = beanDeserializerBase;
        this._orderedProperties = settableBeanPropertyArray;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        return this._delegate.unwrappingDeserializer(nameTransformer);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BeanAsArrayDeserializer(this._delegate.withObjectIdReader(objectIdReader), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withByNameInclusion(Set<String> set, Set<String> set2) {
        return new BeanAsArrayDeserializer(this._delegate.withByNameInclusion(set, set2), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean bl2) {
        return new BeanAsArrayDeserializer(this._delegate.withIgnoreAllUnknown(bl2), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap beanPropertyMap) {
        return new BeanAsArrayDeserializer(this._delegate.withBeanProperties(beanPropertyMap), this._orderedProperties);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return this;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(jsonParser, deserializationContext);
        }
        if (!this._vanillaProcessing) {
            return this._deserializeNonVanilla(jsonParser, deserializationContext);
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        jsonParser.setCurrentValue(object);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = 0;
        int n3 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n2 == n3) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n2];
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, settableBeanProperty.getName(), deserializationContext);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n2;
        }
        if (!this._ignoreAllUnknown && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            deserializationContext.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", n3);
        }
        do {
            jsonParser.skipChildren();
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return object;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        jsonParser.setCurrentValue(object);
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(jsonParser, deserializationContext);
        }
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = 0;
        int n3 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n2 == n3) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n2];
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, settableBeanProperty.getName(), deserializationContext);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n2;
        }
        if (!this._ignoreAllUnknown && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            deserializationContext.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", n3);
        }
        do {
            jsonParser.skipChildren();
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return object;
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserializeFromNonArray(jsonParser, deserializationContext);
    }

    protected Object _deserializeNonVanilla(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._nonStandardCreation) {
            return this.deserializeFromObjectUsingNonDefault(jsonParser, deserializationContext);
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        jsonParser.setCurrentValue(object);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = 0;
        int n3 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n2 == n3) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n2];
            ++n2;
            if (settableBeanProperty != null && (clazz == null || settableBeanProperty.visibleInView(clazz))) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, settableBeanProperty.getName(), deserializationContext);
                }
                continue;
            }
            jsonParser.skipChildren();
        }
        if (!this._ignoreAllUnknown) {
            deserializationContext.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", n3);
        }
        do {
            jsonParser.skipChildren();
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return object;
    }

    @Override
    protected final Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Class<?> clazz;
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = settableBeanPropertyArray.length;
        int n3 = 0;
        Object object = null;
        Class<?> clazz2 = clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            block19: {
                SettableBeanProperty settableBeanProperty;
                SettableBeanProperty settableBeanProperty2 = settableBeanProperty = n3 < n2 ? settableBeanPropertyArray[n3] : null;
                if (settableBeanProperty == null) {
                    jsonParser.skipChildren();
                } else if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else if (object != null) {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, settableBeanProperty.getName(), deserializationContext);
                    }
                } else {
                    String string = settableBeanProperty.getName();
                    SettableBeanProperty settableBeanProperty3 = propertyBasedCreator.findCreatorProperty(string);
                    if (!propertyValueBuffer.readIdProperty(string) || settableBeanProperty3 != null) {
                        if (settableBeanProperty3 != null) {
                            if (propertyValueBuffer.assignParameter(settableBeanProperty3, settableBeanProperty3.deserialize(jsonParser, deserializationContext))) {
                                try {
                                    object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                                }
                                catch (Exception exception) {
                                    this.wrapAndThrow(exception, this._beanType.getRawClass(), string, deserializationContext);
                                    break block19;
                                }
                                jsonParser.setCurrentValue(object);
                                if (object.getClass() != this._beanType.getRawClass()) {
                                    deserializationContext.reportBadDefinition(this._beanType, String.format("Cannot support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type %s, actual type %s", ClassUtil.getTypeDescription(this._beanType), ClassUtil.getClassDescription(object)));
                                }
                            }
                        } else {
                            propertyValueBuffer.bufferProperty(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            ++n3;
        }
        if (object == null) {
            try {
                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
            }
            catch (Exception exception) {
                return this.wrapInstantiationProblem(exception, deserializationContext);
            }
        }
        return object;
    }

    protected Object _deserializeFromNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string = "Cannot deserialize a POJO (of type %s) from non-Array representation (token: %s): type/property designed to be serialized as JSON Array";
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser.currentToken(), jsonParser, string, new Object[]{ClassUtil.getTypeDescription(this._beanType), jsonParser.currentToken()});
    }
}

