/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.JDKValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class SettableAnyProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final BeanProperty _property;
    protected final AnnotatedMember _setter;
    protected final boolean _setterIsField;
    protected final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final KeyDeserializer _keyDeserializer;

    public SettableAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        this._property = beanProperty;
        this._setter = annotatedMember;
        this._type = javaType;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._keyDeserializer = keyDeserializer;
        this._setterIsField = annotatedMember instanceof AnnotatedField;
    }

    public static SettableAnyProperty constructForMethod(DeserializationContext deserializationContext, BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        return new MethodAnyProperty(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer);
    }

    public static SettableAnyProperty constructForMapField(DeserializationContext deserializationContext, BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        Class<Object> clazz = annotatedMember.getRawType();
        if (clazz == Map.class) {
            clazz = LinkedHashMap.class;
        }
        ValueInstantiator valueInstantiator = JDKValueInstantiators.findStdValueInstantiator(deserializationContext.getConfig(), clazz);
        return new MapFieldAnyProperty(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer, valueInstantiator);
    }

    public static SettableAnyProperty constructForJsonNodeField(DeserializationContext deserializationContext, BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) {
        return new JsonNodeFieldAnyProperty(beanProperty, annotatedMember, javaType, jsonDeserializer, deserializationContext.getNodeFactory());
    }

    public abstract SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> var1);

    public void fixAccess(DeserializationConfig deserializationConfig) {
        this._setter.fixAccess(deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    Object readResolve() {
        if (this._setter == null || this._setter.getAnnotated() == null) {
            throw new IllegalArgumentException("Missing method/field (broken JDK (de)serialization?)");
        }
        return this;
    }

    public BeanProperty getProperty() {
        return this._property;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public JavaType getType() {
        return this._type;
    }

    public String getPropertyName() {
        return this._property.getName();
    }

    public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) throws IOException {
        try {
            String string2 = this._keyDeserializer == null ? string : this._keyDeserializer.deserializeKey(string, deserializationContext);
            this.set(object, string2, this.deserialize(jsonParser, deserializationContext));
        }
        catch (UnresolvedForwardReference unresolvedForwardReference) {
            if (this._valueDeserializer.getObjectIdReader() == null) {
                throw JsonMappingException.from(jsonParser, "Unresolved forward reference but no identity info.", (Throwable)unresolvedForwardReference);
            }
            AnySetterReferring anySetterReferring = new AnySetterReferring(this, unresolvedForwardReference, this._type.getRawClass(), object, string);
            unresolvedForwardReference.getRoid().appendReferring(anySetterReferring);
        }
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return this._valueDeserializer.getNullValue(deserializationContext);
        }
        if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
    }

    public void set(Object object, Object object2, Object object3) throws IOException {
        try {
            this._set(object, object2, object3);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2, object3);
        }
    }

    protected abstract void _set(Object var1, Object var2, Object var3) throws Exception;

    protected void _throwAsIOE(Exception exception, Object object, Object object2) throws IOException {
        if (exception instanceof IllegalArgumentException) {
            String string = ClassUtil.classNameOf(object2);
            StringBuilder stringBuilder = new StringBuilder("Problem deserializing \"any-property\" '").append(object);
            stringBuilder.append("' of class " + this.getClassName() + " (expected type: ").append(this._type);
            stringBuilder.append("; actual type: ").append(string).append(")");
            String string2 = ClassUtil.exceptionMessage(exception);
            if (string2 != null) {
                stringBuilder.append(", problem: ").append(string2);
            } else {
                stringBuilder.append(" (no error message provided)");
            }
            throw new JsonMappingException(null, stringBuilder.toString(), (Throwable)exception);
        }
        ClassUtil.throwIfIOE(exception);
        ClassUtil.throwIfRTE(exception);
        Throwable throwable = ClassUtil.getRootCause(exception);
        throw new JsonMappingException(null, ClassUtil.exceptionMessage(throwable), throwable);
    }

    private String getClassName() {
        return ClassUtil.nameOf(this._setter.getDeclaringClass());
    }

    public String toString() {
        return "[any property on class " + this.getClassName() + "]";
    }

    protected static class JsonNodeFieldAnyProperty
    extends SettableAnyProperty
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final JsonNodeFactory _nodeFactory;

        public JsonNodeFieldAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, JsonNodeFactory jsonNodeFactory) {
            super(beanProperty, annotatedMember, javaType, null, jsonDeserializer, null);
            this._nodeFactory = jsonNodeFactory;
        }

        @Override
        public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) throws IOException {
            this.setProperty(object, string, (JsonNode)this.deserialize(jsonParser, deserializationContext));
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
        }

        @Override
        protected void _set(Object object, Object object2, Object object3) throws Exception {
            this.setProperty(object, (String)object2, (JsonNode)object3);
        }

        protected void setProperty(Object object, String string, JsonNode jsonNode) throws IOException {
            ObjectNode objectNode;
            AnnotatedField annotatedField = (AnnotatedField)this._setter;
            Object object2 = annotatedField.getValue(object);
            if (object2 == null) {
                objectNode = this._nodeFactory.objectNode();
                annotatedField.setValue(object, objectNode);
            } else {
                if (!(object2 instanceof ObjectNode)) {
                    throw JsonMappingException.from((DeserializationContext)null, String.format("Value \"any-setter\" '%s' not `ObjectNode` but %s", this.getPropertyName(), ClassUtil.nameOf(object2.getClass())));
                }
                objectNode = (ObjectNode)object2;
            }
            objectNode.set(string, jsonNode);
        }

        @Override
        public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
            return this;
        }
    }

    protected static class MapFieldAnyProperty
    extends SettableAnyProperty
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final ValueInstantiator _valueInstantiator;

        public MapFieldAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator) {
            super(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer);
            this._valueInstantiator = valueInstantiator;
        }

        @Override
        public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
            return new MapFieldAnyProperty(this._property, this._setter, this._type, this._keyDeserializer, jsonDeserializer, this._valueTypeDeserializer, this._valueInstantiator);
        }

        @Override
        protected void _set(Object object, Object object2, Object object3) throws Exception {
            AnnotatedField annotatedField = (AnnotatedField)this._setter;
            Map<Object, Object> map = (Map<Object, Object>)annotatedField.getValue(object);
            if (map == null) {
                map = this._createAndSetMap(null, annotatedField, object, object2);
            }
            map.put(object2, object3);
        }

        protected Map<Object, Object> _createAndSetMap(DeserializationContext deserializationContext, AnnotatedField annotatedField, Object object, Object object2) throws IOException {
            if (this._valueInstantiator == null) {
                throw JsonMappingException.from(deserializationContext, String.format("Cannot create an instance of %s for use as \"any-setter\" '%s'", ClassUtil.nameOf(this._type.getRawClass()), this._property.getName()));
            }
            Map map = (Map)this._valueInstantiator.createUsingDefault(deserializationContext);
            annotatedField.setValue(object, map);
            return map;
        }
    }

    protected static class MethodAnyProperty
    extends SettableAnyProperty
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public MethodAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
            super(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer);
        }

        @Override
        protected void _set(Object object, Object object2, Object object3) throws Exception {
            ((AnnotatedMethod)this._setter).callOnWith(object, object2, object3);
        }

        @Override
        public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
            return new MethodAnyProperty(this._property, this._setter, this._type, this._keyDeserializer, jsonDeserializer, this._valueTypeDeserializer);
        }
    }

    private static class AnySetterReferring
    extends ReadableObjectId.Referring {
        private final SettableAnyProperty _parent;
        private final Object _pojo;
        private final String _propName;

        public AnySetterReferring(SettableAnyProperty settableAnyProperty, UnresolvedForwardReference unresolvedForwardReference, Class<?> clazz, Object object, String string) {
            super(unresolvedForwardReference, clazz);
            this._parent = settableAnyProperty;
            this._pojo = object;
            this._propName = string;
        }

        @Override
        public void handleResolvedForwardReference(Object object, Object object2) throws IOException {
            if (!this.hasId(object)) {
                throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + object.toString() + "] that wasn't previously registered.");
            }
            this._parent.set(this._pojo, this._propName, object2);
        }
    }
}

