/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json.async;

import com.fasterxml.jackson.core.async.ByteBufferFeeder;
import com.fasterxml.jackson.core.async.NonBlockingInputFeeder;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.async.NonBlockingUtf8JsonParserBase;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public class NonBlockingByteBufferJsonParser
extends NonBlockingUtf8JsonParserBase
implements ByteBufferFeeder {
    private ByteBuffer _inputBuffer = ByteBuffer.wrap(NO_BYTES);

    public NonBlockingByteBufferJsonParser(IOContext iOContext, int n2, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        super(iOContext, n2, byteQuadsCanonicalizer);
    }

    @Override
    public NonBlockingInputFeeder getNonBlockingInputFeeder() {
        return this;
    }

    @Override
    public void feedInput(ByteBuffer byteBuffer) throws IOException {
        if (this._inputPtr < this._inputEnd) {
            this._reportError("Still have %d undecoded bytes, should not call 'feedInput'", this._inputEnd - this._inputPtr);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (n3 < n2) {
            this._reportError("Input end (%d) may not be before start (%d)", n3, n2);
        }
        if (this._endOfInput) {
            this._reportError("Already closed, can not feed more input");
        }
        this._currInputProcessed += (long)this._origBufferLen;
        this._currInputRowStart = n2 - (this._inputEnd - this._currInputRowStart);
        this._currBufferStart = n2;
        this._inputBuffer = byteBuffer;
        this._inputPtr = n2;
        this._inputEnd = n3;
        this._origBufferLen = n3 - n2;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) throws IOException {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 > 0) {
            WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
            writableByteChannel.write(this._inputBuffer);
        }
        return n2;
    }

    @Override
    protected byte getNextSignedByteFromBuffer() {
        return this._inputBuffer.get(this._inputPtr++);
    }

    @Override
    protected int getNextUnsignedByteFromBuffer() {
        return this._inputBuffer.get(this._inputPtr++) & 0xFF;
    }

    @Override
    protected byte getByteFromBuffer(int n2) {
        return this._inputBuffer.get(n2);
    }
}

