/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.DoubleBitsFromCharArray;
import com.fasterxml.jackson.core.io.doubleparser.DoubleBitsFromCharSequence;

public class FastDoubleParser {
    private static final DoubleBitsFromCharArray CHAR_ARRAY_PARSER = new DoubleBitsFromCharArray();
    private static final DoubleBitsFromCharSequence CHAR_SEQ_PARSER = new DoubleBitsFromCharSequence();

    private FastDoubleParser() {
    }

    public static double parseDouble(CharSequence charSequence) throws NumberFormatException {
        return FastDoubleParser.parseDouble(charSequence, 0, charSequence.length());
    }

    public static double parseDouble(CharSequence charSequence, int n2, int n3) throws NumberFormatException {
        long l2 = CHAR_SEQ_PARSER.parseFloatingPointLiteral(charSequence, n2, n3);
        if (l2 == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Double.longBitsToDouble(l2);
    }

    public static double parseDouble(char[] cArray) throws NumberFormatException {
        return FastDoubleParser.parseDouble(cArray, 0, cArray.length);
    }

    public static double parseDouble(char[] cArray, int n2, int n3) throws NumberFormatException {
        long l2 = CHAR_ARRAY_PARSER.parseFloatingPointLiteral(cArray, n2, n3);
        if (l2 == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Double.longBitsToDouble(l2);
    }

    public static long parseDoubleBits(CharSequence charSequence, int n2, int n3) {
        return CHAR_SEQ_PARSER.parseFloatingPointLiteral(charSequence, n2, n3);
    }

    public static long parseDoubleBits(char[] cArray, int n2, int n3) {
        return CHAR_ARRAY_PARSER.parseFloatingPointLiteral(cArray, n2, n3);
    }
}

