/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import java.util.UUID;

public class ObjectIdGenerators {

    public static final class StringIdGenerator
    extends Base<String> {
        private static final long serialVersionUID = 1L;

        public StringIdGenerator() {
            this(Object.class);
        }

        private StringIdGenerator(Class<?> clazz) {
            super(Object.class);
        }

        @Override
        public ObjectIdGenerator<String> forScope(Class<?> clazz) {
            return this;
        }

        @Override
        public ObjectIdGenerator<String> newForSerialization(Object object) {
            return this;
        }

        @Override
        public String generateId(Object object) {
            return UUID.randomUUID().toString();
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object object) {
            if (object == null) {
                return null;
            }
            return new ObjectIdGenerator.IdKey(this.getClass(), null, object);
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator instanceof StringIdGenerator;
        }
    }

    public static final class UUIDGenerator
    extends Base<UUID> {
        private static final long serialVersionUID = 1L;

        public UUIDGenerator() {
            this(Object.class);
        }

        private UUIDGenerator(Class<?> clazz) {
            super(Object.class);
        }

        @Override
        public ObjectIdGenerator<UUID> forScope(Class<?> clazz) {
            return this;
        }

        @Override
        public ObjectIdGenerator<UUID> newForSerialization(Object object) {
            return this;
        }

        @Override
        public UUID generateId(Object object) {
            return UUID.randomUUID();
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object object) {
            if (object == null) {
                return null;
            }
            return new ObjectIdGenerator.IdKey(this.getClass(), null, object);
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator.getClass() == this.getClass();
        }
    }

    public static final class IntSequenceGenerator
    extends Base<Integer> {
        private static final long serialVersionUID = 1L;
        protected transient int _nextValue;

        public IntSequenceGenerator() {
            this(Object.class, -1);
        }

        public IntSequenceGenerator(Class<?> clazz, int n2) {
            super(clazz);
            this._nextValue = n2;
        }

        protected int initialValue() {
            return 1;
        }

        @Override
        public ObjectIdGenerator<Integer> forScope(Class<?> clazz) {
            return this._scope == clazz ? this : new IntSequenceGenerator(clazz, this._nextValue);
        }

        @Override
        public ObjectIdGenerator<Integer> newForSerialization(Object object) {
            return new IntSequenceGenerator(this._scope, this.initialValue());
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object object) {
            if (object == null) {
                return null;
            }
            return new ObjectIdGenerator.IdKey(this.getClass(), this._scope, object);
        }

        @Override
        public Integer generateId(Object object) {
            if (object == null) {
                return null;
            }
            int n2 = this._nextValue++;
            return n2;
        }
    }

    public static abstract class PropertyGenerator
    extends Base<Object> {
        private static final long serialVersionUID = 1L;

        protected PropertyGenerator(Class<?> clazz) {
            super(clazz);
        }
    }

    public static abstract class None
    extends ObjectIdGenerator<Object> {
    }

    private static abstract class Base<T>
    extends ObjectIdGenerator<T> {
        protected final Class<?> _scope;

        protected Base(Class<?> clazz) {
            this._scope = clazz;
        }

        @Override
        public final Class<?> getScope() {
            return this._scope;
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator.getClass() == this.getClass() && objectIdGenerator.getScope() == this._scope;
        }

        @Override
        public abstract T generateId(Object var1);
    }
}

