/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import atlantafx.base.util.MaskChar;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class SimpleMaskChar
implements MaskChar {
    private final Predicate<Character> matchExpr;
    private final UnaryOperator<Character> transform;
    private final char placeholder;
    private final boolean fixed;

    public SimpleMaskChar(Predicate<Character> predicate) {
        this(predicate, UnaryOperator.identity(), '_', false);
    }

    public SimpleMaskChar(Predicate<Character> predicate, UnaryOperator<Character> unaryOperator) {
        this(predicate, unaryOperator, '_', false);
    }

    public SimpleMaskChar(Predicate<Character> predicate, UnaryOperator<Character> unaryOperator, char c2) {
        this(predicate, unaryOperator, c2, false);
    }

    public SimpleMaskChar(Predicate<Character> predicate, UnaryOperator<Character> unaryOperator, char c2, boolean bl2) {
        this.matchExpr = Objects.requireNonNull(predicate);
        this.transform = Objects.requireNonNull(unaryOperator);
        this.placeholder = c2;
        this.fixed = bl2;
    }

    @Override
    public boolean isAllowed(char c2) {
        return this.matchExpr.test(Character.valueOf(c2));
    }

    @Override
    public char transform(char c2) {
        return ((Character)this.transform.apply(Character.valueOf(c2))).charValue();
    }

    @Override
    public char getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    public static SimpleMaskChar fixed(char c2) {
        return new SimpleMaskChar(c3 -> c3.charValue() == c2, UnaryOperator.identity(), c2, true);
    }
}

