/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;

public class PasswordTextFormatter
extends TextFormatter<String> {
    public static final char BULLET = '\u2731';

    protected PasswordTextFormatter(StringConverter<String> stringConverter, UnaryOperator<TextFormatter.Change> unaryOperator, TextField textField, char c2) {
        super(stringConverter, null, unaryOperator);
        if (stringConverter == null) {
            throw new NullPointerException("StringConverter cannot be null!");
        }
        if (unaryOperator == null) {
            throw new NullPointerException("UnaryOperator cannot be null!");
        }
        if (textField == null) {
            throw new NullPointerException("TextField cannot be null!");
        }
        PasswordFilter passwordFilter = (PasswordFilter)this.getFilter();
        passwordFilter.setBullet(c2);
        passwordFilter.setInitialText(textField.getText());
        this.revealPasswordProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3 == null) {
                return;
            }
            textField.positionCaret(0);
            textField.commitValue();
        });
        Platform.runLater(() -> ((TextField)textField).commitValue());
    }

    public ReadOnlyStringProperty passwordProperty() {
        return ((PasswordFilter)this.getFilter()).password.getReadOnlyProperty();
    }

    public String getPassword() {
        return (String)this.passwordProperty().get();
    }

    public BooleanProperty revealPasswordProperty() {
        return ((PasswordFilter)this.getFilter()).revealPassword;
    }

    public boolean getRevealPassword() {
        return this.revealPasswordProperty().get();
    }

    public void setRevealPassword(boolean bl2) {
        this.revealPasswordProperty().set(bl2);
    }

    public static PasswordTextFormatter create(TextField textField, char c2) {
        PasswordFilter passwordFilter = new PasswordFilter();
        PasswordStringConverter passwordStringConverter = new PasswordStringConverter(passwordFilter);
        PasswordTextFormatter passwordTextFormatter = new PasswordTextFormatter(passwordStringConverter, passwordFilter, textField, c2);
        textField.setTextFormatter((TextFormatter)passwordTextFormatter);
        return passwordTextFormatter;
    }

    public static PasswordTextFormatter create(TextField textField) {
        return PasswordTextFormatter.create(textField, '\u2731');
    }

    protected static class PasswordFilter
    implements UnaryOperator<TextFormatter.Change> {
        protected final ReadOnlyStringWrapper password = new ReadOnlyStringWrapper("");
        protected final BooleanProperty revealPassword = new SimpleBooleanProperty(false);
        protected final StringBuilder sb = new StringBuilder();
        protected char bullet = (char)10033;

        protected PasswordFilter() {
        }

        @Override
        public TextFormatter.Change apply(TextFormatter.Change change) {
            if (change.isReplaced()) {
                this.sb.replace(change.getRangeStart(), change.getRangeEnd(), change.getText());
            } else if (change.isDeleted()) {
                this.sb.delete(change.getRangeStart(), change.getRangeEnd());
            } else if (change.isAdded()) {
                if (change.getRangeStart() == this.sb.length()) {
                    this.sb.append(change.getText());
                } else {
                    this.sb.insert(change.getRangeStart(), change.getText());
                }
            }
            if (change.getText() != null && !change.getText().isEmpty() && !this.revealPassword.get()) {
                change.setText(this.maskText(change.getText().length()));
            }
            this.password.set(this.sb.toString());
            return change;
        }

        protected void setBullet(char c2) {
            this.bullet = c2;
        }

        protected String maskText(int n2) {
            return String.valueOf(this.bullet).repeat(n2);
        }

        protected void setInitialText(String string) {
            if (string != null && !string.isEmpty()) {
                this.sb.append(string);
                this.password.set(this.sb.toString());
            }
        }
    }

    protected static class PasswordStringConverter
    extends StringConverter<String> {
        protected final PasswordFilter filter;

        public PasswordStringConverter(PasswordFilter passwordFilter) {
            this.filter = passwordFilter;
        }

        public String toString(String string) {
            return this.getPassword();
        }

        public String fromString(String string) {
            return this.getPassword();
        }

        protected String getPassword() {
            String string = this.filter.password.get();
            return this.filter.revealPassword.get() ? string : this.filter.maskText(string.length());
        }
    }
}

