/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import java.text.DecimalFormat;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.util.StringConverter;

public class DoubleStringConverter
extends StringConverter<Double> {
    private final DecimalFormat decimalFormat = new DecimalFormat("0.##");
    private Runnable reset;

    public DoubleStringConverter() {
    }

    public DoubleStringConverter(Runnable runnable) {
        this.reset = runnable;
    }

    public DoubleStringConverter(TextField textField, double d2, double d3) {
        if (textField == null) {
            throw new NullPointerException("Input cannot be null!");
        }
        double d4 = Math.min(Math.max(0.0, d2), d3);
        this.reset = () -> textField.setText(this.decimalFormat.format(d4));
        textField.textProperty().addListener((observableValue, string, string2) -> {
            if (string2 == null || string2.isEmpty()) {
                return;
            }
            if (d2 < 0.0 && string2.endsWith("-")) {
                if (string2.length() > 1) {
                    Platform.runLater(() -> textField.setText("-"));
                }
                return;
            }
            try {
                Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Platform.runLater(() -> textField.setText(string));
            }
        });
        EventHandler eventHandler = textField.getOnAction();
        textField.setOnAction(actionEvent -> {
            double d4;
            double d5 = this.fromString(textField.getText());
            if (d5 != (d4 = Math.min(Math.max(d5, d2), d3))) {
                textField.setText(this.decimalFormat.format(d4));
            }
            if (eventHandler != null) {
                eventHandler.handle(actionEvent);
            }
        });
    }

    public static DoubleStringConverter createFor(Spinner<Double> spinner) {
        SpinnerValueFactory.DoubleSpinnerValueFactory doubleSpinnerValueFactory = (SpinnerValueFactory.DoubleSpinnerValueFactory)spinner.getValueFactory();
        DoubleStringConverter doubleStringConverter = new DoubleStringConverter(spinner.getEditor(), doubleSpinnerValueFactory.getMin(), doubleSpinnerValueFactory.getMax());
        doubleSpinnerValueFactory.setConverter((StringConverter)doubleStringConverter);
        spinner.setTooltip(new Tooltip(String.format("Enter a value between %.2f and %.2f", doubleSpinnerValueFactory.getMin(), doubleSpinnerValueFactory.getMax())));
        return doubleStringConverter;
    }

    public void setReset(Runnable runnable) {
        this.reset = runnable;
    }

    public Double fromString(String string) {
        if (string == null || string.isEmpty()) {
            if (this.reset != null) {
                this.reset.run();
            }
            return 0.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.reset != null) {
                this.reset.run();
            }
            return 0.0;
        }
    }

    public String toString(Double d2) {
        if (d2 == null) {
            return "0";
        }
        return this.decimalFormat.format(d2);
    }
}

