/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.jetbrains.annotations.Nullable;

public interface BBCodeHandler {
    public void startDocument(char[] var1);

    public void endDocument();

    public void startTag(String var1, @Nullable Map<String, String> var2, int var3, int var4);

    public void endTag(String var1, int var2, int var3);

    public void characters(int var1, int var2);

    public record Tag(String name, Type type, @Nullable Map<String, String> params, Set<String> styleClasses, Set<String> styles) {
        public Tag(String string, Type type, @Nullable Map<String, String> map, Set<String> set, Set<String> set2) {
            Objects.requireNonNull(string);
            Objects.requireNonNull(type);
            map = Objects.requireNonNullElse(map, Collections.emptyMap());
            set = Objects.requireNonNullElse(set, Collections.emptySet());
            set2 = Objects.requireNonNullElse(set2, Collections.emptySet());
        }

        public boolean hasParam(String string) {
            return this.params != null && this.params.containsKey(string);
        }

        public String getParam(String string) {
            return this.params != null ? this.params.get(string) : null;
        }

        public String getParam(String string, String string2) {
            return this.params != null ? this.params.getOrDefault(string, string2) : string2;
        }

        public boolean isBlock() {
            return this.type == Type.BLOCK;
        }

        public boolean isSelfClose() {
            return this.type == Type.SELF_CLOSE;
        }

        public static enum Type {
            BLOCK,
            TEXT,
            SELF_CLOSE;

        }
    }

    public record Block(Pane node, @Nullable TextFlow text) {
        public Block(Pane pane, @Nullable TextFlow textFlow) {
            Objects.requireNonNull(pane);
        }

        public void addText(Node node) {
            if (this.canContainText()) {
                this.text.getChildren().add((Object)node);
            }
        }

        public List<Node> children() {
            return this.node.getChildren();
        }

        public int size() {
            return this.node.getChildren().size();
        }

        public boolean isEmpty() {
            return this.node.getChildren().isEmpty();
        }

        public boolean canContainText() {
            return this.text != null;
        }
    }

    public static class Default<T extends Pane>
    implements BBCodeHandler {
        protected static final int OL_LETTER_OFFSET = 100000;
        protected final Block root;
        protected final Deque<Tag> openTags = new ArrayDeque<Tag>();
        protected final Deque<Block> openBlocks = new ArrayDeque<Block>();
        protected char[] doc;
        protected int textCursor;

        public Default(T t2) {
            Block block;
            Objects.requireNonNull(t2, "Root container cannot be null.");
            if (t2 instanceof TextFlow) {
                TextFlow textFlow = (TextFlow)t2;
                block = new Block((Pane)t2, textFlow);
            } else {
                block = new Block((Pane)t2, new TextFlow());
            }
            this.root = block;
            this.root.node().getStyleClass().add((Object)"bb-code");
        }

        @Override
        public void startDocument(char[] cArray) {
            this.doc = cArray;
        }

        @Override
        public void endDocument() {
            this.doc = null;
        }

        @Override
        public void startTag(String string, @Nullable Map<String, String> map, int n2, int n3) {
            Tag tag = this.createTag(string, map);
            if (tag == null) {
                return;
            }
            if (!this.openTags.isEmpty()) {
                this.appendTextToCurrentBranch(this.openTags.getFirst(), this.textCursor, n2 - this.textCursor);
            }
            if (!tag.isSelfClose()) {
                this.openTags.addFirst(tag);
                if (tag.isBlock()) {
                    this.createBranch();
                }
            } else {
                this.appendSelfCloseTag(tag);
            }
            this.textCursor = n2 + n3;
        }

        @Override
        public void endTag(String string, int n2, int n3) {
            Tag tag = this.openTags.getFirst();
            this.appendTextToCurrentBranch(tag, this.textCursor, n2 - this.textCursor);
            this.textCursor = n2 + n3;
            this.openTags.removeFirst();
            if (tag.isBlock()) {
                this.openBlocks.removeFirst();
            }
        }

        @Override
        public void characters(int n2, int n3) {
            if (n3 > 0) {
                Text text = new Text(new String(this.doc, n2, n3));
                if (this.root.node() instanceof TextFlow) {
                    this.root.children().add((Node)text);
                } else {
                    this.appendTextToRoot((Node)text);
                }
            }
        }

        @Nullable
        protected Tag createTag(String string, @Nullable Map<String, String> map) {
            Tag.Type type = null;
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            switch (string) {
                case "b": {
                    hashSet.add("text-bold");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "i": {
                    hashSet.add("text-italic");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "u": {
                    hashSet.add("text-underlined");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "s": {
                    hashSet.add("text-strikethrough");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "color": {
                    this.addStyleIfPresent(map, "-fx-fill", "color", hashSet2);
                    type = Tag.Type.TEXT;
                    break;
                }
                case "font": {
                    this.addStyleIfPresent(map, "-fx-font-family", "font", hashSet2);
                    type = Tag.Type.TEXT;
                    break;
                }
                case "style": {
                    this.addStyleIfPresent(map, "style", hashSet2, ";");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "sub": {
                    hashSet.add("sub");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "sup": {
                    hashSet.add("sup");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "heading": {
                    if (map != null && map.containsKey("heading")) {
                        hashSet.add("title-" + this.getParamOrDefault(map, "heading", "3"));
                    }
                    hashSet.add("heading");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "caption": {
                    hashSet.add("text-caption");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "size": {
                    this.addStyleIfPresent(map, "-fx-font-size", "size", hashSet2);
                    type = Tag.Type.TEXT;
                    break;
                }
                case "small": {
                    hashSet.add("text-small");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "url": 
                case "email": {
                    this.addStyleIfPresent(map, "class", hashSet, " ");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "code": {
                    hashSet.add("code");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "span": {
                    this.addStyleIfPresent(map, "span", hashSet, " ");
                    this.addStyleIfPresent(map, "class", hashSet, " ");
                    this.addStyleIfPresent(map, "style", hashSet2, ";");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "label": {
                    this.addStyleIfPresent(map, "label", hashSet, " ");
                    this.addStyleIfPresent(map, "class", hashSet, " ");
                    this.addStyleIfPresent(map, "style", hashSet2, ";");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "abbr": {
                    hashSet.add("abbr");
                    type = Tag.Type.TEXT;
                    break;
                }
                case "ol": 
                case "ul": {
                    this.addStyleIfPresent(map, "class", hashSet, " ");
                    type = Tag.Type.BLOCK;
                    break;
                }
                case "align": 
                case "li": 
                case "left": 
                case "center": 
                case "right": 
                case "indent": {
                    type = Tag.Type.BLOCK;
                    break;
                }
                case "hr": {
                    type = Tag.Type.SELF_CLOSE;
                }
            }
            return type != null ? new Tag(string, type, map, hashSet, hashSet2) : null;
        }

        protected void appendTextToRoot(Node node) {
            TextFlow textFlow;
            if (this.root.isEmpty() || !(this.root.children().get(this.root.size() - 1) instanceof TextFlow)) {
                textFlow = new TextFlow();
                this.root.children().add((Node)textFlow);
            } else {
                textFlow = (TextFlow)this.root.children().get(this.root.size() - 1);
            }
            textFlow.getChildren().add((Object)node);
        }

        protected void appendTextToCurrentBranch(Tag tag, int n2, int n3) {
            if (n3 > 0) {
                Node node = this.createTextNode(tag, new String(this.doc, n2, n3));
                node.getStyleClass().addAll(this.getStyleClass());
                node.setStyle(this.getStyle());
                if (this.openBlocks.isEmpty()) {
                    this.appendTextToRoot(node);
                } else {
                    this.openBlocks.getFirst().addText(node);
                }
            }
        }

        protected Node createTextNode(Tag tag, String string) {
            return switch (tag.name()) {
                case "label", "code" -> new Label(string);
                case "url" -> {
                    Hyperlink var5_5 = new Hyperlink(string);
                    var5_5.setUserData((Object)tag.getParam("url"));
                    var5_5.getStyleClass().add((Object)"url");
                    yield var5_5;
                }
                case "email" -> {
                    Hyperlink var5_6 = new Hyperlink(string);
                    var5_6.setUserData((Object)tag.getParam("email"));
                    var5_6.getStyleClass().add((Object)"email");
                    yield var5_6;
                }
                case "abbr" -> {
                    Label var5_7 = new Label(string);
                    String var6_9 = tag.getParam("abbr");
                    if (var6_9 != null) {
                        var5_7.setTooltip(new Tooltip(var6_9));
                    }
                    yield var5_7;
                }
                default -> {
                    Text var5_8 = new Text(string);
                    var5_8.getStyleClass().add((Object)"text");
                    yield var5_8;
                }
            };
        }

        protected void createBranch() {
            Tag tag = this.openTags.getFirst();
            if (!tag.isBlock()) {
                return;
            }
            int n2 = 10;
            int n3 = 10;
            boolean bl2 = false;
            Block block = !this.openBlocks.isEmpty() ? this.openBlocks.getFirst() : this.root;
            Block block2 = switch (tag.name()) {
                case "ul" -> {
                    GridPane var9_9 = new VBox(10.0);
                    var9_9.setUserData((Object)tag.getParam("ul", "\u2022"));
                    var9_9.getStyleClass().addAll((Object[])new String[]{"ul", "list"});
                    yield new Block((Pane)var9_9, null);
                }
                case "ol" -> {
                    GridPane var9_9 = new GridPane();
                    var9_9.setVgap(10.0);
                    var9_9.setHgap(10.0);
                    var9_9.setUserData((Object)this.getListStartNumber(tag.getParam("ol")));
                    var9_9.getStyleClass().addAll((Object[])new String[]{"ol", "list"});
                    var9_9.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(Double.NEGATIVE_INFINITY, -1.0, Double.NEGATIVE_INFINITY, Priority.NEVER, HPos.LEFT, false), new ColumnConstraints(-1.0, -1.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false)});
                    yield new Block((Pane)var9_9, null);
                }
                case "li" -> {
                    HBox var10_12;
                    Object var11_10;
                    GridPane var9_9 = new TextFlow();
                    if (block.node().getStyleClass().contains((Object)"ol") && (var11_10 = block.node()) instanceof GridPane) {
                        var10_12 = (GridPane)var11_10;
                        bl2 = true;
                        var10_12.addRow(var10_12.getRowCount(), new Node[]{new Label(this.getListItemNumber((GridPane)var10_12)), var9_9});
                        var10_12.getRowConstraints().add((Object)new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false));
                        yield new Block((Pane)var9_9, (TextFlow)var9_9);
                    }
                    if (block.node().getStyleClass().contains((Object)"ul")) {
                        var11_10 = String.valueOf(block.node().getUserData());
                        HBox var12_13 = new HBox(10.0, new Node[]{new Text((String)var11_10), var9_9});
                        var12_13.setAlignment(Pos.BASELINE_LEFT);
                        var12_13.getStyleClass().add((Object)"li");
                        yield new Block((Pane)var12_13, (TextFlow)var9_9);
                    }
                    throw new UnsupportedOperationException("Invalid parent tag: 'ul' or 'ol' required.");
                }
                case "align" -> {
                    GridPane var9_9 = new TextFlow();
                    HBox var10_12 = new HBox(new Node[]{var9_9});
                    var10_12.setAlignment(this.getEnumValue(Pos.class, tag.getParam("align"), Pos.TOP_LEFT));
                    yield new Block((Pane)var10_12, (TextFlow)var9_9);
                }
                case "left" -> {
                    GridPane var9_9 = new TextFlow();
                    var9_9.setTextAlignment(TextAlignment.LEFT);
                    HBox var10_12 = new HBox(new Node[]{var9_9});
                    var10_12.setAlignment(Pos.TOP_LEFT);
                    yield new Block((Pane)var10_12, (TextFlow)var9_9);
                }
                case "center" -> {
                    GridPane var9_9 = new TextFlow();
                    var9_9.setTextAlignment(TextAlignment.CENTER);
                    HBox var10_12 = new HBox(new Node[]{var9_9});
                    var10_12.setAlignment(Pos.TOP_CENTER);
                    yield new Block((Pane)var10_12, (TextFlow)var9_9);
                }
                case "right" -> {
                    GridPane var9_9 = new TextFlow();
                    var9_9.setTextAlignment(TextAlignment.RIGHT);
                    HBox var10_12 = new HBox(new Node[]{var9_9});
                    var10_12.setAlignment(Pos.TOP_RIGHT);
                    yield new Block((Pane)var10_12, (TextFlow)var9_9);
                }
                case "indent" -> {
                    GridPane var9_9 = new TextFlow();
                    HBox var10_12 = new HBox(new Node[]{var9_9});
                    int var11_11 = this.parseIntOrDefault(tag.getParam("indent"), 1);
                    var10_12.setPadding(new Insets(0.0, 0.0, 0.0, (double)(var11_11 * 10)));
                    var10_12.getStyleClass().add((Object)"indent");
                    yield new Block((Pane)var10_12, (TextFlow)var9_9);
                }
                default -> new Block((Pane)new VBox(), null);
            };
            block2.node().getStyleClass().addAll(this.getStyleClass());
            String string = block2.node().getStyle();
            String string2 = this.getStyle();
            block2.node().setStyle((String)(string != null && !string.isEmpty() ? string + ";" + string2 : this.getStyle()));
            if (!bl2) {
                block.children().add((Node)block2.node());
            }
            this.openBlocks.push(block2);
        }

        protected void appendSelfCloseTag(Tag tag) {
            Block block = !this.openBlocks.isEmpty() ? this.openBlocks.getFirst() : this.root;
            HBox hBox = null;
            if ("hr".equals(tag.name())) {
                hBox = new HBox();
                hBox.getStyleClass().add((Object)"hr");
                int n2 = this.parseIntOrDefault(tag.getParam("hr"), 1);
                hBox.setStyle(String.format("-fx-border-width:0 0 %d 0", n2));
            }
            if (hBox != null) {
                block.children().add((Node)hBox);
            }
        }

        protected void addStyleIfPresent(Map<String, String> map, String string, String string2, Collection<String> collection) {
            if (map != null && map.containsKey(string2)) {
                collection.add(string + ":" + map.get(string2));
            }
        }

        protected void addStyleIfPresent(Map<String, String> map, String string, Collection<String> collection, String string2) {
            if (map != null && map.containsKey(string)) {
                Collections.addAll(collection, map.get(string).split(string2));
            }
        }

        protected <E extends Enum<E>> E getEnumValue(Class<E> clazz, @Nullable String string, E e2) {
            if (string == null) {
                return e2;
            }
            try {
                return Enum.valueOf(clazz, string.toUpperCase());
            }
            catch (Exception exception) {
                return e2;
            }
        }

        protected int getListStartNumber(@Nullable String string) {
            int n2;
            block3: {
                n2 = 1;
                if (string == null) {
                    return n2;
                }
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    if (string.length() != 1 || !Character.isLetter(string.charAt(0))) break block3;
                    n2 = 100000 + string.charAt(0);
                }
            }
            return n2;
        }

        protected int parseIntOrDefault(@Nullable String string, int n2) {
            if (string == null) {
                return n2;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return n2;
            }
        }

        protected String getParamOrDefault(Map<String, String> map, String string, String string2) {
            if (map != null) {
                return map.getOrDefault(string, string2);
            }
            return string2;
        }

        protected String getListItemNumber(GridPane gridPane) {
            int n2 = Objects.requireNonNullElse(gridPane.getUserData(), 1);
            return n2 < 100000 ? n2 + gridPane.getRowCount() + "." : (char)(n2 + gridPane.getRowCount() - 100000) + ".";
        }

        protected Set<String> getStyleClass() {
            Iterator<Tag> iterator = this.openTags.descendingIterator();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            while (iterator.hasNext()) {
                Tag tag = iterator.next();
                linkedHashSet.addAll(tag.styleClasses());
            }
            return linkedHashSet;
        }

        protected String getStyle() {
            Iterator<Tag> iterator = this.openTags.descendingIterator();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            while (iterator.hasNext()) {
                Tag tag = iterator.next();
                linkedHashSet.addAll(tag.styles());
            }
            return String.join((CharSequence)";", linkedHashSet);
        }
    }
}

