/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.theme;

import org.jetbrains.annotations.Nullable;

public interface Theme {
    public String getName();

    public String getUserAgentStylesheet();

    @Nullable
    public String getUserAgentStylesheetBSS();

    public boolean isDarkMode();

    public static Theme of(final String string, final String string2, final boolean bl2) {
        if (string == null) {
            throw new NullPointerException("Name cannot be null!");
        }
        if (string2 == null) {
            throw new NullPointerException("User agent stylesheet cannot be null!");
        }
        return new Theme(){

            @Override
            public String getName() {
                return string;
            }

            @Override
            public String getUserAgentStylesheet() {
                return string2;
            }

            @Override
            @Nullable
            public String getUserAgentStylesheetBSS() {
                return null;
            }

            @Override
            public boolean isDarkMode() {
                return bl2;
            }
        };
    }

    default public boolean isDefault() {
        return "MODENA".equals(this.getUserAgentStylesheet()) || "CASPIAN".equals(this.getUserAgentStylesheet());
    }
}

