/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.layout;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.jetbrains.annotations.Nullable;

public class DeckPane
extends AnchorPane {
    protected static final Comparator<Node> Z_COMPARATOR = Comparator.comparingDouble(Node::getViewOrder);
    protected static final int Z_ANIMATED_IN = -20;
    protected static final int Z_ANIMATED_OUT = -15;
    protected static final int Z_DECK_TOP = -10;
    protected static final int Z_DEFAULT = 0;
    protected final ObjectProperty<Duration> animationDuration = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.seconds((double)1.0));
    protected final ReadOnlyBooleanWrapper animationActive = new ReadOnlyBooleanWrapper((Object)this, "animationActive");
    protected final ObjectProperty<Consumer<Node>> beforeShowCallback = new SimpleObjectProperty((Object)this, "beforeShowCallback");
    protected final ObjectProperty<Consumer<Node>> afterHideCallback = new SimpleObjectProperty((Object)this, "afterHideCallback");

    public DeckPane() {
        this.getChildren().addListener(change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(node -> node.setViewOrder(0.0));
            }
        });
    }

    public DeckPane(Node ... nodeArray) {
        this();
        this.getChildren().addAll((Object[])nodeArray);
    }

    @Nullable
    public Node getTopNode() {
        int n2 = this.getChildren().size();
        if (n2 == 0) {
            return null;
        }
        return this.getChildren().stream().reduce((node, node2) -> Z_COMPARATOR.compare((Node)node, (Node)node2) >= 0 ? node2 : node).orElse((Node)this.getChildren().get(n2 - 1));
    }

    public void setTopNode(Node node) {
        if (!this.getChildren().contains((Object)node)) {
            return;
        }
        Node node2 = this.getTopNode();
        if (node2 == null || node2 == node) {
            return;
        }
        this.setViewOrder(node2, 0);
        this.setViewOrder(node, -10);
    }

    public void resetTopNode() {
        Node node = this.getTopNode();
        if (node != null) {
            this.setViewOrder(node, 0);
        }
    }

    public void addChildren(Insets insets, Node ... nodeArray) {
        for (Node node : nodeArray) {
            AnchorPane.setTopAnchor((Node)node, (Double)insets.getTop());
            AnchorPane.setRightAnchor((Node)node, (Double)insets.getRight());
            AnchorPane.setBottomAnchor((Node)node, (Double)insets.getBottom());
            AnchorPane.setLeftAnchor((Node)node, (Double)insets.getLeft());
        }
        this.getChildren().addAll((Object[])nodeArray);
    }

    public void swipeUp(Node node) {
        Node node2 = this.getTopNode();
        if (!this.prepareAndCheck(node2, node)) {
            return;
        }
        Objects.requireNonNull(node2);
        this.setViewOrder(node2, -15);
        this.setViewOrder(node, -20);
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{this.moveYUpFromTopBorderToOffCanvas(node2), this.moveYUpFromBottomBorderToTopBorder(node)});
        parallelTransition.setOnFinished(actionEvent -> this.onTransitionFinished(node2, node));
        this.setAnimationActive(true);
        parallelTransition.play();
    }

    public void swipeDown(Node node) {
        Node node2 = this.getTopNode();
        if (!this.prepareAndCheck(node2, node)) {
            return;
        }
        Objects.requireNonNull(node2);
        this.setViewOrder(node2, -15);
        this.setViewOrder(node, -20);
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{this.moveYDownFromTopBorderToBottomBorder(node2), this.moveYDownFromOffCanvasToTopBorder(node)});
        parallelTransition.setOnFinished(actionEvent -> this.onTransitionFinished(node2, node));
        this.setAnimationActive(true);
        parallelTransition.play();
    }

    public void swipeLeft(Node node) {
        Node node2 = this.getTopNode();
        if (!this.prepareAndCheck(node2, node)) {
            return;
        }
        Objects.requireNonNull(node2);
        this.setViewOrder(node2, -15);
        this.setViewOrder(node, -20);
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{this.moveXLeftFromLeftBorderToOffCanvas(node2), this.moveXLeftFromRightBorderToLeftBorder(node)});
        parallelTransition.setOnFinished(actionEvent -> this.onTransitionFinished(node2, node));
        this.setAnimationActive(true);
        parallelTransition.play();
    }

    public void swipeRight(Node node) {
        Node node2 = this.getTopNode();
        if (!this.prepareAndCheck(node2, node)) {
            return;
        }
        Objects.requireNonNull(node2);
        this.setViewOrder(node2, -15);
        this.setViewOrder(node, -20);
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{this.moveXRightFromLeftBorderToRightBorder(node2), this.moveXRightFromOffCanvasToLeftBorder(node)});
        parallelTransition.setOnFinished(actionEvent -> this.onTransitionFinished(node2, node));
        this.setAnimationActive(true);
        parallelTransition.play();
    }

    public void slideUp(Node node) {
        Node node2 = this.getTopNode();
        if (!this.prepareAndCheck(node2, node)) {
            return;
        }
        Objects.requireNonNull(node2);
        this.setViewOrder(node2, -15);
        this.setViewOrder(node, -20);
        Timeline timeline = this.moveYUpFromBottomBorderToTopBorder(node);
        timeline.setOnFinished(actionEvent -> this.onTransitionFinished(node2, node));
        this.setAnimationActive(true);
        timeline.play();
    }

    public void slideDown(Node node) {
        Node node2 = this.getTopNode();
        if (!this.prepareAndCheck(node2, node)) {
            return;
        }
        Objects.requireNonNull(node2);
        this.setViewOrder(node2, -15);
        this.setViewOrder(node, -20);
        Timeline timeline = this.moveYDownFromOffCanvasToTopBorder(node);
        timeline.setOnFinished(actionEvent -> this.onTransitionFinished(node2, node));
        this.setAnimationActive(true);
        timeline.play();
    }

    public void slideLeft(Node node) {
        Node node2 = this.getTopNode();
        if (!this.prepareAndCheck(node2, node)) {
            return;
        }
        Objects.requireNonNull(node2);
        this.setViewOrder(node2, -15);
        this.setViewOrder(node, -20);
        Timeline timeline = this.moveXLeftFromRightBorderToLeftBorder(node);
        timeline.setOnFinished(actionEvent -> this.onTransitionFinished(node2, node));
        this.setAnimationActive(true);
        timeline.play();
    }

    public void slideRight(Node node) {
        Node node2 = this.getTopNode();
        if (!this.prepareAndCheck(node2, node)) {
            return;
        }
        Objects.requireNonNull(node2);
        this.setViewOrder(node2, -15);
        this.setViewOrder(node, -20);
        Timeline timeline = this.moveXRightFromOffCanvasToLeftBorder(node);
        timeline.setOnFinished(actionEvent -> this.onTransitionFinished(node2, node));
        this.setAnimationActive(true);
        timeline.play();
    }

    public ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDuration;
    }

    public Duration getAnimationDuration() {
        return (Duration)this.animationDuration.get();
    }

    public void setAnimationDuration(@Nullable Duration duration) {
        this.animationDuration.set((Object)Objects.requireNonNullElse(duration, Duration.ZERO));
    }

    public ReadOnlyBooleanProperty animationActiveProperty() {
        return this.animationActive.getReadOnlyProperty();
    }

    public boolean isAnimationActive() {
        return this.animationActive.get();
    }

    protected void setAnimationActive(boolean bl2) {
        this.animationActive.set(bl2);
    }

    public ObjectProperty<Consumer<Node>> beforeShowCallbackProperty() {
        return this.beforeShowCallback;
    }

    @Nullable
    public Consumer<Node> getBeforeShowCallback() {
        return (Consumer)this.beforeShowCallback.get();
    }

    public void setBeforeShowCallback(@Nullable Consumer<Node> consumer) {
        this.beforeShowCallback.set(consumer);
    }

    protected void runBeforeShowCallback(Node node) {
        if (this.getBeforeShowCallback() != null) {
            this.getBeforeShowCallback().accept(node);
        }
    }

    public ObjectProperty<Consumer<Node>> afterHideCallbackProperty() {
        return this.afterHideCallback;
    }

    @Nullable
    public Consumer<Node> getAfterHideCallback() {
        return (Consumer)this.afterHideCallback.get();
    }

    public void setAfterHideCallback(@Nullable Consumer<Node> consumer) {
        this.afterHideCallback.set(consumer);
    }

    protected void runAfterHideCallback(Node node) {
        if (this.getAfterHideCallback() != null) {
            this.getAfterHideCallback().accept(node);
        }
    }

    protected boolean prepareAndCheck(@Nullable Node node, @Nullable Node node2) {
        if (node == null || node2 == null || node2 == node || this.isAnimationActive()) {
            return false;
        }
        if (!this.getChildren().contains((Object)node2)) {
            this.getChildren().add((Object)node2);
        }
        this.runBeforeShowCallback(node2);
        return true;
    }

    protected void onTransitionFinished(Node node, Node node2) {
        this.resetNode(node);
        this.resetNode(node2);
        this.setViewOrder(node, 0);
        this.setViewOrder(node2, -10);
        this.runAfterHideCallback(node);
        this.setAnimationActive(false);
    }

    protected Timeline moveYUpFromTopBorderToOffCanvas(Node node) {
        Rectangle rectangle = new Rectangle();
        rectangle.setWidth(this.getWidth());
        node.setClip((Node)rectangle);
        rectangle.setHeight(this.getHeight());
        rectangle.translateYProperty().set(0.0);
        node.translateYProperty().set(0.0);
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)rectangle.heightProperty(), (Object)0), new KeyValue((WritableValue)rectangle.translateYProperty(), (Object)this.getHeight()), new KeyValue((WritableValue)node.translateYProperty(), (Object)(-this.getHeight()))}));
        return timeline;
    }

    protected Timeline moveYUpFromBottomBorderToTopBorder(Node node) {
        Rectangle rectangle = new Rectangle();
        rectangle.setWidth(this.getWidth());
        node.setClip((Node)rectangle);
        rectangle.setHeight(0.0);
        node.translateYProperty().set(this.getHeight());
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)rectangle.heightProperty(), (Object)this.getHeight()), new KeyValue((WritableValue)node.translateYProperty(), (Object)0)}));
        return timeline;
    }

    protected Timeline moveYDownFromTopBorderToBottomBorder(Node node) {
        Rectangle rectangle = new Rectangle();
        rectangle.setWidth(this.getWidth());
        node.setClip((Node)rectangle);
        rectangle.setHeight(this.getHeight());
        node.translateYProperty().set(0.0);
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)rectangle.heightProperty(), (Object)0), new KeyValue((WritableValue)node.translateYProperty(), (Object)this.getHeight())}));
        return timeline;
    }

    protected Timeline moveYDownFromOffCanvasToTopBorder(Node node) {
        Rectangle rectangle = new Rectangle();
        rectangle.setWidth(this.getWidth());
        node.setClip((Node)rectangle);
        rectangle.setHeight(0.0);
        rectangle.translateYProperty().set(this.getHeight());
        node.translateYProperty().set(-this.getHeight());
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)rectangle.heightProperty(), (Object)this.getHeight()), new KeyValue((WritableValue)rectangle.translateYProperty(), (Object)0), new KeyValue((WritableValue)node.translateYProperty(), (Object)0)}));
        return timeline;
    }

    protected Timeline moveXLeftFromLeftBorderToOffCanvas(Node node) {
        Rectangle rectangle = new Rectangle();
        rectangle.setHeight(this.getHeight());
        node.setClip((Node)rectangle);
        rectangle.setWidth(this.getWidth());
        rectangle.translateXProperty().set(0.0);
        node.translateXProperty().set(0.0);
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)rectangle.widthProperty(), (Object)0), new KeyValue((WritableValue)rectangle.translateXProperty(), (Object)this.getWidth()), new KeyValue((WritableValue)node.translateXProperty(), (Object)(-this.getWidth()))}));
        return timeline;
    }

    protected Timeline moveXLeftFromRightBorderToLeftBorder(Node node) {
        Rectangle rectangle = new Rectangle();
        rectangle.setHeight(this.getHeight());
        node.setClip((Node)rectangle);
        rectangle.setWidth(0.0);
        node.translateXProperty().set(this.getWidth());
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)rectangle.widthProperty(), (Object)this.getWidth()), new KeyValue((WritableValue)node.translateXProperty(), (Object)0)}));
        return timeline;
    }

    protected Timeline moveXRightFromLeftBorderToRightBorder(Node node) {
        Rectangle rectangle = new Rectangle();
        rectangle.setHeight(this.getHeight());
        node.setClip((Node)rectangle);
        rectangle.setWidth(this.getWidth());
        node.translateXProperty().set(0.0);
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)rectangle.widthProperty(), (Object)0), new KeyValue((WritableValue)node.translateXProperty(), (Object)this.getWidth())}));
        return timeline;
    }

    protected Timeline moveXRightFromOffCanvasToLeftBorder(Node node) {
        Rectangle rectangle = new Rectangle();
        rectangle.setHeight(this.getHeight());
        node.setClip((Node)rectangle);
        rectangle.setWidth(0.0);
        rectangle.translateXProperty().set(this.getWidth());
        node.translateXProperty().set(-this.getWidth());
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)rectangle.widthProperty(), (Object)this.getWidth()), new KeyValue((WritableValue)rectangle.translateXProperty(), (Object)0), new KeyValue((WritableValue)node.translateXProperty(), (Object)0)}));
        return timeline;
    }

    protected void resetNode(Node node) {
        node.setClip(null);
        node.setTranslateX(0.0);
        node.setTranslateY(0.0);
    }

    protected void setViewOrder(Node node, int n2) {
        if (n2 != 0 && n2 != -10 && n2 != -20 && n2 != -15) {
            throw new IllegalArgumentException("Unknown view order value: " + n2);
        }
        node.setViewOrder((double)n2);
    }
}

