/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.ToggleSwitch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.TranslateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class ToggleSwitchSkin
extends SkinBase<ToggleSwitch> {
    protected static final Duration DEFAULT_ANIMATION_TIME = Duration.millis((double)200.0);
    protected final StackPane thumb = new StackPane();
    protected final StackPane thumbArea;
    protected final Label label;
    protected final StackPane labelContainer;
    protected final TranslateTransition transition;
    private DoubleProperty thumbMoveAnimationTime = null;

    public ToggleSwitchSkin(ToggleSwitch toggleSwitch) {
        super((Control)toggleSwitch);
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumbArea = new StackPane();
        this.thumbArea.getStyleClass().setAll((Object[])new String[]{"thumb-area"});
        this.label = new Label();
        this.labelContainer = new StackPane();
        this.labelContainer.getStyleClass().add((Object)"label-container");
        this.transition = new TranslateTransition(DEFAULT_ANIMATION_TIME, (Node)this.thumb);
        this.transition.setFromX(0.0);
        this.label.textProperty().bind((ObservableValue)toggleSwitch.textProperty());
        StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER_LEFT);
        this.labelContainer.getChildren().addAll((Object[])new Node[]{this.label});
        this.getChildren().addAll((Object[])new Node[]{this.labelContainer, this.thumbArea, this.thumb});
        this.thumbArea.setOnMouseReleased(mouseEvent -> this.mousePressedOnToggleSwitch(toggleSwitch));
        this.thumb.setOnMouseReleased(mouseEvent -> this.mousePressedOnToggleSwitch(toggleSwitch));
        toggleSwitch.selectedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue() != bl2.booleanValue()) {
                this.selectedStateChanged();
            }
        });
    }

    protected void selectedStateChanged() {
        this.transition.stop();
        if (((ToggleSwitch)this.getSkinnable()).isSelected()) {
            this.transition.setRate(1.0);
            this.transition.jumpTo(Duration.ZERO);
        } else {
            this.transition.setRate(-1.0);
            this.transition.jumpTo(this.transition.getDuration());
        }
        this.transition.play();
    }

    private void mousePressedOnToggleSwitch(ToggleSwitch toggleSwitch) {
        toggleSwitch.setSelected(!toggleSwitch.isSelected());
    }

    private DoubleProperty thumbMoveAnimationTimeProperty() {
        if (this.thumbMoveAnimationTime == null) {
            this.thumbMoveAnimationTime = new StyleableDoubleProperty(DEFAULT_ANIMATION_TIME.toMillis()){

                public Object getBean() {
                    return ToggleSwitchSkin.this;
                }

                public String getName() {
                    return "thumbMoveAnimationTime";
                }

                protected void invalidated() {
                    ToggleSwitchSkin.this.transition.setDuration(Duration.millis((double)this.getValue()));
                }

                public CssMetaData<ToggleSwitch, Number> getCssMetaData() {
                    return StyleableProperties.THUMB_MOVE_ANIMATION_TIME;
                }
            };
        }
        return this.thumbMoveAnimationTime;
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        ToggleSwitch toggleSwitch = (ToggleSwitch)this.getSkinnable();
        double d6 = this.snapSizeX(this.thumb.prefWidth(-1.0));
        double d7 = this.snapSizeX(this.thumb.prefHeight(-1.0));
        this.thumb.resize(d6, d7);
        double d8 = this.snapSizeX(this.thumbArea.prefWidth(-1.0));
        double d9 = this.snapSizeX(this.thumbArea.prefHeight(-1.0));
        double d10 = this.snapPositionX(d3 + d5 / 2.0 - d9 / 2.0);
        double d11 = this.label.getText() != null && !this.label.getText().isEmpty() ? d4 - d8 : 0.0;
        double d12 = toggleSwitch.getLabelPosition() == HorizontalDirection.RIGHT ? d8 : 0.0;
        double d13 = toggleSwitch.getLabelPosition() == HorizontalDirection.RIGHT ? 0.0 : d11;
        this.thumbArea.resize(d8, d9);
        this.thumbArea.setLayoutX(d13);
        this.thumbArea.setLayoutY(d10);
        this.labelContainer.resize(d11, d9);
        this.labelContainer.setLayoutX(d12);
        this.labelContainer.setLayoutY(d10);
        this.thumb.setLayoutX(this.thumbArea.getLayoutX());
        this.thumb.setLayoutY(d10 + (d9 - d7) / 2.0);
        double d14 = d8 - d6;
        this.transition.setToX(d14);
        if (this.transition.getStatus() == Animation.Status.RUNNING) {
            Duration duration = this.transition.getCurrentTime();
            this.transition.stop();
            this.transition.playFrom(duration);
        } else {
            this.thumb.setTranslateX(toggleSwitch.isSelected() ? d14 : 0.0);
        }
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return d6 + this.label.prefWidth(-1.0) + this.thumbArea.prefWidth(-1.0) + d4;
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return d3 + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + d5;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return d6 + this.label.prefWidth(-1.0) + 1.0 + this.thumbArea.prefWidth(-1.0) + d4;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.computeMinHeight(d2, d3, d4, d5, d6);
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((ToggleSwitch)this.getSkinnable()).prefWidth(d2);
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((ToggleSwitch)this.getSkinnable()).prefHeight(d2);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    static class StyleableProperties {
        private static final CssMetaData<ToggleSwitch, Number> THUMB_MOVE_ANIMATION_TIME = new CssMetaData<ToggleSwitch, Number>("-fx-thumb-move-animation-time", SizeConverter.getInstance(), (Number)DEFAULT_ANIMATION_TIME.toMillis()){

            public boolean isSettable(ToggleSwitch toggleSwitch) {
                ToggleSwitchSkin toggleSwitchSkin = (ToggleSwitchSkin)toggleSwitch.getSkin();
                return toggleSwitchSkin.thumbMoveAnimationTime == null || !toggleSwitchSkin.thumbMoveAnimationTime.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(ToggleSwitch toggleSwitch) {
                ToggleSwitchSkin toggleSwitchSkin = (ToggleSwitchSkin)toggleSwitch.getSkin();
                return (StyleableProperty)toggleSwitchSkin.thumbMoveAnimationTimeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<ToggleSwitch, Number>> arrayList = new ArrayList<CssMetaData<ToggleSwitch, Number>>(SkinBase.getClassCssMetaData());
            arrayList.add(THUMB_MOVE_ANIMATION_TIME);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

