/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.ModalPane;
import atlantafx.base.util.Animations;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.jetbrains.annotations.Nullable;

public class ModalPaneSkin
extends SkinBase<ModalPane> {
    protected ModalPane control;
    protected final StackPane root;
    protected final ScrollPane scrollPane;
    protected final StackPane contentWrapper;
    protected final EventHandler<KeyEvent> keyHandler = this.createKeyHandler();
    protected final EventHandler<MouseEvent> mouseHandler = this.createMouseHandler();
    protected final ChangeListener<Animation.Status> animationInListener = this.createAnimationInListener();
    protected final ChangeListener<Animation.Status> animationOutListener = this.createAnimationOutListener();
    @Nullable
    protected List<ScrollBar> scrollbars;
    @Nullable
    protected Animation inTransition;
    @Nullable
    protected Animation outTransition;

    protected ModalPaneSkin(ModalPane modalPane) {
        super((Control)modalPane);
        this.root = new StackPane();
        this.contentWrapper = new StackPane();
        this.contentWrapper.getStyleClass().add((Object)"scrollable-content");
        this.contentWrapper.setAlignment(Pos.CENTER);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setMaxHeight(20000.0);
        this.scrollPane.setContent((Node)this.contentWrapper);
        this.getChildren().add((Object)this.scrollPane);
        modalPane.getStyleClass().add((Object)"modal-pane");
        this.doHide();
        this.registerListeners();
    }

    protected void registerListeners() {
        this.registerChangeListener((ObservableValue)((ModalPane)this.getSkinnable()).contentProperty(), observableValue -> {
            @Nullable Node node = ((ModalPane)this.getSkinnable()).getContent();
            if (node != null) {
                this.contentWrapper.getChildren().setAll((Object[])new Node[]{node});
            } else {
                this.contentWrapper.getChildren().clear();
            }
            this.contentWrapper.layout();
        });
        this.registerChangeListener((ObservableValue)((ModalPane)this.getSkinnable()).displayProperty(), observableValue -> {
            boolean bl2 = ((ModalPane)this.getSkinnable()).isDisplay();
            if (bl2) {
                this.show();
            } else {
                this.hide();
            }
        });
        this.registerChangeListener((ObservableValue)((ModalPane)this.getSkinnable()).inTransitionFactoryProperty(), observableValue -> {
            if (this.inTransition != null) {
                this.inTransition.statusProperty().removeListener(this.animationInListener);
            }
            this.inTransition = null;
        });
        this.registerChangeListener((ObservableValue)((ModalPane)this.getSkinnable()).outTransitionFactoryProperty(), observableValue -> {
            if (this.outTransition != null) {
                this.outTransition.statusProperty().removeListener(this.animationOutListener);
            }
            this.outTransition = null;
        });
        this.contentWrapper.paddingProperty().bind((ObservableValue)((ModalPane)this.getSkinnable()).paddingProperty());
        this.contentWrapper.alignmentProperty().bind(((ModalPane)this.getSkinnable()).alignmentProperty());
        this.scrollPane.addEventHandler(KeyEvent.KEY_PRESSED, this.keyHandler);
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
    }

    public void dispose() {
        super.dispose();
        this.unregisterChangeListeners((ObservableValue)((ModalPane)this.getSkinnable()).contentProperty());
        this.unregisterChangeListeners((ObservableValue)((ModalPane)this.getSkinnable()).displayProperty());
        this.unregisterChangeListeners((ObservableValue)((ModalPane)this.getSkinnable()).inTransitionFactoryProperty());
        this.unregisterChangeListeners((ObservableValue)((ModalPane)this.getSkinnable()).outTransitionFactoryProperty());
        this.contentWrapper.paddingProperty().unbind();
        this.contentWrapper.alignmentProperty().unbind();
        this.scrollPane.removeEventFilter(KeyEvent.KEY_PRESSED, this.keyHandler);
        this.scrollPane.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
    }

    protected boolean isClickInArea(MouseEvent mouseEvent, Node node) {
        return mouseEvent.getX() >= node.getLayoutX() & mouseEvent.getX() <= node.getLayoutX() + node.getLayoutBounds().getWidth() && mouseEvent.getY() >= node.getLayoutY() & mouseEvent.getY() <= node.getLayoutY() + node.getLayoutBounds().getHeight();
    }

    protected EventHandler<KeyEvent> createKeyHandler() {
        return keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                if (((ModalPane)this.getSkinnable()).getPersistent()) {
                    this.createCloseBlockedAnimation().playFromStart();
                } else {
                    this.hideAndConsume(keyEvent);
                }
            }
        };
    }

    protected EventHandler<MouseEvent> createMouseHandler() {
        return mouseEvent -> {
            boolean bl2;
            @Nullable Node node2 = ((ModalPane)this.getSkinnable()).getContent();
            if (mouseEvent.getButton() != MouseButton.PRIMARY) {
                return;
            }
            if (node2 == null) {
                this.hideAndConsume(mouseEvent);
                return;
            }
            if (this.isClickInArea((MouseEvent)mouseEvent, node2)) {
                return;
            }
            if (this.scrollbars == null || this.scrollbars.isEmpty()) {
                this.scrollbars = this.scrollPane.lookupAll(".scroll-bar").stream().filter(node -> node instanceof ScrollBar).map(node -> (ScrollBar)node).toList();
            }
            if (!(bl2 = this.scrollbars.stream().anyMatch(scrollBar -> this.isClickInArea((MouseEvent)mouseEvent, (Node)scrollBar)))) {
                if (((ModalPane)this.getSkinnable()).getPersistent()) {
                    this.createCloseBlockedAnimation().playFromStart();
                } else {
                    this.hideAndConsume(mouseEvent);
                }
            }
        };
    }

    protected ChangeListener<Animation.Status> createAnimationInListener() {
        return (observableValue, status, status2) -> {
            if (status2 == Animation.Status.RUNNING) {
                this.doShow();
            }
        };
    }

    protected ChangeListener<Animation.Status> createAnimationOutListener() {
        return (observableValue, status, status2) -> {
            if (status2 == Animation.Status.STOPPED) {
                this.doHide();
            }
        };
    }

    protected Timeline createCloseBlockedAnimation() {
        return Animations.zoomOut(((ModalPane)this.getSkinnable()).getContent(), Duration.millis((double)100.0), 0.98);
    }

    protected void show() {
        if (((ModalPane)this.getSkinnable()).getViewOrder() <= (double)((ModalPane)this.getSkinnable()).getTopViewOrder()) {
            return;
        }
        @Nullable Node node = ((ModalPane)this.getSkinnable()).getContent();
        if (node == null) {
            this.doShow();
            return;
        }
        if (this.inTransition == null && ((ModalPane)this.getSkinnable()).getInTransitionFactory() != null) {
            this.inTransition = ((ModalPane)this.getSkinnable()).getInTransitionFactory().apply(node);
            this.inTransition.statusProperty().addListener(this.animationInListener);
        }
        if (this.inTransition != null) {
            this.inTransition.playFromStart();
        } else {
            this.doShow();
        }
    }

    protected void hide() {
        if (((ModalPane)this.getSkinnable()).getViewOrder() >= 10.0) {
            return;
        }
        @Nullable Node node = ((ModalPane)this.getSkinnable()).getContent();
        if (node == null) {
            this.doHide();
            return;
        }
        if (this.outTransition == null && ((ModalPane)this.getSkinnable()).getOutTransitionFactory() != null) {
            this.outTransition = ((ModalPane)this.getSkinnable()).getOutTransitionFactory().apply(node);
            this.outTransition.statusProperty().addListener(this.animationOutListener);
        }
        if (this.outTransition != null) {
            this.outTransition.playFromStart();
        } else {
            this.doHide();
        }
    }

    protected void hideAndConsume(Event event) {
        this.hide();
        event.consume();
    }

    protected void doShow() {
        ((ModalPane)this.getSkinnable()).setDisplay(true);
        ((ModalPane)this.getSkinnable()).setOpacity(1.0);
        ((ModalPane)this.getSkinnable()).setViewOrder(((ModalPane)this.getSkinnable()).getTopViewOrder());
    }

    protected void doHide() {
        ((ModalPane)this.getSkinnable()).setOpacity(0.0);
        ((ModalPane)this.getSkinnable()).setViewOrder(10.0);
        ((ModalPane)this.getSkinnable()).setDisplay(false);
    }
}

