/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.CustomTextField;
import atlantafx.base.util.MaskChar;
import atlantafx.base.util.MaskTextFormatter;
import java.util.List;
import java.util.Objects;
import javafx.beans.NamedArg;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TextField;
import org.jetbrains.annotations.Nullable;

public class MaskTextField
extends CustomTextField {
    protected final StringProperty mask = new SimpleStringProperty((Object)this, "mask");
    protected final ReadOnlyObjectWrapper<MaskTextFormatter> formatter = new ReadOnlyObjectWrapper((Object)this, "formatter");

    public MaskTextField() {
        super("");
        this.init();
    }

    public MaskTextField(@NamedArg(value="mask") String string) {
        this("", string);
    }

    private MaskTextField(@NamedArg(value="text") String string, @NamedArg(value="mask") String string2) {
        super(Objects.requireNonNullElse(string, ""));
        this.formatter.set((Object)MaskTextFormatter.create((TextField)this, string2));
        this.setMask(string2);
        this.init();
    }

    public MaskTextField(String string, List<MaskChar> list) {
        super(Objects.requireNonNullElse(string, ""));
        this.formatter.set((Object)MaskTextFormatter.create((TextField)this, list));
        this.setMask(null);
        this.init();
    }

    protected void init() {
        this.mask.addListener((observableValue, string, string2) -> this.formatter.set(string2 != null ? MaskTextFormatter.create((TextField)this, string2) : null));
    }

    public StringProperty maskProperty() {
        return this.mask;
    }

    @Nullable
    public String getMask() {
        return (String)this.mask.get();
    }

    public void setMask(@Nullable String string) {
        this.mask.set((Object)string);
    }
}

