/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Breadcrumbs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TreeItem;

public class BreadcrumbsSkin<T>
extends SkinBase<Breadcrumbs<T>> {
    protected static final PseudoClass FIRST = PseudoClass.getPseudoClass((String)"first");
    protected static final PseudoClass LAST = PseudoClass.getPseudoClass((String)"last");
    protected final EventHandler<TreeItem.TreeModificationEvent<Object>> treeChildrenModifiedHandler = treeModificationEvent -> this.updateBreadCrumbs();

    public BreadcrumbsSkin(Breadcrumbs<T> breadcrumbs) {
        super(breadcrumbs);
        breadcrumbs.selectedCrumbProperty().addListener((observableValue, breadCrumbItem, breadCrumbItem2) -> this.updateSelectedPath((Breadcrumbs.BreadCrumbItem<T>)((Object)breadCrumbItem), (Breadcrumbs.BreadCrumbItem<T>)((Object)breadCrumbItem2)));
        this.updateSelectedPath((Breadcrumbs.BreadCrumbItem)((Object)((Breadcrumbs)this.getSkinnable()).selectedCrumbProperty().get()), null);
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = ((Breadcrumbs)this.getSkinnable()).getHeight();
        double d7 = d2;
        for (int i2 = 0; i2 < this.getChildren().size(); ++i2) {
            Node node = (Node)this.getChildren().get(i2);
            double d8 = this.snapSizeX(node.prefWidth(d5));
            double d9 = this.snapSizeY(node.prefHeight(-1.0));
            double d10 = d9 < d6 ? (d6 - d9) / 2.0 : d3;
            node.resizeRelocate(d7, d10, d8, d9);
            d7 += d8;
        }
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        for (Node node : this.getChildren()) {
            if (!node.isManaged()) continue;
            d7 += this.snapSizeX(node.prefWidth(d2));
        }
        return d7 + d4 + d6;
    }

    protected void updateSelectedPath(Breadcrumbs.BreadCrumbItem<T> breadCrumbItem, Breadcrumbs.BreadCrumbItem<T> breadCrumbItem2) {
        if (breadCrumbItem != null) {
            breadCrumbItem.removeEventHandler(Breadcrumbs.BreadCrumbItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        if (breadCrumbItem2 != null) {
            breadCrumbItem2.addEventHandler(Breadcrumbs.BreadCrumbItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        this.updateBreadCrumbs();
    }

    protected void updateBreadCrumbs() {
        this.getChildren().clear();
        Breadcrumbs.BreadCrumbItem breadCrumbItem = ((Breadcrumbs)this.getSkinnable()).getSelectedCrumb();
        if (breadCrumbItem != null) {
            Node node = this.createDivider(null);
            if (node != null) {
                node.pseudoClassStateChanged(FIRST, true);
                node.pseudoClassStateChanged(LAST, false);
                this.getChildren().add((Object)node);
            }
            List list = this.constructFlatPath(breadCrumbItem);
            for (Breadcrumbs.BreadCrumbItem breadCrumbItem2 : list) {
                ButtonBase buttonBase = this.createCrumb(breadCrumbItem2);
                buttonBase.pseudoClassStateChanged(FIRST, breadCrumbItem2.isFirst());
                buttonBase.pseudoClassStateChanged(LAST, breadCrumbItem2.isLast());
                this.getChildren().add((Object)buttonBase);
                node = this.createDivider(breadCrumbItem2);
                if (node == null) continue;
                if (breadCrumbItem2.isLast()) {
                    node.pseudoClassStateChanged(FIRST, false);
                    node.pseudoClassStateChanged(LAST, true);
                }
                this.getChildren().add((Object)node);
            }
        }
    }

    protected List<Breadcrumbs.BreadCrumbItem<T>> constructFlatPath(Breadcrumbs.BreadCrumbItem<T> breadCrumbItem) {
        ArrayList<Breadcrumbs.BreadCrumbItem<T>> arrayList = new ArrayList<Breadcrumbs.BreadCrumbItem<T>>();
        Breadcrumbs.BreadCrumbItem breadCrumbItem2 = breadCrumbItem;
        do {
            arrayList.add(breadCrumbItem2);
            breadCrumbItem2.setFirst(false);
            breadCrumbItem2.setLast(false);
        } while ((breadCrumbItem2 = (Breadcrumbs.BreadCrumbItem)breadCrumbItem2.getParent()) != null);
        Collections.reverse(arrayList);
        if (arrayList.size() > 0) {
            ((Breadcrumbs.BreadCrumbItem)((Object)arrayList.get(0))).setFirst(true);
        }
        if (arrayList.size() > 1) {
            ((Breadcrumbs.BreadCrumbItem)((Object)arrayList.get(arrayList.size() - 1))).setLast(true);
        }
        return arrayList;
    }

    protected ButtonBase createCrumb(Breadcrumbs.BreadCrumbItem<T> breadCrumbItem) {
        ButtonBase buttonBase = (ButtonBase)((Breadcrumbs)this.getSkinnable()).getCrumbFactory().call(breadCrumbItem);
        buttonBase.setMnemonicParsing(false);
        if (!buttonBase.getStyleClass().contains((Object)"crumb")) {
            buttonBase.getStyleClass().add((Object)"crumb");
        }
        buttonBase.setOnAction(actionEvent -> this.onBreadCrumbAction(breadCrumbItem));
        return buttonBase;
    }

    protected Node createDivider(Breadcrumbs.BreadCrumbItem<T> breadCrumbItem) {
        Node node = (Node)((Breadcrumbs)this.getSkinnable()).getDividerFactory().call(breadCrumbItem);
        if (node == null) {
            return null;
        }
        if (!node.getStyleClass().contains((Object)"divider")) {
            node.getStyleClass().add((Object)"divider");
        }
        return node;
    }

    protected void onBreadCrumbAction(Breadcrumbs.BreadCrumbItem<T> breadCrumbItem) {
        Breadcrumbs breadcrumbs = (Breadcrumbs)this.getSkinnable();
        Event.fireEvent((EventTarget)breadcrumbs, new Breadcrumbs.BreadCrumbActionEvent<T>(breadCrumbItem));
        if (breadcrumbs.isAutoNavigationEnabled()) {
            breadcrumbs.setSelectedCrumb(breadCrumbItem);
        }
    }
}

