/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.pixels.CompressorStream;
import ar.com.hjg.pngj.pixels.CompressorStreamDeflater;
import java.io.OutputStream;

public abstract class PixelsWriter {
    protected final ImageInfo imgInfo;
    protected final int buflen;
    protected final int bytesPixel;
    protected final int bytesRow;
    private CompressorStream compressorStream;
    protected int deflaterCompLevel = 6;
    protected int deflaterStrategy = 0;
    protected boolean initdone = false;
    protected FilterType filterType;
    private int[] filtersUsed = new int[5];
    private OutputStream os;
    protected int currentRow;

    public PixelsWriter(ImageInfo imageInfo) {
        this.imgInfo = imageInfo;
        this.bytesRow = imageInfo.bytesPerRow;
        this.buflen = this.bytesRow + 1;
        this.bytesPixel = imageInfo.bytesPixel;
        this.currentRow = -1;
        this.filterType = FilterType.FILTER_DEFAULT;
    }

    public final void processRow(byte[] byArray) {
        if (!this.initdone) {
            this.init();
        }
        ++this.currentRow;
        this.filterAndWrite(byArray);
    }

    protected void sendToCompressedStream(byte[] byArray) {
        this.compressorStream.write(byArray, 0, byArray.length);
        byte by2 = byArray[0];
        this.filtersUsed[by2] = this.filtersUsed[by2] + 1;
    }

    protected abstract void filterAndWrite(byte[] var1);

    protected final byte[] filterRowWithFilterType(FilterType filterType, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (filterType == FilterType.FILTER_NONE) {
            byArray3 = byArray;
        }
        byArray3[0] = (byte)filterType.val;
        switch (filterType) {
            case FILTER_NONE: {
                break;
            }
            case FILTER_PAETH: {
                int n2;
                for (n2 = 1; n2 <= this.bytesPixel; ++n2) {
                    byArray3[n2] = (byte)PngHelperInternal.filterRowPaeth(byArray[n2], 0, byArray2[n2] & 0xFF, 0);
                }
                int n3 = 1;
                n2 = this.bytesPixel + 1;
                while (n2 <= this.bytesRow) {
                    byArray3[n2] = (byte)PngHelperInternal.filterRowPaeth(byArray[n2], byArray[n3] & 0xFF, byArray2[n2] & 0xFF, byArray2[n3] & 0xFF);
                    ++n2;
                    ++n3;
                }
                break;
            }
            case FILTER_SUB: {
                int n4;
                for (n4 = 1; n4 <= this.bytesPixel; ++n4) {
                    byArray3[n4] = byArray[n4];
                }
                int n5 = 1;
                n4 = this.bytesPixel + 1;
                while (n4 <= this.bytesRow) {
                    byArray3[n4] = (byte)(byArray[n4] - byArray[n5]);
                    ++n4;
                    ++n5;
                }
                break;
            }
            case FILTER_AVERAGE: {
                int n6;
                for (n6 = 1; n6 <= this.bytesPixel; ++n6) {
                    byArray3[n6] = (byte)(byArray[n6] - (byArray2[n6] & 0xFF) / 2);
                }
                int n7 = 1;
                n6 = this.bytesPixel + 1;
                while (n6 <= this.bytesRow) {
                    byArray3[n6] = (byte)(byArray[n6] - ((byArray2[n6] & 0xFF) + (byArray[n7] & 0xFF)) / 2);
                    ++n6;
                    ++n7;
                }
                break;
            }
            case FILTER_UP: {
                for (int i2 = 1; i2 <= this.bytesRow; ++i2) {
                    byArray3[i2] = (byte)(byArray[i2] - byArray2[i2]);
                }
                break;
            }
            default: {
                throw new PngjOutputException("Filter type not recognized: " + (Object)((Object)filterType));
            }
        }
        return byArray3;
    }

    public abstract byte[] getRowb();

    protected final void init() {
        if (!this.initdone) {
            this.initParams();
            this.initdone = true;
        }
    }

    protected void initParams() {
        if (this.compressorStream == null) {
            this.compressorStream = new CompressorStreamDeflater(this.os, this.buflen, this.imgInfo.getTotalRawBytes(), this.deflaterCompLevel, this.deflaterStrategy);
        }
    }

    public void close() {
        if (this.compressorStream != null) {
            this.compressorStream.close();
        }
    }

    public void setDeflaterStrategy(Integer n2) {
        this.deflaterStrategy = n2;
    }

    public void setDeflaterCompLevel(Integer n2) {
        this.deflaterCompLevel = n2;
    }

    public Integer getDeflaterCompLevel() {
        return this.deflaterCompLevel;
    }

    public final void setOs(OutputStream outputStream) {
        this.os = outputStream;
    }

    public OutputStream getOs() {
        return this.os;
    }

    public final FilterType getFilterType() {
        return this.filterType;
    }

    public final void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public double getCompression() {
        return this.compressorStream.isDone() ? this.compressorStream.getCompressionRatio() : 1.0;
    }

    public void setCompressorStream(CompressorStream compressorStream) {
        this.compressorStream = compressorStream;
    }

    public long getTotalBytesToWrite() {
        return this.imgInfo.getTotalRawBytes();
    }

    protected FilterType getDefaultFilter() {
        if (this.imgInfo.indexed || this.imgInfo.bitDepth < 8) {
            return FilterType.FILTER_NONE;
        }
        if (this.imgInfo.getTotalPixels() < 1024L) {
            return FilterType.FILTER_NONE;
        }
        if (this.imgInfo.rows == 1) {
            return FilterType.FILTER_SUB;
        }
        if (this.imgInfo.cols == 1) {
            return FilterType.FILTER_UP;
        }
        return FilterType.FILTER_PAETH;
    }

    public final String getFiltersUsed() {
        return String.format("%d,%d,%d,%d,%d", (int)((double)this.filtersUsed[0] * 100.0 / (double)this.imgInfo.rows + 0.5), (int)((double)this.filtersUsed[1] * 100.0 / (double)this.imgInfo.rows + 0.5), (int)((double)this.filtersUsed[2] * 100.0 / (double)this.imgInfo.rows + 0.5), (int)((double)this.filtersUsed[3] * 100.0 / (double)this.imgInfo.rows + 0.5), (int)((double)this.filtersUsed[4] * 100.0 / (double)this.imgInfo.rows + 0.5));
    }
}

