/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineFactory;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineByte;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLineARGBbi
implements IImageLine {
    public final ImageInfo imgInfo;
    private final BufferedImage image;
    private int rowNumber = -1;
    private boolean hasAlpha;
    private int rowLength;
    private boolean bgrOrder;
    private byte[] bytes;

    public ImageLineARGBbi(ImageInfo imageInfo, BufferedImage bufferedImage, byte[] byArray) {
        this.imgInfo = imageInfo;
        this.image = bufferedImage;
        this.bytes = byArray;
        this.hasAlpha = this.image.getColorModel().hasAlpha();
        this.rowLength = this.hasAlpha ? this.image.getWidth() * 4 : this.image.getWidth() * 3;
        this.bgrOrder = ((ComponentSampleModel)this.image.getSampleModel()).getBandOffsets()[0] != 0;
    }

    public static IImageLineFactory<ImageLineByte> getFactory(ImageInfo imageInfo) {
        return new IImageLineFactory<ImageLineByte>(){

            @Override
            public ImageLineByte createImageLine(ImageInfo imageInfo) {
                return new ImageLineByte(imageInfo);
            }
        };
    }

    @Override
    public void readFromPngRaw(byte[] byArray, int n2, int n3, int n4) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void writeToPngRaw(byte[] byArray) {
        if (this.imgInfo.bytesPerRow != this.rowLength) {
            throw new RuntimeException("??");
        }
        if (this.rowNumber < 0 || this.rowNumber >= this.imgInfo.rows) {
            throw new RuntimeException("???");
        }
        int n2 = this.rowLength * this.rowNumber;
        int n3 = 1;
        if (this.hasAlpha) {
            if (this.bgrOrder) {
                while (n3 <= this.rowLength) {
                    byte by2 = this.bytes[n2++];
                    byte by3 = this.bytes[n2++];
                    byte by4 = this.bytes[n2++];
                    byte by5 = this.bytes[n2++];
                    byArray[n3++] = by5;
                    byArray[n3++] = by4;
                    byArray[n3++] = by3;
                    byArray[n3++] = by2;
                }
            } else {
                while (n3 <= this.rowLength) {
                    byArray[n3++] = this.bytes[n2++];
                    byArray[n3++] = this.bytes[n2++];
                    byArray[n3++] = this.bytes[n2++];
                    byArray[n3++] = this.bytes[n2++];
                }
            }
        } else if (this.bgrOrder) {
            while (n3 <= this.rowLength) {
                byte by6 = this.bytes[n2++];
                byte by7 = this.bytes[n2++];
                byte by8 = this.bytes[n2++];
                byArray[n3++] = by8;
                byArray[n3++] = by7;
                byArray[n3++] = by6;
            }
        } else {
            while (n3 <= this.rowLength) {
                byArray[n3++] = this.bytes[n2++];
                byArray[n3++] = this.bytes[n2++];
                byArray[n3++] = this.bytes[n2++];
            }
        }
    }

    @Override
    public void endReadFromPngRaw() {
        throw new RuntimeException("not implemented");
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int n2) {
        this.rowNumber = n2;
    }
}

