/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import java.nio.ByteOrder;

public final class DeflaterEstimatorLz4 {
    static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    static final int MEMORY_USAGE = 14;
    static final int NOT_COMPRESSIBLE_DETECTION_LEVEL = 6;
    static final int MIN_MATCH = 4;
    static final int HASH_LOG = 12;
    static final int HASH_TABLE_SIZE = 4096;
    static final int SKIP_STRENGTH = Math.max(6, 2);
    static final int COPY_LENGTH = 8;
    static final int LAST_LITERALS = 5;
    static final int MF_LIMIT = 12;
    static final int MIN_LENGTH = 13;
    static final int MAX_DISTANCE = 65536;
    static final int ML_BITS = 4;
    static final int ML_MASK = 15;
    static final int RUN_BITS = 4;
    static final int RUN_MASK = 15;
    static final int LZ4_64K_LIMIT = 65547;
    static final int HASH_LOG_64K = 13;
    static final int HASH_TABLE_SIZE_64K = 8192;
    static final int HASH_LOG_HC = 15;
    static final int HASH_TABLE_SIZE_HC = 32768;
    static final int OPTIMAL_ML = 18;

    public int compressEstim(byte[] byArray, int n2, int n3) {
        if (n3 < 10) {
            return n3;
        }
        int n4 = 65546;
        int n5 = (n3 + n4 - 1) / n4;
        if ((n4 = n3 / n5) >= 65546 || n4 * n5 > n3 || n5 < 1 || n4 < 1) {
            throw new RuntimeException("?? " + n3);
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = n3;
        while (n8 > 0) {
            if (n8 > n4) {
                n8 = n4;
            }
            n7 += DeflaterEstimatorLz4.compress64k(byArray, n2, n8);
            n2 += n8;
            n8 = n3 - (n6 += n8);
        }
        double d2 = (double)n7 / (double)n6;
        return n6 == n3 ? n7 : (int)(d2 * (double)n3 + 0.5);
    }

    public int compressEstim(byte[] byArray) {
        return this.compressEstim(byArray, 0, byArray.length);
    }

    static int compress64k(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n2 + n3;
        int n6 = n5 - 5;
        int n7 = n5 - 12;
        int n8 = n2;
        int n9 = 0;
        int n10 = n8++;
        if (n3 >= 13) {
            short[] sArray = new short[8192];
            block0: while (true) {
                int n11;
                int n12;
                int n13 = n8;
                int n14 = (1 << SKIP_STRENGTH) + 3;
                do {
                    n8 = n13;
                    if ((n13 += n14++ >>> SKIP_STRENGTH) > n7) break block0;
                    n11 = DeflaterEstimatorLz4.hash64k(DeflaterEstimatorLz4.readInt(byArray, n8));
                    n12 = n2 + DeflaterEstimatorLz4.readShort(sArray, n11);
                    DeflaterEstimatorLz4.writeShort(sArray, n11, n8 - n2);
                } while (!DeflaterEstimatorLz4.readIntEquals(byArray, n12, n8));
                n11 = DeflaterEstimatorLz4.commonBytesBackward(byArray, n12, n8, n2, n10);
                n12 -= n11;
                int n15 = (n8 -= n11) - n10;
                ++n9;
                if (n15 >= 15) {
                    if (n15 > 15) {
                        n9 += (n15 - 15) / 255;
                    }
                    ++n9;
                }
                n9 += n15;
                while (true) {
                    n9 += 2;
                    int n16 = DeflaterEstimatorLz4.commonBytes(byArray, n12 += 4, n8 += 4, n6);
                    n8 += n16;
                    if (n16 >= 15) {
                        if (n16 >= 270) {
                            n9 += (n16 - 15) / 255;
                        }
                        ++n9;
                    }
                    if (n8 > n7) {
                        n10 = n8;
                        break block0;
                    }
                    DeflaterEstimatorLz4.writeShort(sArray, DeflaterEstimatorLz4.hash64k(DeflaterEstimatorLz4.readInt(byArray, n8 - 2)), n8 - 2 - n2);
                    int n17 = DeflaterEstimatorLz4.hash64k(DeflaterEstimatorLz4.readInt(byArray, n8));
                    n12 = n2 + DeflaterEstimatorLz4.readShort(sArray, n17);
                    DeflaterEstimatorLz4.writeShort(sArray, n17, n8 - n2);
                    if (!DeflaterEstimatorLz4.readIntEquals(byArray, n8, n12)) break;
                    ++n9;
                }
                n10 = n8++;
            }
        }
        if ((n4 = n5 - n10) >= 270) {
            n9 += (n4 - 15) / 255;
        }
        ++n9;
        return n9 += n4;
    }

    static final int maxCompressedLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("length must be >= 0, got " + n2);
        }
        return n2 + n2 / 255 + 16;
    }

    static int hash(int n2) {
        return n2 * -1640531535 >>> 20;
    }

    static int hash64k(int n2) {
        return n2 * -1640531535 >>> 19;
    }

    static int readShortLittleEndian(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    static boolean readIntEquals(byte[] byArray, int n2, int n3) {
        return byArray[n2] == byArray[n3] && byArray[n2 + 1] == byArray[n3 + 1] && byArray[n2 + 2] == byArray[n3 + 2] && byArray[n2 + 3] == byArray[n3 + 3];
    }

    static int commonBytes(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n3 < n4 && byArray[n2++] == byArray[n3++]) {
            ++n5;
        }
        return n5;
    }

    static int commonBytesBackward(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n2 > n4 && n3 > n5 && byArray[--n2] == byArray[--n3]) {
            ++n6;
        }
        return n6;
    }

    static int readShort(short[] sArray, int n2) {
        return sArray[n2] & 0xFFFF;
    }

    static byte readByte(byte[] byArray, int n2) {
        return byArray[n2];
    }

    static void checkRange(byte[] byArray, int n2) {
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
    }

    static void checkRange(byte[] byArray, int n2, int n3) {
        DeflaterEstimatorLz4.checkLength(n3);
        if (n3 > 0) {
            DeflaterEstimatorLz4.checkRange(byArray, n2);
            DeflaterEstimatorLz4.checkRange(byArray, n2 + n3 - 1);
        }
    }

    static void checkLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
    }

    static int readIntBE(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static int readIntLE(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    static int readInt(byte[] byArray, int n2) {
        if (NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            return DeflaterEstimatorLz4.readIntBE(byArray, n2);
        }
        return DeflaterEstimatorLz4.readIntLE(byArray, n2);
    }

    static void writeShort(short[] sArray, int n2, int n3) {
        sArray[n2] = (short)n3;
    }
}

