/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkSRGB
extends PngChunkSingle {
    public static final String ID = "sRGB";
    public static final int RENDER_INTENT_Perceptual = 0;
    public static final int RENDER_INTENT_Relative_colorimetric = 1;
    public static final int RENDER_INTENT_Saturation = 2;
    public static final int RENDER_INTENT_Absolute_colorimetric = 3;
    private int intent;

    public PngChunkSRGB(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 1) {
            throw new PngjException("bad chunk length " + chunkRaw);
        }
        this.intent = PngHelperInternal.readInt1fromByte(chunkRaw.data, 0);
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(1, true);
        chunkRaw.data[0] = (byte)this.intent;
        return chunkRaw;
    }

    public int getIntent() {
        return this.intent;
    }

    public void setIntent(int n2) {
        this.intent = n2;
    }
}

