/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjExceptionInternal;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import java.io.OutputStream;

public abstract class PngChunk {
    public final String id;
    public final boolean crit;
    public final boolean pub;
    public final boolean safe;
    protected final ImageInfo imgInfo;
    protected ChunkRaw raw;
    private boolean priority = false;
    protected int chunkGroup = -1;

    public PngChunk(String string, ImageInfo imageInfo) {
        this.id = string;
        this.imgInfo = imageInfo;
        this.crit = ChunkHelper.isCritical(string);
        this.pub = ChunkHelper.isPublic(string);
        this.safe = ChunkHelper.isSafeToCopy(string);
    }

    protected final ChunkRaw createEmptyChunk(int n2, boolean bl2) {
        ChunkRaw chunkRaw = new ChunkRaw(n2, ChunkHelper.toBytes(this.id), bl2);
        return chunkRaw;
    }

    public final int getChunkGroup() {
        return this.chunkGroup;
    }

    final void setChunkGroup(int n2) {
        this.chunkGroup = n2;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    public void setPriority(boolean bl2) {
        this.priority = bl2;
    }

    final void write(OutputStream outputStream) {
        if (this.raw == null || this.raw.data == null) {
            this.raw = this.createRawChunk();
        }
        if (this.raw == null) {
            throw new PngjExceptionInternal("null chunk ! creation failed for " + this);
        }
        this.raw.writeChunk(outputStream);
    }

    protected abstract ChunkRaw createRawChunk();

    protected abstract void parseFromRaw(ChunkRaw var1);

    protected abstract boolean allowsMultiple();

    public ChunkRaw getRaw() {
        return this.raw;
    }

    void setRaw(ChunkRaw chunkRaw) {
        this.raw = chunkRaw;
    }

    public int getLen() {
        return this.raw != null ? this.raw.len : -1;
    }

    public long getOffset() {
        return this.raw != null ? this.raw.getOffset() : -1L;
    }

    public void invalidateRawData() {
        this.raw = null;
    }

    public abstract ChunkOrderingConstraint getOrderingConstraint();

    public String toString() {
        return "chunk id= " + this.id + " (len=" + this.getLen() + " offset=" + this.getOffset() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChunkOrderingConstraint {
        NONE,
        BEFORE_PLTE_AND_IDAT,
        AFTER_PLTE_BEFORE_IDAT,
        AFTER_PLTE_BEFORE_IDAT_PLTE_REQUIRED,
        BEFORE_IDAT,
        NA;


        public boolean mustGoBeforePLTE() {
            return this == BEFORE_PLTE_AND_IDAT;
        }

        public boolean mustGoBeforeIDAT() {
            return this == BEFORE_IDAT || this == BEFORE_PLTE_AND_IDAT || this == AFTER_PLTE_BEFORE_IDAT;
        }

        public boolean mustGoAfterPLTE() {
            return this == AFTER_PLTE_BEFORE_IDAT || this == AFTER_PLTE_BEFORE_IDAT_PLTE_REQUIRED;
        }

        public boolean isOk(int n2, boolean bl2) {
            if (this == NONE) {
                return true;
            }
            if (this == BEFORE_IDAT) {
                return n2 < 4;
            }
            if (this == BEFORE_PLTE_AND_IDAT) {
                return n2 < 2;
            }
            if (this == AFTER_PLTE_BEFORE_IDAT) {
                return bl2 ? n2 < 4 : n2 < 4 && n2 > 2;
            }
            return false;
        }
    }
}

