/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

abstract class ProgressiveOutputStream
extends ByteArrayOutputStream {
    private int size;
    private long countFlushed = 0L;

    public ProgressiveOutputStream(int n2) {
        this.size = n2;
    }

    public final void close() throws IOException {
        try {
            this.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    public final void flush() throws IOException {
        super.flush();
        this.checkFlushBuffer(true);
    }

    public final void write(byte[] byArray, int n2, int n3) {
        super.write(byArray, n2, n3);
        this.checkFlushBuffer(false);
    }

    public final void write(byte[] byArray) throws IOException {
        super.write(byArray);
        this.checkFlushBuffer(false);
    }

    public final void write(int n2) {
        super.write(n2);
        this.checkFlushBuffer(false);
    }

    public final synchronized void reset() {
        super.reset();
    }

    private final void checkFlushBuffer(boolean bl2) {
        while (bl2 || this.count >= this.size) {
            int n2;
            int n3 = this.size;
            if (n3 > this.count) {
                n3 = this.count;
            }
            if (n3 == 0) {
                return;
            }
            this.flushBuffer(this.buf, n3);
            this.countFlushed += (long)n3;
            this.count = n2 = this.count - n3;
            if (n2 <= 0) continue;
            System.arraycopy(this.buf, n3, this.buf, 0, n2);
        }
    }

    protected abstract void flushBuffer(byte[] var1, int var2);

    public void setSize(int n2) {
        this.size = n2;
        System.out.println("setting size: " + n2 + " count" + this.count);
        this.checkFlushBuffer(false);
    }

    public long getCountFlushed() {
        return this.countFlushed;
    }
}

