/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.BufferedStreamFeeder;
import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.ChunkSeqReaderPng;
import ar.com.hjg.pngj.chunks.PngChunk;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngReaderFilter
extends FilterInputStream {
    private ChunkSeqReaderPng chunkseq = this.createChunkSequenceReader();

    public PngReaderFilter(InputStream inputStream) {
        super(inputStream);
    }

    protected ChunkSeqReaderPng createChunkSequenceReader() {
        return new ChunkSeqReaderPng(true){

            public boolean shouldSkipContent(int n2, String string) {
                return super.shouldSkipContent(n2, string) || string.equals("IDAT");
            }

            protected boolean shouldCheckCrc(int n2, String string) {
                return false;
            }

            protected void postProcessChunk(ChunkReader chunkReader) {
                super.postProcessChunk(chunkReader);
            }
        };
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.chunkseq.close();
    }

    @Override
    public int read() throws IOException {
        int n2 = super.read();
        if (n2 > 0) {
            this.chunkseq.feedAll(new byte[]{(byte)n2}, 0, 1);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = super.read(byArray, n2, n3);
        if (n4 > 0) {
            this.chunkseq.feedAll(byArray, n2, n4);
        }
        return n4;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n2 = super.read(byArray);
        if (n2 > 0) {
            this.chunkseq.feedAll(byArray, 0, n2);
        }
        return n2;
    }

    public void readUntilEndAndClose() throws IOException {
        BufferedStreamFeeder bufferedStreamFeeder = new BufferedStreamFeeder(this.in);
        while (!this.chunkseq.isDone() && bufferedStreamFeeder.hasMoreToFeed()) {
            bufferedStreamFeeder.feed(this.chunkseq);
        }
        this.close();
    }

    public List<PngChunk> getChunksList() {
        return this.chunkseq.getChunks();
    }

    public ChunkSeqReaderPng getChunkseq() {
        return this.chunkseq;
    }
}

