/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.BufferedStreamFeeder;
import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.DeflatedChunkReader;
import ar.com.hjg.pngj.DeflatedChunksSet;
import ar.com.hjg.pngj.IBytesConsumer;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjExceptionInternal;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;

public class ChunkSeqReader
implements IBytesConsumer {
    protected static final int SIGNATURE_LEN = 8;
    protected final boolean withSignature;
    private byte[] buf0 = new byte[8];
    private int buf0len = 0;
    private boolean signatureDone = false;
    private boolean done = false;
    private int chunkCount = 0;
    private long bytesCount = 0L;
    private DeflatedChunksSet curReaderDeflatedSet;
    private ChunkReader curChunkReader;
    private long idatBytes;

    public ChunkSeqReader() {
        this(true);
    }

    public ChunkSeqReader(boolean bl2) {
        this.withSignature = bl2;
        this.signatureDone = !bl2;
    }

    public int consume(byte[] byArray, int n2, int n3) {
        if (this.done) {
            return -1;
        }
        if (n3 == 0) {
            return 0;
        }
        if (n3 < 0) {
            throw new PngjInputException("Bad len: " + n3);
        }
        int n4 = 0;
        if (this.signatureDone) {
            if (this.curChunkReader == null || this.curChunkReader.isDone()) {
                int n5 = 8 - this.buf0len;
                if (n5 > n3) {
                    n5 = n3;
                }
                System.arraycopy(byArray, n2, this.buf0, this.buf0len, n5);
                this.buf0len += n5;
                n4 += n5;
                this.bytesCount += (long)n5;
                n3 -= n5;
                n2 += n5;
                if (this.buf0len == 8) {
                    ++this.chunkCount;
                    int n6 = PngHelperInternal.readInt4fromBytes(this.buf0, 0);
                    String string = ChunkHelper.toString(this.buf0, 4, 4);
                    this.startNewChunk(n6, string, this.bytesCount - 8L);
                    this.buf0len = 0;
                }
            } else {
                int n7 = this.curChunkReader.feedBytes(byArray, n2, n3);
                n4 += n7;
                this.bytesCount += (long)n7;
            }
        } else {
            int n8 = 8 - this.buf0len;
            if (n8 > n3) {
                n8 = n3;
            }
            System.arraycopy(byArray, n2, this.buf0, this.buf0len, n8);
            this.buf0len += n8;
            if (this.buf0len == 8) {
                this.checkSignature(this.buf0);
                this.buf0len = 0;
                this.signatureDone = true;
            }
            n4 += n8;
            this.bytesCount += (long)n8;
        }
        return n4;
    }

    public boolean feedAll(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = this.consume(byArray, n2, n3);
            if (n4 < 1) {
                return false;
            }
            n3 -= n4;
            n2 += n4;
        }
        return true;
    }

    protected void startNewChunk(int n2, String string, long l2) {
        if (string.equals("IDAT")) {
            this.idatBytes += (long)n2;
        }
        boolean bl2 = this.shouldCheckCrc(n2, string);
        boolean bl3 = this.shouldSkipContent(n2, string);
        boolean bl4 = this.isIdatKind(string);
        boolean bl5 = false;
        if (this.curReaderDeflatedSet != null) {
            bl5 = this.curReaderDeflatedSet.ackNextChunkId(string);
        }
        if (bl4 && !bl3) {
            if (!bl5) {
                if (this.curReaderDeflatedSet != null) {
                    throw new PngjInputException("too many IDAT (or idatlike) chunks");
                }
                this.curReaderDeflatedSet = this.createIdatSet(string);
            }
            this.curChunkReader = new DeflatedChunkReader(n2, string, bl2, l2, this.curReaderDeflatedSet){

                protected void chunkDone() {
                    ChunkSeqReader.this.postProcessChunk(this);
                }
            };
        } else {
            this.curChunkReader = this.createChunkReaderForNewChunk(string, n2, l2, bl3);
            if (!bl2) {
                this.curChunkReader.setCrcCheck(false);
            }
        }
    }

    protected ChunkReader createChunkReaderForNewChunk(String string, int n2, long l2, boolean bl2) {
        return new ChunkReader(n2, string, l2, bl2 ? ChunkReader.ChunkReaderMode.SKIP : ChunkReader.ChunkReaderMode.BUFFER){

            protected void chunkDone() {
                ChunkSeqReader.this.postProcessChunk(this);
            }

            protected void processData(int n2, byte[] byArray, int n3, int n4) {
                throw new PngjExceptionInternal("should never happen");
            }
        };
    }

    protected void postProcessChunk(ChunkReader chunkReader) {
        String string;
        if (this.chunkCount == 1 && (string = this.firstChunkId()) != null && !string.equals(chunkReader.getChunkRaw().id)) {
            throw new PngjInputException("Bad first chunk: " + chunkReader.getChunkRaw().id + " expected: " + this.firstChunkId());
        }
        if (chunkReader.getChunkRaw().id.equals(this.endChunkId())) {
            this.done = true;
        }
    }

    protected DeflatedChunksSet createIdatSet(String string) {
        return new DeflatedChunksSet(string, 1024, 1024);
    }

    protected boolean isIdatKind(String string) {
        return false;
    }

    protected boolean shouldSkipContent(int n2, String string) {
        return false;
    }

    protected boolean shouldCheckCrc(int n2, String string) {
        return true;
    }

    protected void checkSignature(byte[] byArray) {
        if (!Arrays.equals(byArray, PngHelperInternal.getPngIdSignature())) {
            throw new PngjInputException("Bad PNG signature");
        }
    }

    public boolean isSignatureDone() {
        return this.signatureDone;
    }

    public boolean isDone() {
        return this.done;
    }

    public long getBytesCount() {
        return this.bytesCount;
    }

    public int getChunkCount() {
        return this.chunkCount;
    }

    public ChunkReader getCurChunkReader() {
        return this.curChunkReader;
    }

    public DeflatedChunksSet getCurReaderDeflatedSet() {
        return this.curReaderDeflatedSet;
    }

    public void close() {
        if (this.curReaderDeflatedSet != null) {
            this.curReaderDeflatedSet.close();
        }
        this.done = true;
    }

    public boolean isAtChunkBoundary() {
        return this.bytesCount == 0L || this.bytesCount == 8L || this.done || this.curChunkReader == null || this.curChunkReader.isDone();
    }

    protected String firstChunkId() {
        return "IHDR";
    }

    public long getIdatBytes() {
        return this.idatBytes;
    }

    protected String endChunkId() {
        return "IEND";
    }

    public void feedFromFile(File file) {
        try {
            this.feedFromInputStream(new FileInputStream(file), true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PngjInputException(fileNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedFromInputStream(InputStream inputStream, boolean bl2) {
        BufferedStreamFeeder bufferedStreamFeeder = new BufferedStreamFeeder(inputStream);
        bufferedStreamFeeder.setCloseStream(bl2);
        try {
            while (bufferedStreamFeeder.hasMoreToFeed()) {
                bufferedStreamFeeder.feed(this);
            }
        }
        finally {
            this.close();
            bufferedStreamFeeder.close();
        }
    }

    public void feedFromInputStream(InputStream inputStream) {
        this.feedFromInputStream(inputStream, true);
    }
}

