/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.teachrepeat.state;

import us.hebi.gui.lib.bar;
import us.hebi.gui.lib.bas;
import us.hebi.gui.lib.bdh;
import us.hebi.gui.lib.bdi;
import us.hebi.gui.lib.bdk;
import us.hebi.gui.views.teachrepeat.state.TrajectorySampler$GroupSampleConsumer;
import us.hebi.gui.views.teachrepeat.state.TrajectorySampler$JointSampleConsumer;

public abstract class TrajectorySampler {
    protected double[] time = new double[0];
    private double[][] position = new double[0][0];
    private double[][] velocity = new double[0][0];
    private double[][] acceleration = new double[0][0];
    private final bdi state = new bdi();
    private double[] p;
    private double[] v;
    private double[] a;
    protected int numSamples = 0;

    public static TrajectorySampler createContinuous(int n2) {
        return new bar(n2);
    }

    public static TrajectorySampler createKeyFrame() {
        return new bas();
    }

    public int getNumJoints() {
        return this.position.length;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public double[] getTime() {
        return this.time;
    }

    public double[] getJointPosition(int n2) {
        return this.position[n2];
    }

    public double[] getJointVelocity(int n2) {
        return this.position[n2];
    }

    public double[] getJointAcceleration(int n2) {
        return this.position[n2];
    }

    public void forEachJointSample(int n2, TrajectorySampler$JointSampleConsumer trajectorySampler$JointSampleConsumer) {
        for (int i2 = 0; i2 < this.numSamples; ++i2) {
            trajectorySampler$JointSampleConsumer.accept(i2, this.time[i2], this.position[n2][i2], this.velocity[n2][i2], this.acceleration[n2][i2]);
        }
    }

    public void forEachGroupSample(TrajectorySampler$GroupSampleConsumer trajectorySampler$GroupSampleConsumer) {
        for (int i2 = 0; i2 < this.numSamples; ++i2) {
            for (int i3 = 0; i3 < this.position.length; ++i3) {
                this.p[i3] = this.position[i3][i2];
                this.v[i3] = this.position[i3][i2];
                this.a[i3] = this.position[i3][i2];
                trajectorySampler$GroupSampleConsumer.accept(i2, this.time[i2], this.p, this.v, this.a);
            }
        }
    }

    protected abstract void extractSampleTimes(bdk var1);

    public void clear() {
        this.numSamples = 0;
    }

    public void setTrajectory(bdk bdk2) {
        int n2 = bdk2.getLength();
        this.extractSampleTimes(bdk2);
        for (int i2 = 0; i2 < n2; ++i2) {
            bdh bdh2 = bdk2.get(i2);
            for (int i3 = 0; i3 < this.numSamples; ++i3) {
                bdh2.a(this.time[i3], this.state);
                this.position[i2][i3] = this.state.position;
                this.velocity[i2][i3] = this.state.velocity;
                this.acceleration[i2][i3] = this.state.eb;
            }
        }
    }

    protected void ensureSpace(int n2, int n3) {
        if (this.position.length != n2 || this.time.length < n3) {
            this.time = new double[n3];
            this.position = new double[n2][n3];
            this.velocity = new double[n2][n3];
            this.acceleration = new double[n2][n3];
            this.p = new double[n2];
            this.v = new double[n2];
            this.a = new double[n2];
        }
    }
}

