/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.dataset.DataSet;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Parent;
import us.hebi.gui.lib.aee;
import us.hebi.gui.lib.agp;
import us.hebi.gui.lib.ang;
import us.hebi.gui.lib.aqe;
import us.hebi.gui.lib.aqk;
import us.hebi.gui.lib.aql;
import us.hebi.gui.lib.att;
import us.hebi.gui.lib.atv;
import us.hebi.gui.lib.atz;
import us.hebi.gui.lib.auz;
import us.hebi.gui.lib.avy;
import us.hebi.gui.lib.awf;
import us.hebi.gui.lib.ban;
import us.hebi.gui.lib.bea;
import us.hebi.gui.lib.bei;
import us.hebi.gui.lib.bfk;
import us.hebi.gui.lib.bfs;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationResultDialog;

public class MotorEncoderCalibrationDialog
extends CalibrationDialog<atz> {
    ReadOnlyObjectProperty<agp> motorEncoder;
    DoubleBinding idCmd;
    DoubleBinding poleSweepTime;
    DoubleBinding numPolePairs;

    @Override
    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        super.initialize(uRL, resourceBundle);
        this.setTitle("Calibrate motor encoder");
        List<agp> list = List.of(agp.c, agp.d, agp.e, agp.f);
        Object object = this.device.getInfo();
        object = ((aqe)object).a;
        this.motorEncoder = this.addEnumParameter("Motor Encoder", list, ((aqk)object).a.a(), "The port used for the encoder");
        this.idCmd = this.addDoubleParameter("FOC Id [A]", 1.0, "If the motor doesn't move, or doesn\u2019t move smoothly, this should be increased. Be careful to make sure this value stays at or below the current rating for your motor.");
        this.poleSweepTime = this.addDoubleParameter("Pole sweep time", 1.5, "Time spent per pole [s]");
        object = this.device.getInfo();
        object = ((aqe)object).a;
        object = ((aqk)object).a;
        this.numPolePairs = this.addDoubleParameter("# pole pairs", ((aql)object).cf.get(), "number of pole pairs");
    }

    @Override
    protected void fillResultGrid(atz atz2) {
        att att2;
        att att3 = atz2.e;
        Object object = Math.abs(att2.g()[0]) < 1.0E-4 ? "Wrong encoder" : (!att3.f(0.001) ? "Bad fit: " + att3.cO() : (att3.g()[1] < 0.0 ? "Wrong direction" : "Ok"));
        double d2 = atz2.dn;
        this.addResult("Offset (1 pole)", Double.isNaN(d2) || Math.abs(d2) >= 4.503599627370496E15 ? d2 : (double)Math.round(d2 * 10000.0) / 10000.0, (String)object);
    }

    @Override
    protected Parent renderResult(atz atz2) {
        XYChart xYChart = auz.d();
        xYChart.getXAxis().setName("Commanded Rotor Position");
        xYChart.getXAxis().setUnit("deg");
        xYChart.getYAxis().setName("Zeroed Encoder Offset");
        xYChart.getYAxis().setUnit("deg");
        avy avy2 = (avy)new avy("Samples", atz2.e::getNumSamples, n2 -> ang.i(atz2.e.d(n2)), n2 -> ang.i(atz2.e.c(n2) - atz2.e.d(n2) - atz2.dl)).addStyleClasses(new String[]{awf.c.F()});
        xYChart.getDatasets().addAll((Object[])new DataSet[]{avy2});
        ban ban2 = new ban();
        for (int i2 = 0; i2 < avy2.getDataCount(); ++i2) {
            int n3;
            double d2;
            double d3 = ang.j(avy2.getY(i2));
            double d4 = ang.j(avy2.getX(i2));
            ban ban3 = ban2;
            double d5 = d4 % (Math.PI * 2);
            if (d2 < 0.0) {
                d5 += Math.PI * 2;
            }
            if ((n3 = (int)Math.round(d5 / ban.dH)) < 0) {
                n3 = 0;
            }
            if (n3 >= 256) {
                n3 = 255;
            }
            int n4 = n3;
            ban3.G[n4] = ban3.G[n4] + d3;
            int n5 = n3;
            ban3.bw[n5] = ban3.bw[n5] + 1;
        }
        avy avy3 = (avy)new avy("Buckets", ban2::S, n2 -> ang.i(ban2.g(n2)), n2 -> ang.i(ban2.h(n2))).addStyleClasses(new String[]{awf.c.F()});
        double[] dArray = bea.a(0.0, Math.PI * 2, 1024);
        avy avy4 = (avy)new avy("Offset", () -> dArray.length, n2 -> ang.i(dArray[n2]), n2 -> ang.i(ban2.t(dArray[n2]))).addStyleClasses(new String[]{awf.c.F()});
        avy avy5 = (avy)new avy("OffsetSamples", avy2::getDataCount, avy2::getX, n2 -> avy2.getY(n2) - ang.i(ban2.t(ang.j(avy2.getX(n2))))).addStyleClasses(new String[]{awf.c.F()});
        xYChart.getDatasets().addAll((Object[])new DataSet[]{avy3, avy4});
        ((Renderer)xYChart.getRenderers().get(0)).addDataSet(avy5).setVisible(false);
        CalibrationResultDialog calibrationResultDialog = new CalibrationResultDialog();
        calibrationResultDialog.setPrimaryChart(xYChart);
        calibrationResultDialog.addResult("Fit", atz2.e.g()[1], "should be 1");
        calibrationResultDialog.addResult("Raw Offset", ang.i(atz2.dl), "[deg]");
        calibrationResultDialog.addResult("Raw Offset", atz2.dl, "[rad]");
        calibrationResultDialog.addResult("Offset (1 rotation)", atz2.dm, "[rad]");
        calibrationResultDialog.addResult("Offset (1 pole)", atz2.dn, "[rad]");
        calibrationResultDialog.setMatFileSupplier(() -> {
            bfs bfs2 = bei.a(atz2.e.g()[1]);
            String string = "fit";
            return bei.a().b("fit", bfs2).a("offsetRaw", bei.a(atz2.dl)).a("offsetOneRotation", bei.a(atz2.dm)).a("offsetOnePole", bei.a(atz2.dn)).a("motorEncoder", bei.a(String.valueOf(this.motorEncoder))).a("idCmd", bei.a(this.idCmd.get())).a("poleSweepTime", bei.a(this.poleSweepTime.get())).a("numPolePairs", bei.a(this.numPolePairs.get())).a("rawCommandedRotorPosition", MotorEncoderCalibrationDialog.newMatVector(atz2.e::getNumSamples, atz2.e::c)).a("rawEncoderPosition", MotorEncoderCalibrationDialog.newMatVector(atz2.e::getNumSamples, atz2.e::d)).a("bucketPosition", MotorEncoderCalibrationDialog.newMatVector(ban2::S, ban2::g)).a("bucketOffset", MotorEncoderCalibrationDialog.newMatVector(ban2::S, ban2::h));
        });
        return calibrationResultDialog;
    }

    static bfk newMatVector(IntSupplier intSupplier, IntToDoubleFunction intToDoubleFunction) {
        bfs bfs2 = bei.a(intSupplier.getAsInt(), 1);
        for (int i2 = 0; i2 < intSupplier.getAsInt(); ++i2) {
            bfs2.e(i2, intToDoubleFunction.applyAsDouble(i2));
        }
        return bfs2;
    }

    @Override
    protected Callable<atz> createTask(aee aee2) {
        atv atv2 = new atv(aee2, (agp)((Object)((Object)this.motorEncoder.get())), this.idCmd.get(), this.poleSweepTime.get(), (int)this.numPolePairs.get());
        MotorEncoderCalibrationDialog motorEncoderCalibrationDialog = this;
        new atv(aee2, (agp)((Object)((Object)this.motorEncoder.get())), this.idCmd.get(), this.poleSweepTime.get(), (int)this.numPolePairs.get()).a = motorEncoderCalibrationDialog;
        return atv2;
    }
}

