/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs;

import com.jfoenix.controls.JFXSlider;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import javax.inject.Inject;
import us.hebi.gui.Bootloader;
import us.hebi.gui.Inspector;
import us.hebi.gui.controls.SliderUtil;
import us.hebi.gui.lib.alq;
import us.hebi.gui.lib.alr;
import us.hebi.gui.lib.ama;
import us.hebi.gui.lib.anv;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.awk;
import us.hebi.gui.lib.ayf;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.ayz;
import us.hebi.gui.lib.azb;
import us.hebi.gui.lib.azj;
import us.hebi.gui.lib.h;
import us.hebi.gui.views.scope.assets.AssetCache;
import us.hebi.gui.views.scope.components.MonitoringController;

public class SettingsController {
    @FXML
    private Parent root;
    @FXML
    private ToggleGroup language;
    @FXML
    private Button infoFrequencyTarget;
    @FXML
    private Text infoFrequencyLabel;
    @FXML
    private JFXSlider infoFrequencySlider;
    @FXML
    private ComboBox<String> interfaceChoiceBox;
    @FXML
    private ComboBox<ayz> themeChoiceBox;
    @FXML
    private Button refreshInterfacesBtn;
    @FXML
    private Button addInterfaceBtn;
    @FXML
    private Button removeInterfaceBtn;
    @FXML
    private Button applyBtn;
    @FXML
    private ToggleButton disableHwAccelerationToggle;
    @FXML
    private ToggleButton combineChartsToggle;
    @FXML
    private ToggleButton plotErrorAbsToggle;
    @FXML
    private ToggleButton showPlotGridToggle;
    @FXML
    private ToggleButton showInfoToggle;
    @FXML
    private Button setCustomChartDirBtn;
    @FXML
    private Button resetCustomChartDirBtn;
    @FXML
    private Button bootloaderBtn;
    @FXML
    private Button inspectorBtn;
    @FXML
    private Button checkUpdatesBtn;
    @FXML
    private Button clearAssetCacheBtn;
    @FXML
    private Button macAddToShellBtn;
    @FXML
    private Pane macOptionPane;
    @Inject
    aqt properties;
    @Inject
    atd interfaceChoiceService;
    @Inject
    awk customChartDirectory;
    @Inject
    asg notificationService;
    @Inject
    azb downloadCache;

    @FXML
    void initialize() {
        ayf ayf2;
        azj.g(this.root);
        this.themeChoiceBox.getItems().setAll((Object[])ayz.values());
        this.themeChoiceBox.getSelectionModel().select((Object)this.properties.a());
        this.properties.d.bind((ObservableValue)this.themeChoiceBox.getSelectionModel().selectedItemProperty());
        this.refreshInterfacesBtn.setOnAction(actionEvent -> this.interfaceChoiceService.refreshInterfaces());
        this.interfaceChoiceService.initComboBox(this.interfaceChoiceBox);
        this.infoFrequencySlider.setValue(MonitoringController.hzToSlider(this.properties.a.get()));
        this.properties.a.unbind();
        this.disableHwAccelerationToggle.setSelected(this.properties.n.get());
        this.properties.n.bind((ObservableValue)this.disableHwAccelerationToggle.selectedProperty());
        this.showInfoToggle.setSelected(this.properties.l.get());
        this.properties.l.bind((ObservableValue)this.showInfoToggle.selectedProperty());
        this.combineChartsToggle.setSelected(this.properties.k.get());
        this.properties.k.bind((ObservableValue)this.combineChartsToggle.selectedProperty());
        this.plotErrorAbsToggle.setSelected(this.properties.p.get());
        this.properties.p.bind((ObservableValue)this.plotErrorAbsToggle.selectedProperty());
        this.showPlotGridToggle.setSelected(this.properties.o.get());
        this.properties.o.bind((ObservableValue)this.showPlotGridToggle.selectedProperty());
        DoubleBinding doubleBinding = Bindings.createDoubleBinding(() -> MonitoringController.sliderToHz(this.infoFrequencySlider.getValue()), (Observable[])new Observable[]{this.infoFrequencySlider.valueProperty()});
        this.properties.a.bind((ObservableValue)doubleBinding);
        this.infoFrequencyLabel.textProperty().bind((ObservableValue)doubleBinding.asString("%.1f Hz"));
        this.infoFrequencySlider.setLabelFormatter(MonitoringController.frequencylabelFormatter);
        SliderUtil.setValueLabelFactory(this.infoFrequencySlider, MonitoringController::sliderToHz);
        SliderUtil.setupTargetButton(this.infoFrequencySlider, (BooleanProperty)new SimpleBooleanProperty(true), this.infoFrequencyTarget, MonitoringController::hzToSlider, MonitoringController::sliderToHz);
        this.removeInterfaceBtn.setOnAction(actionEvent -> this.interfaceChoiceService.removeSelectedInterface());
        this.addInterfaceBtn.setOnAction(actionEvent -> {
            Optional<String> optional = anv.a("Interface Address (IPv4)", "10.11.12.13", this.addInterfaceBtn.getScene().getWindow());
            if (optional.isPresent()) {
                try {
                    InetSocketAddress inetSocketAddress = h.a(optional.get().trim(), 16665);
                    this.interfaceChoiceService.addInterface(inetSocketAddress);
                    return;
                }
                catch (Exception exception) {
                    asf.a(exception);
                }
            }
        });
        this.setCustomChartDirBtn.textProperty().bind((ObservableValue)this.customChartDirectory.selectedDirectoryProperty().asString());
        this.setCustomChartDirBtn.setOnAction(actionEvent -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle("Select directory");
            directoryChooser.setInitialDirectory(this.customChartDirectory.getSelectedDirectory().toFile());
            Optional.ofNullable(directoryChooser.showDialog(ayo.a(actionEvent))).map(File::toPath).map(Path::toAbsolutePath).ifPresent(this.customChartDirectory::setSelectedDirectory);
        });
        this.resetCustomChartDirBtn.setOnAction(actionEvent -> this.customChartDirectory.setSelectedDirectory(null));
        this.clearAssetCacheBtn.setOnAction(ayo.a(this.clearAssetCacheBtn.disableProperty(), (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            try {
                AssetCache.clear();
                Path path = this.downloadCache.f;
                if (Files.exists(path, new LinkOption[0])) {
                    Files.walkFileTree(path, new alq());
                    if (Files.exists(path, new LinkOption[0])) {
                        throw new IOException("Target path was not deleted");
                    }
                }
                asf.a("Cleared cached assets.", ayo.a(actionEvent));
                return;
            }
            catch (IOException iOException) {
                this.notificationService.e(iOException);
                return;
            }
        })));
        this.inspectorBtn.setOnAction(actionEvent -> {
            if (!asf.a("Do you want to launch the Inspector app?", ayo.a(actionEvent))) {
                return;
            }
            try {
                Inspector.b();
                return;
            }
            catch (IOException iOException) {
                asf.a(iOException, ayo.a(actionEvent));
                return;
            }
        });
        this.bootloaderBtn.setOnAction(actionEvent -> {
            if (!asf.a("This hidden button opens an internal Bootloader utility. Incorrect usage may lead to bricking your devices in a way that will not be covered by warranty. Do you want to proceed?", ayo.a(actionEvent))) {
                return;
            }
            try {
                Bootloader.a();
                return;
            }
            catch (IOException iOException) {
                asf.a(iOException, ayo.a(actionEvent));
                return;
            }
        });
        if (ayf.isAvailable()) {
            ayf2 = new ayf();
            this.checkUpdatesBtn.disableProperty().bind((ObservableValue)ayf2.T);
            this.checkUpdatesBtn.setOnAction(actionEvent -> {
                this.checkUpdatesBtn.getParent().requestFocus();
                ayf2.w((ActionEvent)actionEvent);
            });
            this.checkUpdatesBtn.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)ayf2.T).then("Working ...").otherwise("Check for updates"));
        } else if (!ayo.aU()) {
            ayo.b(this.checkUpdatesBtn);
        }
        if (ama.ay() && alr.aw() || ayo.aU()) {
            ayf2 = this.macAddToShellBtn.disableProperty();
            this.macAddToShellBtn.setOnAction(arg_0 -> SettingsController.lambda$initialize$11((BooleanProperty)ayf2, arg_0));
            this.macAddToShellBtn.prefHeightProperty().bind((ObservableValue)this.checkUpdatesBtn.heightProperty());
            return;
        }
        ayo.b(this.macOptionPane);
    }

    public Button getCloseButton() {
        return this.applyBtn;
    }

    private static /* synthetic */ void lambda$initialize$11(BooleanProperty booleanProperty, ActionEvent actionEvent) {
        booleanProperty.set(true);
        ayo.a(alr::a, alz2 -> {
            booleanProperty.set(false);
            Window window = ayo.a(actionEvent);
            if (alz2.at) {
                asf.a(alz2.J, window);
                return;
            }
            asf.a(alz2.J, window);
        });
    }
}

