/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import io.fair_acc.chartfx.utils.PropUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.xml.transform.sax.SAXSource;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.controls.HEnumInputField;
import us.hebi.gui.controls.TextUtil;
import us.hebi.gui.lib.aal;
import us.hebi.gui.lib.aar;
import us.hebi.gui.lib.abl;
import us.hebi.gui.lib.abn;
import us.hebi.gui.lib.abp;
import us.hebi.gui.lib.ace;
import us.hebi.gui.lib.agm;
import us.hebi.gui.lib.agn;
import us.hebi.gui.lib.ago;
import us.hebi.gui.lib.agp;
import us.hebi.gui.lib.agq;
import us.hebi.gui.lib.agr;
import us.hebi.gui.lib.ags;
import us.hebi.gui.lib.agt;
import us.hebi.gui.lib.agu;
import us.hebi.gui.lib.agv;
import us.hebi.gui.lib.amr;
import us.hebi.gui.lib.aod;
import us.hebi.gui.lib.apr;
import us.hebi.gui.lib.aps;
import us.hebi.gui.lib.apt;
import us.hebi.gui.lib.apw;
import us.hebi.gui.lib.apy;
import us.hebi.gui.lib.aqa;
import us.hebi.gui.lib.aqe;
import us.hebi.gui.lib.aqk;
import us.hebi.gui.lib.aql;
import us.hebi.gui.lib.aqp;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.asb;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.atg;
import us.hebi.gui.lib.atl;
import us.hebi.gui.lib.atu;
import us.hebi.gui.lib.auc;
import us.hebi.gui.lib.axy;
import us.hebi.gui.lib.ayb;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.uk;
import us.hebi.gui.views.scope.components.EncoderConfigController;
import us.hebi.gui.views.scope.components.MotorDriverCommand;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.dialogs.calibrate.AdcCalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.MotorEncoderCalibrationDialog;

public class MotorDriverController
extends axy {
    @FXML
    private Button calibrateAdcBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private ToggleButton persistToggle;
    @FXML
    private ToggleButton showAdvancedToggle;
    @FXML
    private ToggleButton showEncoderToggle;
    @FXML
    private HEnumInputField<ags> controlMode;
    @FXML
    private HEnumInputField<agp> outputEncoder;
    @FXML
    private HEnumInputField<agp> deflectionEncoder;
    @FXML
    private HEnumInputField<agp> motorEncoder;
    @FXML
    private Pane encoderA1;
    @FXML
    private EncoderConfigController encoderA1Controller;
    @FXML
    private Pane encoderA2;
    @FXML
    private EncoderConfigController encoderA2Controller;
    @FXML
    private Pane encoderB1;
    @FXML
    private EncoderConfigController encoderB1Controller;
    @FXML
    private Pane encoderB2;
    @FXML
    private EncoderConfigController encoderB2Controller;
    @FXML
    private Pane encoderHalls;
    @FXML
    private EncoderConfigController encoderHallsController;
    @FXML
    private HEnumInputField<agv> windingOrder;
    @FXML
    private HEnumInputField<agr> hallOrder;
    @FXML
    private VBox focContainer;
    @FXML
    private HDoubleInputField focIdIClamp;
    @FXML
    private HDoubleInputField focIdKi;
    @FXML
    private HDoubleInputField focIdKp;
    @FXML
    private HDoubleInputField focIqIClamp;
    @FXML
    private HDoubleInputField focIqKi;
    @FXML
    private HDoubleInputField focIqKp;
    @FXML
    private HDoubleInputField gearEfficiency;
    @FXML
    private HDoubleInputField maxOutputTorque;
    @FXML
    private HDoubleInputField gearRatioNumerator;
    @FXML
    private HDoubleInputField gearRatioDenominator;
    @FXML
    private HDoubleInputField calibOffsetIa;
    @FXML
    private HDoubleInputField calibOffsetIb;
    @FXML
    private HDoubleInputField calibOffsetIc;
    @FXML
    private HDoubleInputField calibOffsetIBus;
    @FXML
    private HDoubleInputField calibOffsetVa;
    @FXML
    private HDoubleInputField calibOffsetVb;
    @FXML
    private HDoubleInputField calibOffsetVc;
    @FXML
    private HDoubleInputField housingThermalResistance;
    @FXML
    private HDoubleInputField housingThermalTimeConstant;
    @FXML
    private HDoubleInputField thermalModelStartPercentage;
    @FXML
    private Button loadFileBtn;
    @FXML
    private HDoubleInputField maxBoardCurrent;
    @FXML
    private HDoubleInputField maxDutyCycle;
    @FXML
    private HDoubleInputField maxMotorSpeed;
    @FXML
    private HDoubleInputField minDutyCycle;
    @FXML
    private HDoubleInputField switchingFreq;
    @FXML
    private HDoubleInputField controlDivider;
    @FXML
    private HDoubleInputField currentSenseThresholdVds;
    @FXML
    private HDoubleInputField currentSenseThresholdWinding;
    @FXML
    private HDoubleInputField currentFilterSize;
    @FXML
    private HDoubleInputField currentSenseGain;
    @FXML
    private HEnumInputField<agu> torqueSource;
    @FXML
    private HEnumInputField<agt> temperatureSource;
    @FXML
    private HDoubleInputField polePairs;
    @FXML
    private Button resetBtn;
    @FXML
    private Button saveFileBtn;
    @FXML
    private Button sendBtn;
    @FXML
    private HDoubleInputField speedConstant;
    @FXML
    private HDoubleInputField torqueConstant;
    @FXML
    private HDoubleInputField windingInductance;
    @FXML
    private HDoubleInputField windingMaxCurrent;
    @FXML
    private HDoubleInputField windingMaxTemp;
    @FXML
    private HDoubleInputField motorTorqueTempConstant;
    @FXML
    private HDoubleInputField motorVelocityTempConstant;
    @FXML
    private HDoubleInputField windingResistance;
    @FXML
    private HDoubleInputField windingThermalResistance;
    @FXML
    private HDoubleInputField windingThermalTimeConstant;
    @FXML
    private Button suggestFocGainsButton;
    @FXML
    private Button calibrateMotorEncoderBtn;
    List<Runnable> addInputList = new ArrayList<Runnable>();
    List<Runnable> onClear = new ArrayList<Runnable>();
    ValidationSupport validation;
    @Inject
    aqt properties;
    @Inject
    asy commandService;
    @Inject
    atl device;
    @Inject
    atg selector;
    @Inject
    auc fileChooser;
    @Inject
    asg notificationService;
    @Inject
    asb dialogService;

    @Override
    public void initializeFx() {
        this.validation = ayb.a();
        MotorDriverCommand motorDriverCommand = new MotorDriverCommand();
        this.setupInputFields(motorDriverCommand);
        BooleanBinding booleanBinding = this.selector.selectionSingle().not();
        this.clearBtn.setOnAction(actionEvent -> this.onClear.forEach(Runnable::run));
        aod.b((Node)this.sendBtn, ayb.b(this.validation));
        this.sendBtn.disableProperty().bind((ObservableValue)booleanBinding.or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.sendBtn.setOnAction(actionEvent -> {
            motorDriverCommand.clear();
            this.addInputList.forEach(Runnable::run);
            if (this.persistToggle.isSelected()) {
                motorDriverCommand.setPersistAllFlag();
            }
            this.commandService.b(this.selector.getSelectedAddresses(), motorDriverCommand);
        });
        this.resetBtn.disableProperty().bind((ObservableValue)this.selector.selectionEmpty());
        this.resetBtn.setOnAction(actionEvent -> {
            motorDriverCommand.clear();
            this.commandService.a(this.selector.getSelectedAddresses(), motorDriverCommand.setResetFlag());
        });
        aod.a((Node)this.resetBtn, new ObservableBooleanValue[]{this.device.needsResetProperty()});
        this.persistToggle.selectedProperty().bindBidirectional((Property)this.properties.t);
        this.showAdvancedToggle.selectedProperty().bindBidirectional((Property)this.properties.u);
        this.saveFileBtn.disableProperty().bind((ObservableValue)booleanBinding);
        this.loadFileBtn.disableProperty().bind((ObservableValue)booleanBinding);
        this.saveFileBtn.setOnAction(this::saveToFile);
        this.loadFileBtn.setOnAction(this::loadFromFile);
    }

    void saveToFile(ActionEvent actionEvent) {
        File file = this.fileChooser.f(ayo.a(actionEvent));
        if (file == null) {
            return;
        }
        try {
            new aal().writeXml(abl.fromInfo(this.device.getInfo()), file);
            return;
        }
        catch (Exception exception) {
            this.notificationService.e(exception);
            return;
        }
    }

    void loadFromFile(ActionEvent actionEvent) {
        Window window = ayo.a(actionEvent);
        auc auc2 = this.fileChooser;
        auc2.a(auc2.c, "lastDriverConfigChoiceDirectory");
        auc auc3 = auc2;
        File file = auc3.b(auc3.c.showOpenDialog(window), "lastDriverConfigChoiceDirectory");
        if (file == null) {
            return;
        }
        try {
            SAXSource sAXSource = ace.getSourceWithIncludes(file);
            abl abl2 = (abl)new aal().readXml(sAXSource);
            this.setFieldsFromXml(abl2);
            return;
        }
        catch (Exception exception) {
            this.notificationService.e(exception);
            return;
        }
    }

    private void setFieldsFromXml(abl abl2) {
        aar aar2;
        abp abp2;
        abn abn2 = abl2.getMotor();
        if (abn2 != null) {
            this.polePairs.setTextNullable(abn2.getPolePairs());
            this.speedConstant.setTextNullable(abn2.getSpeedConstant());
            this.torqueConstant.setTextNullable(abn2.getTorqueConstant());
            this.maxMotorSpeed.setTextNullable(abn2.getMaxMotorSpeed());
            this.windingResistance.setTextNullable(abn2.getWindingResistance());
            this.windingInductance.setTextNullable(abn2.getWindingInductance());
            this.windingMaxCurrent.setTextNullable(abn2.getMaxWindingCurrent());
            this.windingMaxTemp.setTextNullable(abn2.getMaxWindingTemperature());
            this.motorTorqueTempConstant.setTextNullable(abn2.getTorqueTempConstant());
            this.motorVelocityTempConstant.setTextNullable(abn2.getVelocityTempConstant());
        }
        if ((abp2 = abl2.getThermalModel()) != null) {
            this.windingThermalResistance.setTextNullable(abp2.getWindingThermalResistance());
            this.windingThermalTimeConstant.setTextNullable(abp2.getWindingThermalTimeConst());
            this.housingThermalResistance.setTextNullable(abp2.getHousingThermalResistance());
            this.housingThermalTimeConstant.setTextNullable(abp2.getHousingThermalTimeConst());
            Optional.ofNullable(abp2.getTemperatureSource()).map(agt::a).ifPresent(this.temperatureSource::setValue);
            this.thermalModelStartPercentage.setTextNullable(abp2.getModelStartPercentage());
        }
        if ((aar2 = abl2.getController()) != null) {
            Optional.ofNullable(aar2.getControlMode()).map(ags::a).ifPresent(this.controlMode::setValue);
            Optional.ofNullable(aar2.getIqGains()).ifPresent(abh2 -> {
                this.focIqKp.setTextNullable(abh2.getK());
                this.focIqKi.setTextNullable(abh2.getKi());
                this.focIqIClamp.setTextNullable(abh2.getIClamp());
            });
            Optional.ofNullable(aar2.getIdGains()).ifPresent(abh2 -> {
                this.focIdKp.setTextNullable(abh2.getK());
                this.focIdKi.setTextNullable(abh2.getKi());
                this.focIdIClamp.setTextNullable(abh2.getIClamp());
            });
        }
        Optional.ofNullable(abl2.getEncoders()).ifPresent(aav2 -> {
            Optional.ofNullable(aav2.getMotorEncoderPort()).map(agp::a).ifPresent(this.motorEncoder::setValue);
            Optional.ofNullable(aav2.getOutputEncoderPort()).map(agp::a).ifPresent(this.outputEncoder::setValue);
            Optional.ofNullable(aav2.getDeflectionEncoderPort()).map(agp::a).ifPresent(this.deflectionEncoder::setValue);
            Optional.ofNullable(aav2.getTorqueSource()).map(agu::a).ifPresent(this.torqueSource::setValue);
            Optional.ofNullable(aav2.getHallSwitches()).ifPresent(this.encoderHallsController::setFromXml);
            Optional.ofNullable(aav2.getEncoderA1()).ifPresent(this.encoderA1Controller::setFromXml);
            Optional.ofNullable(aav2.getEncoderA2()).ifPresent(this.encoderA2Controller::setFromXml);
            Optional.ofNullable(aav2.getEncoderB1()).ifPresent(this.encoderB1Controller::setFromXml);
            Optional.ofNullable(aav2.getEncoderB2()).ifPresent(this.encoderB2Controller::setFromXml);
        });
        Optional.ofNullable(abl2.getBoard()).ifPresent(aap2 -> {
            this.minDutyCycle.setTextNullable(aap2.getMinDutyCycle());
            this.maxDutyCycle.setTextNullable(aap2.getMaxDutyCycle());
            this.maxBoardCurrent.setTextNullable(aap2.getMaxBoardCurrent());
            this.switchingFreq.setTextNullable(aap2.getSwitchingFrequency());
            this.currentSenseThresholdVds.setTextNullable(aap2.getCurrentSenseThresholdVds());
            this.currentSenseThresholdWinding.setTextNullable(aap2.getCurrentSenseThresholdWinding());
            this.currentSenseGain.setTextNullable(aap2.getCurrentSenseGain());
            this.currentFilterSize.setTextNullable(aap2.getCurrentFilterSize());
            this.controlDivider.setTextNullable(aap2.getControlDivider());
            Optional.ofNullable(aap2.getWindingOrder()).map(agv::a).ifPresent(this.windingOrder::setValue);
            Optional.ofNullable(aap2.getHallOrder()).map(agr::a).ifPresent(this.hallOrder::setValue);
        });
        Optional.ofNullable(abl2.getBoardCalibration()).ifPresent(aan2 -> {
            this.calibOffsetIa.setTextNullable(aan2.getOffsetIa());
            this.calibOffsetIb.setTextNullable(aan2.getOffsetIb());
            this.calibOffsetIc.setTextNullable(aan2.getOffsetIc());
            this.calibOffsetIBus.setTextNullable(aan2.getOffsetIBus());
            this.calibOffsetVa.setTextNullable(aan2.getOffsetVa());
            this.calibOffsetVb.setTextNullable(aan2.getOffsetVb());
            this.calibOffsetVc.setTextNullable(aan2.getOffsetVc());
        });
        Optional.ofNullable(abl2.getGearTrain()).ifPresent(abj2 -> {
            this.gearRatioNumerator.setTextNullable(abl2.getGearTrain().getGearRatioNumerator());
            this.gearRatioDenominator.setTextNullable(abl2.getGearTrain().getGearRatioDenominator());
            this.gearEfficiency.setTextNullable(abl2.getGearTrain().getEfficiency());
            this.maxOutputTorque.setTextNullable(abj2.getMaxOutputTorque());
        });
    }

    private void setupInputFields(MotorDriverCommand motorDriverCommand) {
        Object object2 = this.device.getInfo();
        aqk aqk2 = ((aqe)object2).a;
        object2 = aqk2;
        aql aql2 = aqk2.a;
        object2 = aqk2;
        aqp aqp2 = ((aqk)object2).a;
        object2 = aqk2;
        aqa aqa2 = ((aqk)object2).a;
        object2 = aqk2;
        apw apw2 = ((aqk)object2).a;
        Object object3 = aqk2;
        aps aps2 = ((aqk)object3).a;
        object3 = aqk2;
        apt apt2 = ((aqk)object3).a;
        object3 = aqk2;
        apr apr2 = ((aqk)object3).a;
        MotorDriverController motorDriverController = this;
        object3 = aqa2;
        motorDriverController.bindIntField(motorDriverController.gearRatioNumerator, (ReadOnlyDoubleProperty)((aqa)object3).bh, n2 -> motorDriverCommand.gearTrain().a(n2));
        MotorDriverController motorDriverController2 = this;
        object3 = aqa2;
        motorDriverController2.bindIntField(motorDriverController2.gearRatioDenominator, (ReadOnlyDoubleProperty)((aqa)object3).bg, n2 -> motorDriverCommand.gearTrain().b(n2));
        MotorDriverController motorDriverController3 = this;
        object3 = aqa2;
        motorDriverController3.bindField(motorDriverController3.gearEfficiency, (ReadOnlyDoubleProperty)((aqa)object3).bf, f2 -> motorDriverCommand.gearTrain().a(f2));
        MotorDriverController motorDriverController4 = this;
        object3 = aqa2;
        motorDriverController4.bindField(motorDriverController4.maxOutputTorque, (ReadOnlyDoubleProperty)((aqa)object3).bi, f2 -> motorDriverCommand.gearTrain().b(f2));
        for (CustomTextField customTextField : List.of(this.gearRatioNumerator.getTextInput(), this.gearRatioDenominator.getTextInput())) {
            this.validation.registerValidator((Control)customTextField, (control, object) -> {
                boolean bl2 = (!this.gearRatioNumerator.getText().isBlank() || !this.gearRatioDenominator.getText().isBlank()) && !ParseUtils.isInteger(customTextField.getText());
                return ValidationResult.fromErrorIf((Control)customTextField, "Numerator and denominator must be set together.", bl2);
            });
            PropUtil.runOnChange(this.validation::revalidate, new ObservableValue[]{customTextField.textProperty()});
        }
        MotorDriverController motorDriverController5 = this;
        object2 = apw2;
        motorDriverController5.bindEnumField(motorDriverController5.outputEncoder, (ReadOnlyObjectProperty)((apw)object2).r, (Consumer)agp2 -> motorDriverCommand.encoders().b(agp2.a));
        MotorDriverController motorDriverController6 = this;
        object2 = apw2;
        motorDriverController6.bindEnumField(motorDriverController6.deflectionEncoder, (ReadOnlyObjectProperty)((apw)object2).p, (Consumer)agp2 -> motorDriverCommand.encoders().c(agp2.a));
        MotorDriverController motorDriverController7 = this;
        object2 = apw2;
        motorDriverController7.bindEnumField(motorDriverController7.motorEncoder, (ReadOnlyObjectProperty)((apw)object2).q, (Consumer)agp2 -> motorDriverCommand.encoders().a(agp2.a));
        MotorDriverController motorDriverController8 = this;
        object3 = apw2;
        motorDriverController8.bindEnumField(motorDriverController8.torqueSource, (ReadOnlyObjectProperty)((apw)object3).s, (Consumer)agu2 -> motorDriverCommand.encoders().a(agu2.a));
        this.encoderA1Controller.bindFields(this, agp.c, motorDriverCommand);
        this.encoderA2Controller.bindFields(this, agp.d, motorDriverCommand);
        this.encoderB1Controller.bindFields(this, agp.e, motorDriverCommand);
        this.encoderB2Controller.bindFields(this, agp.f, motorDriverCommand);
        this.encoderHallsController.bindFields(this, agp.g, motorDriverCommand);
        MotorDriverController motorDriverController9 = this;
        object3 = aps2;
        motorDriverController9.bindField(motorDriverController9.minDutyCycle, (ReadOnlyDoubleProperty)((aps)object3).X, f2 -> motorDriverCommand.board().a(f2));
        MotorDriverController motorDriverController10 = this;
        object3 = aps2;
        motorDriverController10.bindField(motorDriverController10.maxDutyCycle, (ReadOnlyDoubleProperty)((aps)object3).W, f2 -> motorDriverCommand.board().b(f2));
        MotorDriverController motorDriverController11 = this;
        object3 = aps2;
        motorDriverController11.bindField(motorDriverController11.maxBoardCurrent, (ReadOnlyDoubleProperty)((aps)object3).V, f2 -> motorDriverCommand.board().c(f2));
        MotorDriverController motorDriverController12 = this;
        object3 = aps2;
        motorDriverController12.bindField(motorDriverController12.switchingFreq, (ReadOnlyDoubleProperty)((aps)object3).Q, f2 -> motorDriverCommand.board().d(f2));
        MotorDriverController motorDriverController13 = this;
        object3 = aps2;
        motorDriverController13.bindField(motorDriverController13.controlDivider, (ReadOnlyDoubleProperty)((aps)object3).P, f2 -> motorDriverCommand.board().e((int)f2));
        MotorDriverController motorDriverController14 = this;
        object3 = aps2;
        motorDriverController14.bindField(motorDriverController14.currentSenseThresholdVds, (ReadOnlyDoubleProperty)((aps)object3).T, f2 -> motorDriverCommand.board().a((int)f2));
        MotorDriverController motorDriverController15 = this;
        object3 = aps2;
        motorDriverController15.bindField(motorDriverController15.currentSenseThresholdWinding, (ReadOnlyDoubleProperty)((aps)object3).U, f2 -> motorDriverCommand.board().b((int)f2));
        MotorDriverController motorDriverController16 = this;
        object3 = aps2;
        motorDriverController16.bindField(motorDriverController16.currentFilterSize, (ReadOnlyDoubleProperty)((aps)object3).R, f2 -> motorDriverCommand.board().d((int)f2));
        MotorDriverController motorDriverController17 = this;
        object3 = aps2;
        motorDriverController17.bindField(motorDriverController17.currentSenseGain, (ReadOnlyDoubleProperty)((aps)object3).S, f2 -> motorDriverCommand.board().c((int)f2));
        MotorDriverController motorDriverController18 = this;
        object3 = aps2;
        motorDriverController18.bindEnumField(motorDriverController18.windingOrder, (ReadOnlyObjectProperty)((aps)object3).j, (Consumer)agv2 -> motorDriverCommand.board().a(agv2.a));
        MotorDriverController motorDriverController19 = this;
        object3 = aps2;
        motorDriverController19.bindEnumField(motorDriverController19.hallOrder, (ReadOnlyObjectProperty)((aps)object3).i, (Consumer)agr2 -> motorDriverCommand.board().a(agr2.a));
        MotorDriverController motorDriverController20 = this;
        object3 = apr2;
        motorDriverController20.bindField(motorDriverController20.calibOffsetIa, (ReadOnlyDoubleProperty)((apr)object3).J, f2 -> motorDriverCommand.boardCalibration().a(f2));
        MotorDriverController motorDriverController21 = this;
        object3 = apr2;
        motorDriverController21.bindField(motorDriverController21.calibOffsetIb, (ReadOnlyDoubleProperty)((apr)object3).K, f2 -> motorDriverCommand.boardCalibration().b(f2));
        MotorDriverController motorDriverController22 = this;
        object3 = apr2;
        motorDriverController22.bindField(motorDriverController22.calibOffsetIc, (ReadOnlyDoubleProperty)((apr)object3).L, f2 -> motorDriverCommand.boardCalibration().c(f2));
        MotorDriverController motorDriverController23 = this;
        object3 = apr2;
        motorDriverController23.bindField(motorDriverController23.calibOffsetIBus, (ReadOnlyDoubleProperty)((apr)object3).I, f2 -> motorDriverCommand.boardCalibration().d(f2));
        MotorDriverController motorDriverController24 = this;
        object3 = apr2;
        motorDriverController24.bindField(motorDriverController24.calibOffsetVa, (ReadOnlyDoubleProperty)((apr)object3).M, f2 -> motorDriverCommand.boardCalibration().e(f2));
        MotorDriverController motorDriverController25 = this;
        object3 = apr2;
        motorDriverController25.bindField(motorDriverController25.calibOffsetVb, (ReadOnlyDoubleProperty)((apr)object3).N, f2 -> motorDriverCommand.boardCalibration().f(f2));
        MotorDriverController motorDriverController26 = this;
        object3 = apr2;
        motorDriverController26.bindField(motorDriverController26.calibOffsetVc, (ReadOnlyDoubleProperty)((apr)object3).O, f2 -> motorDriverCommand.boardCalibration().g(f2));
        MotorDriverController motorDriverController27 = this;
        object3 = aqp2;
        motorDriverController27.bindField(motorDriverController27.windingThermalResistance, (ReadOnlyDoubleProperty)((aqp)object3).cv, f2 -> motorDriverCommand.thermalModel().a(f2));
        MotorDriverController motorDriverController28 = this;
        object3 = aqp2;
        motorDriverController28.bindField(motorDriverController28.windingThermalTimeConstant, (ReadOnlyDoubleProperty)((aqp)object3).cw, f2 -> motorDriverCommand.thermalModel().c(f2));
        MotorDriverController motorDriverController29 = this;
        object3 = aqp2;
        motorDriverController29.bindField(motorDriverController29.housingThermalResistance, (ReadOnlyDoubleProperty)((aqp)object3).cs, f2 -> motorDriverCommand.thermalModel().b(f2));
        MotorDriverController motorDriverController30 = this;
        object3 = aqp2;
        motorDriverController30.bindField(motorDriverController30.housingThermalTimeConstant, (ReadOnlyDoubleProperty)((aqp)object3).ct, f2 -> motorDriverCommand.thermalModel().d(f2));
        MotorDriverController motorDriverController31 = this;
        object3 = aqp2;
        motorDriverController31.bindField(motorDriverController31.thermalModelStartPercentage, (ReadOnlyDoubleProperty)((aqp)object3).cu, f2 -> motorDriverCommand.thermalModel().e(f2));
        MotorDriverController motorDriverController32 = this;
        object3 = aqp2;
        motorDriverController32.bindEnumField(motorDriverController32.temperatureSource, (ReadOnlyObjectProperty)((aqp)object3).G, (Consumer)agt2 -> motorDriverCommand.thermalModel().a(agt2.a));
        MotorDriverController motorDriverController33 = this;
        object3 = aql2;
        motorDriverController33.bindField(motorDriverController33.polePairs, (ReadOnlyDoubleProperty)((aql)object3).cf, f2 -> motorDriverCommand.motor().a((int)f2));
        MotorDriverController motorDriverController34 = this;
        object3 = aql2;
        motorDriverController34.bindField(motorDriverController34.speedConstant, (ReadOnlyDoubleProperty)((aql)object3).cg, f2 -> motorDriverCommand.motor().f(f2));
        MotorDriverController motorDriverController35 = this;
        object3 = aql2;
        motorDriverController35.bindField(motorDriverController35.torqueConstant, (ReadOnlyDoubleProperty)((aql)object3).ch, f2 -> motorDriverCommand.motor().g(f2));
        MotorDriverController motorDriverController36 = this;
        object3 = aql2;
        motorDriverController36.bindField(motorDriverController36.maxMotorSpeed, (ReadOnlyDoubleProperty)((aql)object3).cc, f2 -> motorDriverCommand.motor().c(f2));
        MotorDriverController motorDriverController37 = this;
        object3 = aql2;
        motorDriverController37.bindField(motorDriverController37.windingResistance, (ReadOnlyDoubleProperty)((aql)object3).cl, f2 -> motorDriverCommand.motor().e(f2));
        MotorDriverController motorDriverController38 = this;
        object3 = aql2;
        motorDriverController38.bindField(motorDriverController38.windingInductance, (ReadOnlyDoubleProperty)((aql)object3).ck, f2 -> motorDriverCommand.motor().d((float)((double)f2 * 0.001)));
        MotorDriverController motorDriverController39 = this;
        object2 = aql2;
        motorDriverController39.bindField(motorDriverController39.windingMaxCurrent, (ReadOnlyDoubleProperty)((aql)object2).cd, f2 -> motorDriverCommand.motor().a(f2));
        MotorDriverController motorDriverController40 = this;
        object3 = aql2;
        motorDriverController40.bindField(motorDriverController40.windingMaxTemp, (ReadOnlyDoubleProperty)((aql)object3).ce, f2 -> motorDriverCommand.motor().b(f2));
        MotorDriverController motorDriverController41 = this;
        object3 = aql2;
        motorDriverController41.bindField(motorDriverController41.motorVelocityTempConstant, (ReadOnlyDoubleProperty)((aql)object3).cj, f2 -> motorDriverCommand.motor().i(f2));
        MotorDriverController motorDriverController42 = this;
        object3 = aql2;
        motorDriverController42.bindField(motorDriverController42.motorTorqueTempConstant, (ReadOnlyDoubleProperty)((aql)object3).ci, f2 -> motorDriverCommand.motor().h(f2));
        MotorDriverController motorDriverController43 = this;
        object2 = apt2;
        object2 = ((apt)object2).b;
        motorDriverController43.bindField(motorDriverController43.focIqKp, (ReadOnlyDoubleProperty)((apy)object2).ao, f2 -> motorDriverCommand.controller().b().a(f2));
        MotorDriverController motorDriverController44 = this;
        object2 = apt2;
        object2 = ((apt)object2).b;
        motorDriverController44.bindField(motorDriverController44.focIqKi, (ReadOnlyDoubleProperty)((apy)object2).an, f2 -> motorDriverCommand.controller().b().b(f2));
        MotorDriverController motorDriverController45 = this;
        object2 = apt2;
        object2 = ((apt)object2).b;
        motorDriverController45.bindField(motorDriverController45.focIqIClamp, (ReadOnlyDoubleProperty)((apy)object2).am, f2 -> motorDriverCommand.controller().b().f(f2));
        MotorDriverController motorDriverController46 = this;
        object2 = apt2;
        object2 = ((apt)object2).a;
        motorDriverController46.bindField(motorDriverController46.focIdKp, (ReadOnlyDoubleProperty)((apy)object2).ao, f2 -> motorDriverCommand.controller().a().a(f2));
        MotorDriverController motorDriverController47 = this;
        object2 = apt2;
        object2 = ((apt)object2).a;
        motorDriverController47.bindField(motorDriverController47.focIdKi, (ReadOnlyDoubleProperty)((apy)object2).an, f2 -> motorDriverCommand.controller().a().b(f2));
        MotorDriverController motorDriverController48 = this;
        object2 = apt2;
        object2 = ((apt)object2).a;
        motorDriverController48.bindField(motorDriverController48.focIdIClamp, (ReadOnlyDoubleProperty)((apy)object2).am, f2 -> motorDriverCommand.controller().a().f(f2));
        this.suggestFocGainsButton.disableProperty().bind((ObservableValue)this.focIdKp.getTextInput().disableProperty());
        this.suggestFocGainsButton.setOnAction(actionEvent -> {
            aps aps3 = aps2;
            Object object = aps3;
            object = aps2;
            double d2 = aps3.Q.get() / Math.max(((aps)object).P.get(), 1.0);
            long l2 = Math.round(d2 * 0.05);
            TextInputDialog textInputDialog = new TextInputDialog(String.valueOf(l2));
            textInputDialog.setHeaderText("The controller bandwidth defaults to 5% of the sampling frequency (" + uk.b(d2 / 1000.0) + " KHz).");
            textInputDialog.setContentText("Controller bandwidth [Hz]");
            Optional optional = textInputDialog.showAndWait();
            if (optional.isPresent()) {
                double d3 = TextUtil.parseDouble((String)optional.get());
                if (!Double.isFinite(d3)) {
                    asf.a((String)optional.get() + " is not a valid value.", ayo.a(actionEvent));
                    return;
                }
                aql aql3 = aql2;
                object = aql3;
                object = aql2;
                double d4 = d2;
                double d5 = (float)(((aql)object).ck.get() * 0.001);
                double d6 = aql3.cl.get();
                double d7 = 1.0 / d4;
                double d8 = d3 * (Math.PI * 2) * d7;
                double d9 = d6 * (d8 / (1.0 - Math.exp(-d6 * d7 / d5)));
                double d10 = 1.0 - Math.exp(-d6 * d7 / d5);
                atu atu2 = new atu(d9, d10);
                object = aql2;
                double d11 = ((aql)object).cd.get() * 0.1;
                this.focIqKp.setTextNullable(atu2.dg);
                this.focIqKi.setTextNullable(atu2.dh);
                this.focIqIClamp.setTextNullable(d11);
                if (this.showAdvancedToggle.isSelected()) {
                    this.focIdKp.setTextNullable(atu2.dg);
                    this.focIdKi.setTextNullable(atu2.dh);
                    this.focIdIClamp.setTextNullable(d11);
                }
            }
        });
        this.calibrateMotorEncoderBtn.disableProperty().bind((ObservableValue)this.motorEncoder.disabledProperty());
        this.calibrateMotorEncoderBtn.setOnAction(actionEvent -> this.dialogService.a(new MotorEncoderCalibrationDialog()).setOnResult(atz2 -> {}));
        this.calibrateAdcBtn.disableProperty().bind((ObservableValue)this.calibOffsetIa.getTextInput().disabledProperty());
        this.calibrateAdcBtn.setOnAction(actionEvent -> this.dialogService.a(new AdcCalibrationDialog()).setOnResult(ats2 -> {
            this.calibOffsetIa.setTextNullable(Float.valueOf(ats2.K));
            this.calibOffsetIb.setTextNullable(Float.valueOf(ats2.L));
            this.calibOffsetIc.setTextNullable(Float.valueOf(ats2.M));
            this.calibOffsetIBus.setTextNullable(Float.valueOf(ats2.N));
        }));
        ayo.a(() -> {
            if (!this.showAdvancedToggle.isSelected()) {
                this.focIdKp.setText(this.focIqKp.getText());
                this.focIdKi.setText(this.focIqKi.getText());
                this.focIdIClamp.setText(this.focIqIClamp.getText());
            }
        }, new Observable[]{this.showAdvancedToggle.selectedProperty(), this.focIqKp.textProperty(), this.focIqKi.textProperty(), this.focIqIClamp.textProperty()});
        MotorDriverController motorDriverController49 = this;
        object3 = apt2;
        motorDriverController49.bindEnumField(motorDriverController49.controlMode, (ReadOnlyObjectProperty)((apt)object3).k, (Consumer)ags2 -> motorDriverCommand.controller().a(ags2.a));
    }

    <E extends Enum<E>> void bindEnumField(HEnumInputField<E> hEnumInputField, ReadOnlyObjectProperty<E> readOnlyObjectProperty, Consumer<E> consumer) {
        Enum enum_ = MotorDriverController.getDefaultEnumValue((Enum)readOnlyObjectProperty.get());
        hEnumInputField.initValues(readOnlyObjectProperty, enum_);
        this.validation.registerValidator((Control)hEnumInputField.getChoiceBox(), false, ayb.a(hEnumInputField));
        this.onClear.add(hEnumInputField::clear);
        this.addInputList.add(() -> {
            Object e2 = hEnumInputField.getValue();
            if (e2 != null && e2 != enum_) {
                consumer.accept(e2);
            }
        });
    }

    private static <E extends Enum<E>> E getDefaultEnumValue(E e2) {
        if (e2 instanceof agq) {
            return (E)((Object)agq.a);
        }
        if (e2 instanceof agp) {
            return (E)((Object)agp.a);
        }
        if (e2 instanceof agu) {
            return (E)((Object)agu.a);
        }
        if (e2 instanceof agt) {
            return (E)((Object)agt.a);
        }
        if (e2 instanceof agv) {
            return (E)((Object)agv.a);
        }
        if (e2 instanceof agr) {
            return (E)((Object)agr.a);
        }
        if (e2 instanceof agn) {
            return (E)((Object)agn.a);
        }
        if (e2 instanceof ago) {
            return (E)((Object)ago.a);
        }
        if (e2 instanceof agm) {
            return (E)((Object)agm.a);
        }
        if (e2 instanceof ags) {
            return (E)((Object)ags.a);
        }
        throw new IllegalArgumentException("Unknown default type for: " + e2);
    }

    void bindField(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, amr amr2) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = ayb.a(customTextField, ParseUtils.FINITE_DOUBLE_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.validation.registerValidator((Control)customTextField, false, validator);
        this.addInputList.add(() -> {
            Double d2;
            if (!customTextField.getText().isBlank() && (d2 = ParseUtils.tryParseFiniteDouble(customTextField)) != null) {
                amr2.accept(d2.floatValue());
            }
        });
        this.onClear.add(() -> ((CustomTextField)customTextField).clear());
    }

    void bindIntField(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, IntConsumer intConsumer) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = ayb.a(customTextField, ParseUtils.INTEGER_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.validation.registerValidator((Control)customTextField, false, validator);
        this.addInputList.add(() -> {
            Integer n2;
            if (!customTextField.getText().isBlank() && (n2 = ParseUtils.tryParseInteger(customTextField.getText())) != null) {
                intConsumer.accept(n2);
            }
        });
        this.onClear.add(() -> ((CustomTextField)customTextField).clear());
    }

    public ToggleButton getPersistToggle() {
        return this.persistToggle;
    }
}

