/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ToggleButton;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.transform.TransformerException;
import okhttp3.Headers;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.controls.HEnumInputField;
import us.hebi.gui.lib.aee;
import us.hebi.gui.lib.afb;
import us.hebi.gui.lib.afc;
import us.hebi.gui.lib.afk;
import us.hebi.gui.lib.afl;
import us.hebi.gui.lib.afo;
import us.hebi.gui.lib.agj;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.ahq;
import us.hebi.gui.lib.aod;
import us.hebi.gui.lib.app;
import us.hebi.gui.lib.apz;
import us.hebi.gui.lib.aqo;
import us.hebi.gui.lib.aqq;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.atg;
import us.hebi.gui.lib.atl;
import us.hebi.gui.lib.auc;
import us.hebi.gui.lib.ayb;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.ayw;
import us.hebi.gui.lib.azf;
import us.hebi.gui.lib.bbd;
import us.hebi.gui.lib.bbf;
import us.hebi.gui.lib.v;
import us.hebi.gui.lib.zb;
import us.hebi.gui.lib.zd;
import us.hebi.gui.lib.ze;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.components.PidController;

public class GainsController {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Button loadFileBtn;
    @FXML
    private Button loadDefaultsBtn;
    @FXML
    private Button saveFileBtn;
    @FXML
    private Button sendBtn;
    @FXML
    private Button sendDirectBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private HEnumInputField<afc> controlStrategy;
    @FXML
    private HEnumInputField<agj> mStopStrategy;
    @FXML
    private HEnumInputField<ahg> posLimitStrategy;
    @FXML
    private Hyperlink docsLink;
    @FXML
    private Text docsText;
    @FXML
    private ToggleButton advancedToggle;
    @FXML
    private ToggleButton persistToggle;
    @FXML
    private HDoubleInputField minPosLimit;
    @FXML
    private HDoubleInputField maxPosLimit;
    @FXML
    private HDoubleInputField minVelLimit;
    @FXML
    private HDoubleInputField maxVelLimit;
    @FXML
    private HDoubleInputField minEffortLimit;
    @FXML
    private HDoubleInputField maxEffortLimit;
    @FXML
    private Parent positionPid;
    @FXML
    private PidController positionPidController;
    @FXML
    private Parent velocityPid;
    @FXML
    private PidController velocityPidController;
    @FXML
    private Parent effortPid;
    @FXML
    private PidController effortPidController;
    final ValidationSupport basicValidation = ayb.a();
    final ValidationSupport advancedValidation = ayb.a();
    @Inject
    aqt properties;
    @Inject
    atl module;
    @Inject
    auc fileChooser;
    @Inject
    atg moduleSelector;
    @Inject
    asy commandService;
    ahq reusableCommand;
    @Inject
    azf webViewer;
    private BooleanProperty advancedView;
    private final List<Runnable> clearers = new ArrayList<Runnable>();

    @FXML
    public void openGainsDocumentationInBrowser(ActionEvent actionEvent) {
        this.webViewer.showDocument("https://docs.hebi.us/core_concepts.html#motor_control");
    }

    @FXML
    private void sendGains(ActionEvent actionEvent) {
        ahg ahg2;
        agj agj2;
        ahq ahq2 = this.reusableCommand;
        ahq2.clear();
        afk afk2 = ahq2.getGains();
        if (this.persistToggle.isSelected()) {
            ahq2.setPersistAllFlag();
        }
        afb afb2 = ahq2.getSafetyLimits();
        GainsController.addSafetyLimit(this.minPosLimit, afb2::a);
        GainsController.addSafetyLimit(this.maxPosLimit, afb2::b);
        GainsController.addSafetyLimit(this.minVelLimit, afb2::c);
        GainsController.addSafetyLimit(this.maxVelLimit, afb2::d);
        GainsController.addSafetyLimit(this.minEffortLimit, afb2::e);
        GainsController.addSafetyLimit(this.maxEffortLimit, afb2::f);
        afc afc2 = this.controlStrategy.getValue();
        if (afc2 != null) {
            afk2.a(afc2);
        }
        if ((agj2 = this.mStopStrategy.getValue()) != null) {
            afk2.a(agj2);
        }
        if ((ahg2 = this.posLimitStrategy.getValue()) != null) {
            afb2.a(ahg2);
            afb2.b(ahg2);
        }
        this.positionPidController.addGainsToMessage(afk2);
        this.velocityPidController.addGainsToMessage(afk2);
        this.effortPidController.addGainsToMessage(afk2);
        this.moduleSelector.getSelectedAddresses().forEach(aee2 -> this.commandService.a((aee)aee2, ahq2));
    }

    private static void addSafetyLimit(HDoubleInputField hDoubleInputField, DoubleConsumer doubleConsumer) {
        if (!hDoubleInputField.getTextInput().isDisable() && hDoubleInputField.isInputValid()) {
            doubleConsumer.accept(hDoubleInputField.getInputValue());
        }
    }

    @FXML
    void clearAllFields(ActionEvent actionEvent) {
        this.positionPidController.clearAllTextFields();
        this.velocityPidController.clearAllTextFields();
        this.effortPidController.clearAllTextFields();
        this.controlStrategy.clear();
        this.mStopStrategy.clear();
        this.posLimitStrategy.clear();
        Iterator<Runnable> iterator = this.clearers.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> Optional<T[]> readGainsFile(Function<zd, T[]> function) {
        Window window = this.getActiveWindow();
        auc auc2 = this.fileChooser;
        auc2.a(auc2.c, "lastGainsChoiceDirectory");
        auc auc3 = auc2;
        File file = auc3.b(auc3.c.showOpenDialog(window), "lastGainsChoiceDirectory");
        if (file == null) {
            return Optional.empty();
        }
        T[] TArray = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            zd zd2 = zd.a(fileInputStream);
            TArray = function.apply(zd2);
            if (TArray.length != 0) return Optional.ofNullable(TArray);
            asf.a("Selected file did not contain gains", this.getActiveWindow());
            Optional<T[]> optional = Optional.empty();
            return optional;
        }
        catch (Exception exception) {
            asf.a(exception, this.getActiveWindow());
        }
        return Optional.ofNullable(TArray);
    }

    @FXML
    void loadDefaultGains(ActionEvent actionEvent) {
        if (this.module.isEmpty()) {
            return;
        }
        bbd bbd2 = bbd.a();
        afc afc2 = Optional.ofNullable(this.controlStrategy.getValue()).orElse(this.module.getGains().a());
        Headers headers = ayw.a(this.module.getInfo());
        CompletableFuture.supplyAsync(() -> {
            try {
                Headers headers2 = headers;
                String string = this.toStrategyUrlName(afc2);
                String string2 = this.module.getModule().c().toString();
                String string3 = bbf.a(bbd.b("gains", string, string2), headers2);
                return zd.a(new ByteArrayInputStream(string3.getBytes(v.a))).a();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }).whenCompleteAsync((aflArray, throwable) -> {
            if (throwable != null) {
                asf.a("Could not load default gains because the \nserver could not be reached, or because there are \nno default gains for the selected module and \nstrategy '" + afc2 + "'.", this.getActiveWindow());
                return;
            }
            if (((afl[])aflArray).length != 1) {
                asf.a("Could not load gains due to invalid source format.", this.getActiveWindow());
                return;
            }
            this.setGainFields(aflArray[0]);
        }, ayo.d);
    }

    private String toStrategyUrlName(afc afc2) {
        switch (afc2) {
            case d: {
                return "strategy2";
            }
            case e: {
                return "strategy3";
            }
            case f: {
                return "strategy4";
            }
            case g: {
                return "strategy5";
            }
        }
        return afc2.toString();
    }

    @FXML
    void loadFromFileAndSend(ActionEvent actionEvent) {
        ObservableList<aqq> observableList;
        int n2;
        if (!this.tryShowGroupGainsNotice()) {
            return;
        }
        Optional<T[]> optional = this.readGainsFile(zd::a);
        if (!optional.isPresent()) {
            return;
        }
        ahq[] ahqArray = (ahq[])optional.get();
        if (ahqArray.length != (n2 = (observableList = this.moduleSelector.getSelectedModules()).size())) {
            asf.a(String.format("Selected file contains %d modules, but %d modules are selected", ahqArray.length, n2), this.getActiveWindow());
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            aqq aqq2 = (aqq)observableList.get(i2);
            this.commandService.a(aqq2.a(), ahqArray[i2]);
        }
    }

    @FXML
    void loadFromFile(ActionEvent actionEvent) {
        afl afl2;
        Optional<T[]> optional = this.readGainsFile(zd::a);
        if (!optional.isPresent()) {
            return;
        }
        afl[] aflArray = (afl[])optional.get();
        if (aflArray.length > 1) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i2 = 0; i2 < aflArray.length; ++i2) {
                arrayList.add(i2 + 1);
            }
            ChoiceDialog choiceDialog = new ChoiceDialog((Object)1, arrayList);
            choiceDialog.setTitle("Group Gain Selector");
            choiceDialog.setHeaderText("File contains gains for more than one device");
            choiceDialog.setContentText("Choose device index:");
            choiceDialog.initOwner(this.getActiveWindow());
            Optional optional2 = choiceDialog.showAndWait();
            if (!optional2.isPresent()) {
                return;
            }
            afl2 = aflArray[(Integer)optional2.get() - 1];
        } else {
            afl2 = aflArray[0];
        }
        this.setGainFields(afl2);
    }

    private void setGainFields(afl afl2) {
        afc afc2 = afl2.a();
        if (afc2 == afc.a) {
            afc2 = null;
        }
        this.controlStrategy.setValue(afc2);
        this.positionPidController.setTextFields(afl2);
        this.velocityPidController.setTextFields(afl2);
        this.effortPidController.setTextFields(afl2);
    }

    @FXML
    void saveGainsToFile(ActionEvent actionEvent) {
        if (this.moduleSelector.getSelectedModules().size() == 0) {
            return;
        }
        if (!this.tryShowGroupGainsNotice()) {
            return;
        }
        File file = this.fileChooser.e(this.getActiveWindow());
        if (file == null) {
            return;
        }
        ze ze2 = ze.a((afo[])this.moduleSelector.getSelectedModules().stream().map(aqq::getInfo).toArray(afo[]::new));
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ze2.a(fileOutputStream);
            return;
        }
        catch (IOException | TransformerException exception) {
            asf.a(exception, this.getActiveWindow());
            return;
        }
    }

    private boolean tryShowGroupGainsNotice() {
        if (!this.moduleSelector.selectionMultiple().get()) {
            return true;
        }
        return asf.a("Gains from multiple modules are stored in a single file.\nWhen loading or saving gains from multiple modules, \nthe order within the file will match the selection order.", this.getActiveWindow());
    }

    private Window getActiveWindow() {
        return this.controlStrategy.getScene().getWindow();
    }

    @FXML
    void initialize() {
        this.advancedToggle.setSelected(this.properties.m.get());
        this.properties.m.bind((ObservableValue)this.advancedToggle.selectedProperty());
        this.persistToggle.setSelected(this.properties.s.get());
        this.properties.s.bind((ObservableValue)this.persistToggle.selectedProperty());
        this.positionPidController.initialize(zb.a, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        this.velocityPidController.initialize(zb.b, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        this.effortPidController.initialize(zb.c, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        aod.c((Node)this.advancedToggle, ayb.a(this.advancedValidation));
        aod.b((Node)this.advancedToggle, ayb.b(this.advancedValidation));
        aod.a((Node)this.sendBtn, ayb.b(this.basicValidation), ayb.b(this.advancedValidation));
        Object object = this.module.getGains();
        this.controlStrategy.initValues((ReadOnlyObjectProperty<afc>)((apz)object).u, afc.a);
        this.basicValidation.registerValidator((Control)this.controlStrategy.getChoiceBox(), false, ayb.a(this.controlStrategy));
        Object object2 = this.module.getGains();
        this.mStopStrategy.initValues((ReadOnlyObjectProperty<agj>)((apz)object2).v, agj.a);
        this.basicValidation.registerValidator((Control)this.mStopStrategy.getChoiceBox(), false, ayb.a(this.mStopStrategy));
        object2 = this.module.getSafetyLimits();
        this.posLimitStrategy.initValues((ReadOnlyObjectProperty<ahg>)((aqo)object2).F, ahg.a);
        this.basicValidation.registerValidator((Control)this.posLimitStrategy.getChoiceBox(), false, ayb.a(this.posLimitStrategy));
        GainsController gainsController = this;
        aqo aqo2 = this.module.getSafetyLimits();
        object = aqo2;
        object = this.module.getFeedback();
        gainsController.initializeSafetyLimit(gainsController.minPosLimit, (ReadOnlyDoubleProperty)aqo2.cq, (ReadOnlyDoubleProperty)((app)object).y);
        GainsController gainsController2 = this;
        aqo aqo3 = this.module.getSafetyLimits();
        object = aqo3;
        object = this.module.getFeedback();
        gainsController2.initializeSafetyLimit(gainsController2.maxPosLimit, (ReadOnlyDoubleProperty)aqo3.cn, (ReadOnlyDoubleProperty)((app)object).y);
        GainsController gainsController3 = this;
        aqo aqo4 = this.module.getSafetyLimits();
        object = aqo4;
        object = this.module.getFeedback();
        gainsController3.initializeSafetyLimit(gainsController3.minVelLimit, (ReadOnlyDoubleProperty)aqo4.cr, (ReadOnlyDoubleProperty)((app)object).D);
        GainsController gainsController4 = this;
        aqo aqo5 = this.module.getSafetyLimits();
        object = aqo5;
        object = this.module.getFeedback();
        gainsController4.initializeSafetyLimit(gainsController4.maxVelLimit, (ReadOnlyDoubleProperty)aqo5.co, (ReadOnlyDoubleProperty)((app)object).D);
        GainsController gainsController5 = this;
        aqo aqo6 = this.module.getSafetyLimits();
        object = aqo6;
        object = this.module.getFeedback();
        gainsController5.initializeSafetyLimit(gainsController5.minEffortLimit, (ReadOnlyDoubleProperty)aqo6.cp, (ReadOnlyDoubleProperty)((app)object).h);
        GainsController gainsController6 = this;
        aqo aqo7 = this.module.getSafetyLimits();
        object = aqo7;
        object = this.module.getFeedback();
        gainsController6.initializeSafetyLimit(gainsController6.maxEffortLimit, (ReadOnlyDoubleProperty)aqo7.cm, (ReadOnlyDoubleProperty)((app)object).h);
        this.sendBtn.setOnAction(this::sendGains);
        this.sendBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty().or((ObservableBooleanValue)this.basicValidation.invalidProperty()).or((ObservableBooleanValue)this.advancedValidation.invalidProperty()));
        this.saveFileBtn.setOnAction(this::saveGainsToFile);
        this.saveFileBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.loadDefaultsBtn.setOnAction(this::loadDefaultGains);
        this.loadDefaultsBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.loadFileBtn.setOnAction(this::loadFromFile);
        this.loadFileBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.sendDirectBtn.setOnAction(this::loadFromFileAndSend);
        this.sendDirectBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.clearBtn.setOnAction(this::clearAllFields);
    }

    private void initializeSafetyLimit(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, ReadOnlyDoubleProperty readOnlyDoubleProperty2) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        hDoubleInputField.setShowTarget(true);
        hDoubleInputField.setTargetSupplier(() -> ((ReadOnlyDoubleProperty)readOnlyDoubleProperty2).get());
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = ayb.a(customTextField, ParseUtils.NON_NAN_DOUBLE_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.basicValidation.registerValidator((Control)customTextField, false, validator);
        this.clearers.add(() -> ((CustomTextField)customTextField).clear());
    }

    @PostConstruct
    public void postConstruct() {
        this.reusableCommand = asy.b();
        this.advancedView = this.properties.m;
    }
}

