/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.rima;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.dataset.DataSet;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Box;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;
import javax.inject.Inject;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.ame;
import us.hebi.gui.lib.anc;
import us.hebi.gui.lib.aof;
import us.hebi.gui.lib.aog;
import us.hebi.gui.lib.apc;
import us.hebi.gui.lib.apd;
import us.hebi.gui.lib.apg;
import us.hebi.gui.lib.apn;
import us.hebi.gui.lib.apo;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.arn;
import us.hebi.gui.lib.aru;
import us.hebi.gui.lib.arw;
import us.hebi.gui.lib.ary;
import us.hebi.gui.lib.auc;
import us.hebi.gui.lib.auz;
import us.hebi.gui.lib.avc;
import us.hebi.gui.lib.awf;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.bad;

public class RimaPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Pane root;
    @FXML
    private Pane pane3d;
    @FXML
    private Pane pane2d;
    @FXML
    private Pane panePaut;
    @FXML
    private Pane paneControls;
    @FXML
    private Pane paneChart;
    @FXML
    private ImageView pautView;
    @FXML
    private CheckBox selectionEnabled;
    @FXML
    private CheckBox selectionFlipped;
    @FXML
    private Slider colorSliderMin;
    @FXML
    private Slider colorSliderMax;
    @FXML
    private Slider smartMinSlider;
    @FXML
    private Button saveGridImgButton;
    @FXML
    private Button saveRawImgButton;
    apd mappedSurface = null;
    apc gridData = new apc();
    aog mappedPoint = new aog();
    final Property<apg> surfaceMap = new SimpleObjectProperty();
    final arn surface3d = new arn();
    final arn probeMesh = new arn();
    final Box probeModel = new bad();
    final arw probe3d;
    final ary world;
    static final double PROBE_SIZE_M = 0.053;
    avc chartTrace;
    XYChart chart;
    @Inject
    aqt properties;
    @Inject
    aof MAPS;
    @Inject
    apo tfmImageAnalysis;
    @Inject
    auc fileChooser;

    public RimaPresenter() {
        this.probe3d = new arw(new Node[]{this.probeMesh.c, this.probeModel, aru.a(10.0)});
        this.world = new ary(new Node[]{this.surface3d.c, this.probe3d}).a();
        this.chartTrace = avc.a("depth", 1000, new String[0]);
        this.chart = new XYChart();
        this.chart.getPlugins().add((Object)auz.a());
        this.chart.setLegendVisible(false);
        this.chartTrace.addStyleClasses(new String[]{awf.c.F()});
        this.chart.getRenderers().setAll((Object[])new Renderer[]{auz.a()});
        this.chart.getDatasets().add((Object)this.chartTrace);
        Axis axis = this.chart.getFirstAxis(Orientation.HORIZONTAL);
        axis.setUnit("mm");
        axis.setName("x");
        axis.setTickUnit(10.0);
        axis.setAutoRanging(false);
        axis.setAutoGrowRanging(false);
        Axis axis2 = this.chart.getFirstAxis(Orientation.VERTICAL);
        axis2.setUnit("mm");
        axis2.setName("z");
        axis2.setTickUnit(5.0);
        axis2.setAutoRanging(false);
        axis2.setAutoGrowRanging(false);
        axis.set(0.0, anc.a.f(0.053));
        axis2.set(0.0, 20.0);
    }

    @FXML
    void initialize() throws IOException {
        ayo.b(this::initializeOnFxThread);
    }

    private void initializeOnFxThread() {
        ayo.a(bl2 -> {
            if (!bl2) {
                apc apc2 = this.gridData;
                if (!apc2.aG()) {
                    Arrays.fill(apc2.aI, 0, apc2.j(), 0);
                    Arrays.fill(apc2.d, 0, apc2.j(), false);
                    apc2.aB = false;
                    apc2.aC = false;
                    apc2.a.br();
                    apc2.a.a();
                }
                this.gridData.a(this.mappedSurface);
            }
        }, (ObservableBooleanValue)this.selectionEnabled.selectedProperty());
        ayo.a(d2 -> {
            double d3 = d2;
            apc apc2 = this.gridData;
            this.gridData.a.dE = d3;
            apc2.aC = true;
            this.gridData.aZ();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.colorSliderMin.valueProperty());
        ayo.a(d2 -> {
            double d3 = d2;
            apc apc2 = this.gridData;
            this.gridData.a.F = d3;
            apc2.aC = true;
            this.gridData.aZ();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.colorSliderMax.valueProperty());
        ayo.a(d2 -> {
            apc apc2 = this.gridData;
            apc2.cx = d2 < 0.0 ? 0.0 : (d2 > 100.0 ? 1.0 : d2 / 100.0);
            apc2.aC = true;
            this.gridData.aZ();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.smartMinSlider.valueProperty());
        this.probeMesh.d.diffuseMapProperty().bind((ObservableValue)this.pautView.imageProperty());
        this.probeMesh.e.diffuseMapProperty().bind((ObservableValue)this.pautView.imageProperty());
        this.tfmImageAnalysis.f(this::updatePlots);
        this.paneChart.getChildren().add((Object)this.chart);
        ayo.c(this.chart);
        this.world.a(this.pane3d);
        Optional.ofNullable(RimaPresenter.class.getResource("assets/aluminum-dark.jpg")).map(URL::toExternalForm).map(Image::new).ifPresent(this.surface3d::a);
        this.MAPS.c(this.probe3d::b);
        this.MAPS.d(aog2 -> {
            this.mappedPoint.a((aog)aog2);
            if (this.mappedSurface != null) {
                this.mappedSurface.a((aog)aog2, 0.053);
            }
        });
        this.MAPS.b(apg2 -> {
            this.surfaceMap.setValue(apg2);
            this.surface3d.a((Mesh)apg2.a());
            Point3D point3D = aa.a((Mesh)apg2.a());
            ayo.a((Node)this.world.d, point3D);
            this.mappedSurface = apd.a(apg2, 800.0, 400.0);
            this.surface3d.d.diffuseMapProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.selectionFlipped.selectedProperty()).then(this.mappedSurface.b).otherwise(this.mappedSurface.a));
            this.surface3d.e.diffuseMapProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.selectionFlipped.selectedProperty()).then(this.mappedSurface.a).otherwise(this.mappedSurface.b));
            this.pane2d.getChildren().setAll((Object[])new Node[]{this.mappedSurface.a});
            apc apc2 = this.gridData;
            this.gridData.cw = 0.001;
            apc2.resize();
            apg apg3 = apg2;
            apc2 = this.gridData;
            this.gridData.b = apg3;
            apc2.resize();
            this.mappedSurface.m(0.01);
        });
        CompletableFuture.runAsync(() -> ame.b(1L, TimeUnit.SECONDS)).thenRun(this.MAPS::a);
    }

    public void updatePlots(apn apn2) {
        TriangleMesh triangleMesh;
        if (apn2.a != null) {
            triangleMesh = apn2.a;
            Point3D point3D = aa.a((Mesh)triangleMesh);
            this.probeMesh.c.setTranslateX(-point3D.getX());
            this.probeMesh.c.setRotationAxis(Rotate.Z_AXIS);
            this.probeMesh.c.setRotate(-90.0);
            this.probeMesh.a((Mesh)triangleMesh);
        }
        if (apn2.aD) {
            apn apn3 = apn2;
            triangleMesh = (apn3.aD ? apn3.c : apn3.b).a;
            this.pautView.setImage((Image)triangleMesh);
        }
        this.chartTrace.bJ();
        if (apn2.P() > 0) {
            apn2.a(this.chartTrace::d);
            this.chartTrace.bI();
            if (this.mappedPoint.isInContact() && this.selectionEnabled.isSelected()) {
                apn2.a(this::addProbeMeasurement);
                this.gridData.aZ();
                this.gridData.a(this.mappedSurface);
            }
        }
        this.chart.getDatasets().setAll((Object[])new DataSet[]{this.chartTrace});
    }

    private void addProbeMeasurement(double d2, double d3) {
        double d4 = d2 / 1000.0 - 0.0265;
        if (this.selectionFlipped.isSelected()) {
            d4 = -d4;
        }
        double d5 = d4 * this.mappedPoint.ck + (double)this.mappedPoint.o;
        double d6 = d4 * this.mappedPoint.cl + (double)this.mappedPoint.p;
        double d7 = d3;
        double d8 = d6;
        double d9 = d5;
        apc apc2 = this.gridData;
        if (!apc2.aG()) {
            int n2;
            int n3 = (int)(apc2.b.m(d9) * (double)apc2.ad);
            int n4 = (int)(apc2.b.n(d8) * (double)apc2.ac);
            if (n4 < 0 || n3 < 0 || n4 >= apc2.ac || n3 >= apc2.ad) {
                return;
            }
            int n5 = n3;
            int n6 = n4;
            apc apc3 = apc2;
            int n7 = n2 = n6 * apc3.ad + n5;
            int n8 = apc2.aI[n7];
            apc2.aI[n7] = n8 + 1;
            int n9 = n8 % 32;
            int n10 = n2;
            apc2.w[(n10 << 5) + n9] = d7;
            apc2.d[n2] = true;
            apc2.aB = true;
        }
    }
}

