/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components.dialogs;

import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javax.inject.Inject;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.lib.aof;
import us.hebi.gui.lib.aoh;
import us.hebi.gui.lib.aoi;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.axy;
import us.hebi.gui.lib.ayb;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.ays;
import us.hebi.gui.lib.azj;
import us.hebi.gui.lib.bbj;
import us.hebi.gui.lib.bbl;
import us.hebi.gui.lib.bbn;
import us.hebi.gui.lib.bbo;
import us.hebi.gui.lib.bbp;
import us.hebi.gui.lib.bxj;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.scope.components.ParseUtils;

public class FlatWizardController
extends axy {
    @FXML
    private ToggleButton bottomLeft;
    @FXML
    private ToggleButton bottomRight;
    @FXML
    private Button closeBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private Button generateBtn;
    @FXML
    private StackPane rectangleLines;
    @FXML
    private AnchorPane root;
    @FXML
    private ToggleButton topLeft;
    @FXML
    private ToggleButton topRight;
    @FXML
    private TextField paddingField;
    final IntegerProperty numSelectedPoints = new SimpleIntegerProperty(0);
    final BooleanBinding needsMorePoints = this.numSelectedPoints.lessThan(3);
    @Inject
    aof maps;
    @Inject
    aoi registration;
    @Inject
    asg notification;
    @Inject
    MapsAppState state;

    @Override
    public void initializeFx() {
        azj.g((Parent)this.root);
        ValidationSupport validationSupport = ayb.a();
        validationSupport.registerValidator((Control)this.paddingField, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        this.state.addUnitFields(this.paddingField);
        ayo.a(() -> {
            this.generateBtn.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, !this.needsMorePoints.get());
            this.rectangleLines.pseudoClassStateChanged(MapsCss.SELECTED, !this.needsMorePoints.get());
        }, new Observable[]{this.needsMorePoints});
        FlatWizardController flatWizardController = this;
        bbl bbl2 = flatWizardController.setupToggleButton(flatWizardController.topLeft, ays.k);
        FlatWizardController flatWizardController2 = this;
        bbl bbl3 = flatWizardController2.setupToggleButton(flatWizardController2.topRight, ays.l);
        FlatWizardController flatWizardController3 = this;
        bbl bbl4 = flatWizardController3.setupToggleButton(flatWizardController3.bottomLeft, ays.m);
        FlatWizardController flatWizardController4 = this;
        bbl bbl5 = flatWizardController4.setupToggleButton(flatWizardController4.bottomRight, ays.n);
        this.generateBtn.disableProperty().bind((ObservableValue)this.needsMorePoints.or((ObservableBooleanValue)validationSupport.invalidProperty()));
        this.generateBtn.setOnAction(actionEvent -> {
            this.registration.aX();
            if (!this.topLeft.isSelected()) {
                bbl2.c(this.deriveWaypointAndAddMarkers(bbl3, bbl4, bbl5));
            } else if (!this.topRight.isSelected()) {
                bbl3.c(this.deriveWaypointAndAddMarkers(bbl2, bbl5, bbl4));
            } else if (!this.bottomLeft.isSelected()) {
                bbl4.c(this.deriveWaypointAndAddMarkers(bbl2, bbl5, bbl3));
            } else if (!this.bottomRight.isSelected()) {
                bbl5.c(this.deriveWaypointAndAddMarkers(bbl4, bbl3, bbl2));
            }
            bbo bbo2 = bbl2.a().a(bbl3.a()).b();
            bbo bbo3 = bbl2.a().a(bbl4.a()).b();
            double d2 = this.state.getUnits().e(Optional.ofNullable(ParseUtils.tryParseDouble(this.paddingField.getText())).orElse(0.0));
            bbo bbo4 = bbo2.c().a(d2);
            bbo bbo5 = bbo3.c().a(d2);
            bbo bbo6 = bbo2.c().a(-d2);
            bbo bbo7 = bbo3.c().a(-d2);
            bbl bbl7 = bbl2.d().a(bbo4).a(bbo5);
            bbl bbl8 = bbl3.d().a(bbo6).a(bbo5);
            bbl bbl9 = bbl4.d().a(bbo4).a(bbo7);
            bbl bbl10 = bbl5.d().a(bbo6).a(bbo7);
            bbl[] bblArray = new bbl[9];
            bblArray[0] = bbl7.d();
            bbl bbl11 = bbl8;
            bbl bbl12 = bbl7;
            bblArray[1] = bbn.a(bbl12, bbl11);
            bblArray[2] = bbl8.d();
            bbl11 = bbl9;
            bbl12 = bbl7;
            bblArray[3] = bbn.a(bbl12, bbl11);
            bbl11 = bbl10;
            bbl12 = bbl7;
            bblArray[4] = bbn.a(bbl12, bbl11);
            bbl11 = bbl10;
            bbl12 = bbl8;
            bblArray[5] = bbn.a(bbl12, bbl11);
            bblArray[6] = bbl9.d();
            bbl11 = bbl10;
            bbl12 = bbl9;
            bblArray[7] = bbn.a(bbl12, bbl11);
            bblArray[8] = bbl10.d();
            aoh aoh2 = new aoh(bblArray);
            bbo bbo8 = bbo3;
            bbo bbo9 = bbp.a(bbo2, bbo8, bbo.d()).b();
            bbp.a(bbo9, bbo2, bbo3);
            aoh2.e(bbl2 -> bbl2.a(bbo2.a1, bbo3.a1, bbo4.a1, bbo2.a2, bbo3.a2, bbo4.a2, bbo2.a3, bbo3.a3, bbo4.a3));
            this.registration.a(aoh2);
            this.closeBtn.getOnAction().handle(actionEvent);
        });
        this.clearBtn.disableProperty().bind((ObservableValue)this.numSelectedPoints.isEqualTo(0));
        this.clearBtn.setOnAction(actionEvent -> {
            this.topLeft.setSelected(false);
            this.topRight.setSelected(false);
            this.bottomLeft.setSelected(false);
            this.bottomRight.setSelected(false);
            this.paddingField.setText("0");
        });
    }

    private bbl deriveWaypointAndAddMarkers(bbl bbl2, bbl bbl3, bbl bbl4) {
        this.registration.a(bbl2, bbl3, bbl4);
        bbl bbl5 = bbl.c();
        bbl[] bblArray = new bbl[]{bbl2, bbl3, bbl4};
        bxj.e(true, "need at least one transform");
        bbj bbj2 = new bbj();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        bbl[] bblArray2 = bblArray;
        for (int i2 = 0; i2 < 3; ++i2) {
            bblArray2[i2].a(bbj2);
            d2 += bbj2.cy;
            d3 += bbj2.dw;
            d4 += bbj2.dx;
            d5 += bbj2.dJ;
        }
        bbj2.cy = d2 / 3.0;
        bbj2.dw = d3 / 3.0;
        bbj2.dx = d4 / 3.0;
        bbj2.dJ = d5 / 3.0;
        bbj2.cm();
        bbl5.a(bbj2);
        bbl5.dL = bbl2.dL + bbl3.dL - bbl4.dL;
        bbl5.dN = bbl2.dN + bbl3.dN - bbl4.dN;
        bbl5.dR = bbl2.dR + bbl3.dR - bbl4.dR;
        return bbl5;
    }

    private bbl setupToggleButton(ToggleButton toggleButton, KeyCombination keyCombination) {
        toggleButton.visibleProperty().bind((ObservableValue)toggleButton.selectedProperty().or((ObservableBooleanValue)this.needsMorePoints));
        bbl bbl2 = bbl.c();
        toggleButton.selectedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                bbl2.c(this.maps.a);
                this.numSelectedPoints.set(this.numSelectedPoints.get() + 1);
                return;
            }
            this.numSelectedPoints.set(this.numSelectedPoints.get() - 1);
        });
        ays.a((Node)toggleButton, keyCombination, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (!ayo.a((Node)toggleButton)) {
                return;
            }
            ayo.a(toggleButton.selectedProperty());
        }));
        return bbl2;
    }

    public Button getCloseButton() {
        return this.closeBtn;
    }

    public MapsAppState getState() {
        return this.state;
    }
}

