/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps;

import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.scene.control.TextField;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import us.hebi.gui.lib.aly;
import us.hebi.gui.lib.anc;
import us.hebi.gui.lib.aqx;
import us.hebi.gui.lib.ayx;
import us.hebi.gui.lib.fc;
import us.hebi.gui.views.maps.MapsAppState$View;
import us.hebi.gui.views.maps.hrdf.RobotSource;
import us.hebi.gui.views.scope.components.ParseUtils;

public class MapsAppState
extends aqx {
    private static final StringBuilder tmpBuilder = new StringBuilder();
    private static final aly numberFormat = aly.a();
    private final StringProperty unitLabel = this.getString("units", "mm");
    private final ObjectBinding<anc> units = Bindings.createObjectBinding(() -> {
        switch ((String)this.unitLabel.get()) {
            case "mm": {
                return anc.b;
            }
            case "in": {
                return anc.c;
            }
        }
        return anc.a;
    }, (Observable[])new Observable[]{this.unitLabel});
    private final DoubleBinding metersToSelectedUnits = Bindings.createDoubleBinding(() -> 1.0 / ((anc)((Object)((Object)this.units.get()))).e(1.0), (Observable[])new Observable[]{this.units});
    private final DoubleProperty probeWidth = new SimpleDoubleProperty(0.0);
    private final StringProperty mapsAddress = this.getString("address", "10.10.1.2");
    private final StringProperty logDirectory = this.getString("logDirectory", "");
    private final ObjectProperty<RobotSource> positionSource = this.getObject("positionSource", RobotSource.MAPS_7dof_short, RobotSource.STRING_CONVERTER);
    private final IntegerProperty selectedProbeIndex = this.getInt("selectedProbeIndex", 0);
    private final BooleanProperty showBuiltinSources = this.getBoolean("showBuiltinSources", true);
    private final BooleanProperty showCustomSources = this.getBoolean("showCustomSources", true);
    private final BooleanProperty showCustomProbes = this.getBoolean("showCustomProbes", true);
    private Consumer<MapsAppState$View> onViewFinished;
    private Consumer<MapsAppState$View> onViewCancel;
    private final ObjectProperty<MapsAppState$View> activeView = new SimpleObjectProperty((Object)MapsAppState$View.Configuration);
    private final BooleanProperty showLiveMap = this.getBoolean("enableLiveView", true);
    private final BooleanProperty showInternalOptions = this.getBoolean("showInternalOptions", false);
    private final BooleanProperty enableNavigation = this.getBoolean("enableNavigation", false);
    private final BooleanProperty enableMapRequest = this.getBoolean("enableMapRequest", false);
    private final DoubleProperty soundVelocity = this.getDouble("soundVelocity", 5870.0);
    @Inject
    ayx pathResolver;

    public void nextView(ActionEvent actionEvent) {
        this.onViewFinished.accept(this.getActiveView());
    }

    public void previousView(ActionEvent actionEvent) {
        this.onViewCancel.accept(this.getActiveView());
    }

    public boolean isOnView(MapsAppState$View mapsAppState$View) {
        return this.getActiveView() == mapsAppState$View;
    }

    public MapsAppState$View getActiveView() {
        return (MapsAppState$View)((Object)this.activeView.get());
    }

    public ObjectProperty<MapsAppState$View> activeViewProperty() {
        return this.activeView;
    }

    public void setActiveView(MapsAppState$View mapsAppState$View) {
        this.activeView.set((Object)mapsAppState$View);
    }

    public void addUnitFields(TextField ... textFieldArray) {
        TextField[] textFieldArray2 = textFieldArray;
        int n2 = textFieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextField textField = textFieldArray2[i2];
            this.addUnitField(textField.textProperty());
        }
    }

    public void addUnitField(StringProperty stringProperty) {
        this.units.addListener((observableValue, anc2, anc3) -> this.changeUnits(stringProperty, (anc)((Object)anc2), (anc)((Object)anc3)));
    }

    private void changeUnits(StringProperty stringProperty, anc anc2, anc anc3) {
        if (anc2 == null || anc3 == null) {
            return;
        }
        double d2 = anc2.e(1.0) / anc3.e(1.0);
        Double d3 = ParseUtils.tryParseDouble((String)stringProperty.get());
        if (d3 == null) {
            return;
        }
        stringProperty.set((Object)this.formatNumber(d3 * d2));
    }

    private String formatNumber(double d2) {
        tmpBuilder.setLength(0);
        StringBuilder stringBuilder = tmpBuilder;
        aly aly2 = numberFormat;
        int n2 = stringBuilder.length();
        if (Double.isNaN(d2)) {
            stringBuilder.append("NaN");
        } else if (Double.isInfinite(d2)) {
            stringBuilder.append(d2 == Double.POSITIVE_INFINITY ? "Inf" : "-Inf");
        } else {
            aly2.l(d2);
            aly2.aM();
            stringBuilder.append((CharSequence)aly2.g);
        }
        tmpBuilder.setLength(stringBuilder.length() - n2);
        return tmpBuilder.toString();
    }

    public double getProbeWidth() {
        return this.probeWidth.get();
    }

    public DoubleProperty probeWidthProperty() {
        return this.probeWidth;
    }

    public void setProbeWidth(double d2) {
        this.probeWidth.set(d2);
    }

    public String getUnitLabel() {
        return (String)this.unitLabel.get();
    }

    public StringProperty unitLabelProperty() {
        return this.unitLabel;
    }

    public void setUnitLabel(String string) {
        this.unitLabel.set((Object)string);
    }

    public anc getUnits() {
        return (anc)((Object)this.units.get());
    }

    public ObjectBinding<anc> unitsProperty() {
        return this.units;
    }

    public double getMetersToSelectedUnits() {
        return this.metersToSelectedUnits.get();
    }

    public DoubleBinding metersToSelectedUnitsProperty() {
        return this.metersToSelectedUnits;
    }

    public String getMapsAddress() {
        return (String)this.mapsAddress.get();
    }

    public StringProperty mapsAddressProperty() {
        return this.mapsAddress;
    }

    public void setMapsAddress(String string) {
        this.mapsAddress.set((Object)string);
    }

    public RobotSource getPositionSource() {
        return (RobotSource)this.positionSource.get();
    }

    public ObjectProperty<RobotSource> positionSourceProperty() {
        return this.positionSource;
    }

    public void setPositionSource(RobotSource robotSource) {
        this.positionSource.set((Object)robotSource);
    }

    public int getSelectedProbeIndex() {
        return this.selectedProbeIndex.get();
    }

    public IntegerProperty selectedProbeIndexProperty() {
        return this.selectedProbeIndex;
    }

    public void setSelectedProbeIndex(int n2) {
        this.selectedProbeIndex.set(n2);
    }

    public boolean getShowLiveMap() {
        return this.showLiveMap.get();
    }

    public BooleanProperty showLiveMapProperty() {
        return this.showLiveMap;
    }

    public void setShowLiveMap(boolean bl2) {
        this.showLiveMap.set(bl2);
    }

    public boolean isShowInternalOptions() {
        return this.showInternalOptions.get();
    }

    public void setShowInternalOptions(boolean bl2) {
        this.showInternalOptions.set(bl2);
    }

    public BooleanProperty showInternalOptionsProperty() {
        return this.showInternalOptions;
    }

    public BooleanProperty enableNavigationProperty() {
        return this.enableNavigation;
    }

    public BooleanProperty enableMapRequestProperty() {
        return this.enableMapRequest;
    }

    public String getLogDirectory() {
        return (String)this.logDirectory.get();
    }

    public StringProperty logDirectoryProperty() {
        return this.logDirectory;
    }

    public void setLogDirectory(String string) {
        this.logDirectory.set((Object)string);
    }

    public void resetLogDirectory() {
        MapsAppState mapsAppState = this;
        mapsAppState.setLogDirectory(mapsAppState.pathResolver.b("logs").toString());
    }

    public double getSoundVelocity() {
        return this.soundVelocity.get();
    }

    public DoubleProperty soundVelocityProperty() {
        return this.soundVelocity;
    }

    public void setSoundVelocity(double d2) {
        this.soundVelocity.set(d2);
    }

    public boolean isShowBuiltinSources() {
        return this.showBuiltinSources.get();
    }

    public BooleanProperty showBuiltinSourcesProperty() {
        return this.showBuiltinSources;
    }

    public boolean isShowCustomSources() {
        return this.showCustomSources.get();
    }

    public BooleanProperty showCustomSourcesProperty() {
        return this.showCustomSources;
    }

    public boolean isShowCustomProbes() {
        return this.showCustomProbes.get();
    }

    public BooleanProperty showCustomProbesProperty() {
        return this.showCustomProbes;
    }

    public MapsAppState() {
        if (!fc.b(this.getMapsAddress())) {
            this.mapsAddress.set((Object)"10.10.1.2");
        }
    }

    @PostConstruct
    public void init() {
        this.resetLogDirectory();
        if (((String)this.logDirectory.get()).isEmpty()) {
            this.resetLogDirectory();
        }
    }

    public void setOnViewFinished(Consumer<MapsAppState$View> consumer) {
        this.onViewFinished = consumer;
    }

    public void setOnViewCancel(Consumer<MapsAppState$View> consumer) {
        this.onViewCancel = consumer;
    }
}

