/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import us.hebi.core.messages.flat.FlatFeedback;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.avr;
import us.hebi.gui.lib.awf;
import us.hebi.gui.lib.jh;
import us.hebi.gui.views.logviewer.hebilog.GroupFeedbackHandler;
import us.hebi.gui.views.logviewer.state.ChartCategory;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class HebiLogFeedback
implements GroupFeedbackHandler {
    int prevTimeIndex = 0;
    int numJoints = -1;
    int maxEntries = -1;
    public jh time;
    private double[] timeLookup;
    public jh[] positionCmd;
    public jh[] velocityCmd;
    public jh[] effortCmd;
    public jh[] position;
    public jh[] velocity;
    public jh[] effort;
    public jh[] pwmCmd;
    public jh[] voltage;
    public jh[] motorCurrent;
    public jh[] windingTemperature;
    public jh[] rxSequence;
    public jh[] deflection;
    public jh[] innerEncoderPosition;
    public jh[] motorPosition;
    public jh[] motorVelocity;
    public jh[] gyroX;
    public jh[] gyroY;
    public jh[] gyroZ;
    public jh[] pressure;
    public jh[] focIdCmd;
    public jh[] focId;
    public jh[] focIqCmd;
    public jh[] focIq;
    public jh[] focVdCmd;
    public jh[] focVd;
    public jh[] focVqCmd;
    public jh[] focVq;
    public jh[] phaseCurrentA;
    public jh[] phaseCurrentB;
    public jh[] phaseCurrentC;
    public jh[] phaseVoltageA;
    public jh[] phaseVoltageB;
    public jh[] phaseVoltageC;
    public jh[] phaseDutyCycleA;
    public jh[] phaseDutyCycleB;
    public jh[] phaseDutyCycleC;
    public jh[] hallState;
    double integratedTotalPower = 0.0;
    public jh[] power;
    public jh[] systemPower;
    public jh[] roundTripTime;
    public jh[] hwResponseTime;
    public jh[] transmitTimeDelta;
    public jh[] packetLoss;
    public jh[] totalPacketLoss;
    public jh[] springStiffness;
    public jh[] firstOrientation;
    public jh[] firstAccel;

    public int getIndexAt(double d2) {
        this.prevTimeIndex = aa.a(this.timeLookup, this.timeLookup.length - 1, d2, this.prevTimeIndex);
        return this.prevTimeIndex;
    }

    public int getNumJoints() {
        return this.numJoints;
    }

    public HebiLogFeedback() {
        this.init(0, 8192);
    }

    public HebiLogFeedback init(int n2, int n3) {
        this.numJoints = n2;
        this.maxEntries = n3;
        this.resize();
        return this;
    }

    @Override
    public void init(int n2) {
        this.init(n2, this.maxEntries);
    }

    private jh[] resizeGroup(jh[] jhArray) {
        return this.resizeMultiple(jhArray, this.numJoints);
    }

    private jh[] resizeMultiple(jh[] jhArray, int n2) {
        return TDoubleArrayListRegistry.resizeMultiple(jhArray, n2, this.maxEntries);
    }

    private jh resizeSingle(jh jh2) {
        return TDoubleArrayListRegistry.resizeSingle(jh2, this.maxEntries);
    }

    @Override
    public void onInvalidate() {
        this.timeLookup = this.time.a();
        if (this.timeLookup.length > 0) {
            for (int i2 = 0; i2 < this.numJoints; ++i2) {
                jh jh2 = this.totalPacketLoss[i2];
                double d2 = jh2.a(0);
                int n2 = 0;
                while (n2 < this.timeLookup.length) {
                    double d3 = jh2.a(n2) - d2;
                    int n3 = n2++;
                    jh jh3 = jh2;
                    jh3.b[n3] = d3;
                }
            }
        }
    }

    @Override
    public void onGroupFeedback(double d2, FlatFeedback[] flatFeedbackArray, FlatFeedback[] flatFeedbackArray2) {
        if (flatFeedbackArray2.length == 0) {
            return;
        }
        this.time.d(d2);
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.numJoints; ++i2) {
            this.positionCmd[i2].d(flatFeedbackArray2[i2].positionCmd);
            this.velocityCmd[i2].d(flatFeedbackArray2[i2].velocityCmd);
            this.effortCmd[i2].d(flatFeedbackArray2[i2].effortCmd);
            this.position[i2].d(flatFeedbackArray2[i2].position);
            this.velocity[i2].d(flatFeedbackArray2[i2].velocity);
            this.effort[i2].d(flatFeedbackArray2[i2].effort);
            this.pwmCmd[i2].d(flatFeedbackArray2[i2].pwmCmd);
            this.voltage[i2].d(flatFeedbackArray2[i2].voltage);
            this.motorCurrent[i2].d(flatFeedbackArray2[i2].motorCurrent);
            this.windingTemperature[i2].d(flatFeedbackArray2[i2].windingTemperature);
            this.rxSequence[i2].d(flatFeedbackArray2[i2].rxSequence);
            this.gyroX[i2].d(flatFeedbackArray2[i2].gyroX);
            this.gyroY[i2].d(flatFeedbackArray2[i2].gyroY);
            this.gyroZ[i2].d(flatFeedbackArray2[i2].gyroZ);
            this.pressure[i2].d(flatFeedbackArray2[i2].pressure);
            this.focIdCmd[i2].d(flatFeedbackArray2[i2].focIdCmd);
            this.focId[i2].d(flatFeedbackArray2[i2].focId);
            this.focIqCmd[i2].d(flatFeedbackArray2[i2].focIqCmd);
            this.focIq[i2].d(flatFeedbackArray2[i2].focIq);
            this.focVdCmd[i2].d(flatFeedbackArray2[i2].focVdCmd);
            this.focVd[i2].d(flatFeedbackArray2[i2].focVd);
            this.focVqCmd[i2].d(flatFeedbackArray2[i2].focVqCmd);
            this.focVq[i2].d(flatFeedbackArray2[i2].focVq);
            this.phaseCurrentA[i2].d(flatFeedbackArray2[i2].phaseCurrentA);
            this.phaseCurrentB[i2].d(flatFeedbackArray2[i2].phaseCurrentB);
            this.phaseCurrentC[i2].d(flatFeedbackArray2[i2].phaseCurrentC);
            this.phaseVoltageA[i2].d(flatFeedbackArray2[i2].phaseVoltageA);
            this.phaseVoltageB[i2].d(flatFeedbackArray2[i2].phaseVoltageB);
            this.phaseVoltageC[i2].d(flatFeedbackArray2[i2].phaseVoltageC);
            this.phaseDutyCycleA[i2].d(flatFeedbackArray2[i2].phaseDutyCycleA);
            this.phaseDutyCycleB[i2].d(flatFeedbackArray2[i2].phaseDutyCycleB);
            this.phaseDutyCycleC[i2].d(flatFeedbackArray2[i2].phaseDutyCycleC);
            this.hallState[i2].d(flatFeedbackArray2[i2].hallState);
            this.motorPosition[i2].d(flatFeedbackArray2[i2].motorPosition);
            this.motorVelocity[i2].d(flatFeedbackArray2[i2].motorVelocity);
            this.deflection[i2].d(flatFeedbackArray2[i2].deflection);
            this.innerEncoderPosition[i2].d(flatFeedbackArray2[i2].position - flatFeedbackArray2[i2].deflection);
            this.springStiffness[i2].d(flatFeedbackArray2[i2].effort / -flatFeedbackArray2[i2].deflection);
            double d4 = flatFeedbackArray2[i2].voltage * flatFeedbackArray2[i2].motorCurrent;
            this.power[i2].d(d4);
            if (!Double.isNaN(d4)) {
                d3 += d4;
                double d5 = flatFeedbackArray2[i2].time - flatFeedbackArray[i2].time;
                if (!Double.isNaN(d5)) {
                    this.integratedTotalPower += d5 * d4;
                }
            }
            this.roundTripTime[i2].d(1000.0 * (flatFeedbackArray2[i2].pcRxTime - flatFeedbackArray2[i2].pcTxTime));
            this.hwResponseTime[i2].d(1000.0 * (flatFeedbackArray2[i2].hwTxTime - flatFeedbackArray2[i2].hwRxTime));
            this.transmitTimeDelta[i2].d(1000.0 * (flatFeedbackArray2[i2].pcTxTime - flatFeedbackArray[i2].pcTxTime));
            this.packetLoss[i2].d(flatFeedbackArray2[i2].sequence - flatFeedbackArray[i2].sequence - 1.0);
            this.totalPacketLoss[i2].d(flatFeedbackArray2[i2].sequence - flatFeedbackArray2[i2].rxSequence);
        }
        this.systemPower[0].d(d3);
        this.systemPower[1].d(this.integratedTotalPower / 3600.0);
        FlatFeedback flatFeedback = flatFeedbackArray2[0];
        this.firstAccel[0].d(flatFeedback.accelX);
        this.firstAccel[1].d(flatFeedback.accelY);
        this.firstAccel[2].d(flatFeedback.accelZ);
        this.firstOrientation[0].d(flatFeedback.orientationW);
        this.firstOrientation[1].d(flatFeedback.orientationX);
        this.firstOrientation[2].d(flatFeedback.orientationY);
        this.firstOrientation[3].d(flatFeedback.orientationZ);
    }

    private void resize() {
        this.integratedTotalPower = 0.0;
        this.time = this.resizeSingle(this.time);
        this.positionCmd = this.resizeGroup(this.positionCmd);
        this.velocityCmd = this.resizeGroup(this.velocityCmd);
        this.effortCmd = this.resizeGroup(this.effortCmd);
        this.position = this.resizeGroup(this.position);
        this.velocity = this.resizeGroup(this.velocity);
        this.effort = this.resizeGroup(this.effort);
        this.pwmCmd = this.resizeGroup(this.pwmCmd);
        this.voltage = this.resizeGroup(this.voltage);
        this.motorCurrent = this.resizeGroup(this.motorCurrent);
        this.windingTemperature = this.resizeGroup(this.windingTemperature);
        this.rxSequence = this.resizeGroup(this.rxSequence);
        this.gyroX = this.resizeGroup(this.gyroX);
        this.gyroY = this.resizeGroup(this.gyroY);
        this.gyroZ = this.resizeGroup(this.gyroZ);
        this.pressure = this.resizeGroup(this.pressure);
        this.focIdCmd = this.resizeGroup(this.focIdCmd);
        this.focId = this.resizeGroup(this.focId);
        this.focIqCmd = this.resizeGroup(this.focIqCmd);
        this.focIq = this.resizeGroup(this.focIq);
        this.focVdCmd = this.resizeGroup(this.focVdCmd);
        this.focVd = this.resizeGroup(this.focVd);
        this.focVqCmd = this.resizeGroup(this.focVqCmd);
        this.focVq = this.resizeGroup(this.focVq);
        this.phaseCurrentA = this.resizeGroup(this.phaseCurrentA);
        this.phaseCurrentB = this.resizeGroup(this.phaseCurrentB);
        this.phaseCurrentC = this.resizeGroup(this.phaseCurrentC);
        this.phaseVoltageA = this.resizeGroup(this.phaseVoltageA);
        this.phaseVoltageB = this.resizeGroup(this.phaseVoltageB);
        this.phaseVoltageC = this.resizeGroup(this.phaseVoltageC);
        this.phaseDutyCycleA = this.resizeGroup(this.phaseDutyCycleA);
        this.phaseDutyCycleB = this.resizeGroup(this.phaseDutyCycleB);
        this.phaseDutyCycleC = this.resizeGroup(this.phaseDutyCycleC);
        this.hallState = this.resizeGroup(this.hallState);
        this.motorPosition = this.resizeGroup(this.motorPosition);
        this.motorVelocity = this.resizeGroup(this.motorVelocity);
        this.deflection = this.resizeGroup(this.deflection);
        this.innerEncoderPosition = this.resizeGroup(this.innerEncoderPosition);
        this.springStiffness = this.resizeGroup(this.springStiffness);
        this.power = this.resizeGroup(this.power);
        this.systemPower = this.resizeMultiple(this.systemPower, 2);
        this.roundTripTime = this.resizeGroup(this.roundTripTime);
        this.hwResponseTime = this.resizeGroup(this.hwResponseTime);
        this.transmitTimeDelta = this.resizeGroup(this.transmitTimeDelta);
        this.packetLoss = this.resizeGroup(this.packetLoss);
        this.totalPacketLoss = this.resizeGroup(this.totalPacketLoss);
        this.firstAccel = this.resizeMultiple(this.firstAccel, 3);
        this.firstOrientation = this.resizeMultiple(this.firstOrientation, 4);
    }

    public void getCharts(ChartList chartList) {
        chartList.setTime(this.time).setTraceType(awf.a).addCommandChart(ChartCategory.Commands, "Position", "rad", -1.5707963267948966, 1.5707963267948966, this.positionCmd, this.position).addErrorChart(ChartCategory.Commands, "Position error", "rad", 0.0, 0.05, this.positionCmd, this.position).addCommandChart(ChartCategory.Commands, "Velocity", "rad/s", -5.0, 5.0, this.velocityCmd, this.velocity).addErrorChart(ChartCategory.Commands, "Velocity error", "rad/s", 0.0, 0.05, this.velocityCmd, this.velocity).addCommandChart(ChartCategory.Commands, "Torque", "Nm", -5.0, 5.0, this.effortCmd, this.effort).addErrorChart(ChartCategory.Commands, "Torque error", "Nm", 0.0, 0.05, this.effortCmd, this.effort).addDeviceChart(ChartCategory.Actuator, "PWM", "0-1", -1.0, 1.0, this.pwmCmd).addDeviceChart(ChartCategory.Actuator, "Power", "W", 0.0, 1.0, this.power).addDeviceChart(ChartCategory.Actuator, "Voltage", "V", 0.0, 50.0, this.voltage).addDeviceChart(ChartCategory.Actuator, "Motor current", "A", 0.0, 1.0, this.motorCurrent).addDeviceChart(ChartCategory.Actuator, "Winding temperature", "\u00b0C", 0.0, 100.0, this.windingTemperature).addAsHistogram(ChartCategory.Actuator, "Winding temperature %", "\u00b0C", this.windingTemperature).addDeviceChart(ChartCategory.Actuator, "Pressure", "kPa", 0.0, 150.0, this.pressure).addSingleTrace(ChartCategory.Actuator, "System power ", "W", 0.0, 10.0, this.systemPower[0]).addSingleTrace(ChartCategory.Actuator, "System energy use", "Wh", 0.0, 1.0, this.systemPower[1]).addCommandChart(ChartCategory.MotorDriver, "FOC Id", "A", -1.0, 1.0, this.focIdCmd, this.focId).addErrorChart(ChartCategory.MotorDriver, "FOC Id error", "A", -1.0, 1.0, this.focIdCmd, this.focId).addCommandChart(ChartCategory.MotorDriver, "FOC Iq", "A", -1.0, 1.0, this.focIqCmd, this.focIq).addErrorChart(ChartCategory.MotorDriver, "FOC Iq error", "A", -1.0, 1.0, this.focIqCmd, this.focIq).addCommandChart(ChartCategory.MotorDriver, "FOC Vd", "V", -1.0, 1.0, this.focVdCmd, this.focVd).addErrorChart(ChartCategory.MotorDriver, "FOC Vd error", "V", -1.0, 1.0, this.focVdCmd, this.focVd).addCommandChart(ChartCategory.MotorDriver, "FOC Vq", "V", -1.0, 1.0, this.focVqCmd, this.focVq).addErrorChart(ChartCategory.MotorDriver, "FOC Vq error", "V", -1.0, 1.0, this.focVqCmd, this.focVq).addPhaseChart(ChartCategory.MotorDriver, "Phase current", "A", -1.0, 1.0, this.phaseCurrentA, this.phaseCurrentB, this.phaseCurrentC).addPhaseChart(ChartCategory.MotorDriver, "Phase voltage", "V", -1.0, 1.0, this.phaseVoltageA, this.phaseVoltageB, this.phaseVoltageC).addPhaseChart(ChartCategory.MotorDriver, "Phase duty cycle", "0-1", -1.0, 1.0, this.phaseDutyCycleA, this.phaseDutyCycleB, this.phaseDutyCycleC).addDeviceChart(ChartCategory.MotorDriver, "Motor position", "rad", Double.NaN, Double.NaN, this.motorPosition).addDeviceChart(ChartCategory.MotorDriver, "Motor velocity", "rad/s", Double.NaN, Double.NaN, this.motorVelocity).addDeviceChart(ChartCategory.MotorDriver, "Hall state", "enum", 0.0, 6.0, this.hallState).setTraceType(awf.c).addDeviceChart(ChartCategory.Network, "Round trip time", "ms", 0.0, 0.5, this.roundTripTime).addAsHistogram(ChartCategory.Network, "Round trip time %", "ms", this.roundTripTime).addMedianBarChart(ChartCategory.Network, "Round trip time / Index", avr.a("Median round trip time", "ms").a(0.0, 0.5, false), this.roundTripTime).addDeviceChart(ChartCategory.Network, "Hardware response time", "ms", 0.0, 0.5, this.hwResponseTime).addAsHistogram(ChartCategory.Network, "Hardware response time %", "ms", this.hwResponseTime).addDeviceChart(ChartCategory.Network, "Transmit time delta", "ms", 0.0, 0.5, this.transmitTimeDelta).addAsHistogram(ChartCategory.Network, "Transmit time delta %", "ms", this.transmitTimeDelta).addDeviceChart(ChartCategory.Network, "Packet loss", null, 0.0, 1.0, this.packetLoss).addAsHistogram(ChartCategory.Network, "Packet loss %", null, this.packetLoss).addDeviceChart(ChartCategory.Network, "Rx sequence", null, 0.0, 1.0, this.rxSequence).addDeviceChart(ChartCategory.Network, "Total packet loss", null, 0.0, 1.0, this.totalPacketLoss).addIndexBarChart(ChartCategory.Network, "Total packet loss / index", avr.a("Total packet loss", null), n2 -> this.totalPacketLoss[n2].a(this.totalPacketLoss[n2].size() - 1), this.numJoints).setTraceType(awf.a).addXyzChart(ChartCategory.BaseImu, "Accelerometer", "m/s^2", -10.0, 10.0, this.firstAccel).addXyzChart(ChartCategory.BaseImu, "Gyroscope", "rad/s", -3.0, 3.0, new jh[]{this.gyroX[0], this.gyroY[0], this.gyroZ[0]}).addQuaternionTraces(ChartCategory.BaseImu, "Orientation", this.firstOrientation).addDeviceChart(ChartCategory.Encoders, "Inner position", "rad", -1.5707963267948966, 1.5707963267948966, this.innerEncoderPosition).addDeviceChart(ChartCategory.Encoders, "Deflection", "rad", -0.1, 0.1, this.deflection).addDeviceChart(ChartCategory.Encoders, "Stiffness", "Nm/rad", 0.0, 130.0, this.springStiffness).addDeviceXY(ChartCategory.Encoders, "Stiffness / deflection", avr.a("Deflection", "rad").a(-0.1, 0.1, false), this.deflection, avr.a("Stiffness", "Nm/rad").a(0.0, 130.0, false), this.springStiffness).addDeviceXY(ChartCategory.Encoders, "Effort / deflection", avr.a("Deflection", "rad").a(-0.1, 0.1, false), this.deflection, avr.a("Effort", "Nm").a(0.0, 130.0, false), this.effort);
    }
}

